/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.arima.estimation.GlsArimaMonitor;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.arima.special.GaSpecification;
import ec.tstoolkit.arima.special.GeneralizedAirlineMapper;
import ec.tstoolkit.arima.special.GeneralizedAirlineModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.data.TableOfInt;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.HannanRissanen;
import ec.tstoolkit.sarima.estimation.SarimaMapping;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class GeneralizedAirlineMonitor {
    private GaSpecification m_spec = new GaSpecification();
    private RegArimaEstimation<GeneralizedAirlineModel>[] m_rslts;
    private TsData m_series;
    private TsVariableList m_regs;
    private DataBlock m_starthr;
    private DataBlock m_startairline;
    private static final double m_urbound = 0.98;
    private boolean m_bfreeestimation = true;
    private boolean m_mean;
    private final HashMap<Long, RegArimaEstimation<GeneralizedAirlineModel>> m_smodel = new HashMap();
    private static final int m_nsel = 5;

    public boolean process(TsData series, TsVariableList saregs) {
        if (series == null) {
            return false;
        }
        this.m_smodel.clear();
        this.m_rslts = null;
        this.m_series = series;
        this.m_regs = saregs;
        int freq = this.m_series.getFrequency().intValue();
        RegArimaModel<GeneralizedAirlineModel> regs = this.buildModel(null);
        if (this.m_spec.getEstimationMode() == GaSpecification.EstimationMode.Exhaustive) {
            return this.exhaustiveEstimation(freq, regs);
        }
        if (this.m_spec.getEstimationMode() == GaSpecification.EstimationMode.Iterative) {
            return this.recursiveEstimation(freq, regs);
        }
        return this.selectiveEstimation(freq, regs);
    }

    private boolean selectiveEstimation(int freq, RegArimaModel<GeneralizedAirlineModel> regs) {
        this.m_rslts = new RegArimaEstimation[1];
        if (!this.calcInitialValues(freq, regs)) {
            return false;
        }
        TableOfInt C = this.m_spec.generateParameters(freq);
        if (C == null || C.getRowsCount() == 0) {
            return true;
        }
        double[] derivative = new double[freq / 2];
        int[] c = new int[freq / 2];
        for (int i = 0; i < c.length; ++i) {
            c[i] = 1;
        }
        double ll = this.m_rslts[0].likelihood.getLogLikelihood();
        double[] val = ((GeneralizedAirlineModel)this.m_rslts[0].model.getArima()).getCoefficients();
        double[] np = new double[3];
        np[0] = val[0];
        np[1] = val[1];
        double h = 0.001;
        int df = this.m_rslts[0].likelihood.getN() - this.m_rslts[0].likelihood.getNx();
        for (int i = 0; i < freq / 2; ++i) {
            c[i] = 2;
            np[2] = val[1] - h;
            GeneralizedAirlineModel gairline2 = new GeneralizedAirlineModel(freq, np, SubArrayOfInt.create(c));
            regs.setArima(gairline2);
            double ll1 = regs.computeLikelihood().getLogLikelihood();
            if (1.0 - np[2] < h) {
                derivative[i] = (ll - ll1) / (h * (double)df);
            } else {
                gairline2.setParameter(2, val[1] + h);
                double ll2 = regs.computeLikelihood().getLogLikelihood();
                derivative[i] = (ll2 - ll1) / (2.0 * h * (double)df);
            }
            c[i] = 1;
        }
        int nparams = this.m_spec.isFreeZeroFrequencyParameter() ? 4 : 3;
        double[] drank = new double[C.getRowsCount()];
        for (int i = 0; i < drank.length; ++i) {
            int nr = 0;
            double d0 = 0.0;
            double d1 = 0.0;
            for (int j = 0; j < C.getColumnsCount(); ++j) {
                if (C.get(i, j) == nparams - 1) {
                    d0 += derivative[j];
                    ++nr;
                    continue;
                }
                d1 += derivative[j];
            }
            drank[i] = Math.abs((d0 /= Math.sqrt(nr)) - (d1 /= Math.sqrt(C.getColumnsCount() - nr)));
        }
        double[] tmp = new double[drank.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = Math.abs(drank[i]);
        }
        Arrays.sort(tmp);
        int nsel = Math.min(tmp.length / 3, 5);
        if (nsel <= 0) {
            nsel = 1;
        }
        double threshold = Math.max(tmp[tmp.length - nsel], tmp[tmp.length - 1] / 3.0);
        ArrayList<RegArimaEstimation<GeneralizedAirlineModel>> rtmp = new ArrayList<RegArimaEstimation<GeneralizedAirlineModel>>();
        for (int i = 0; i < C.getRowsCount(); ++i) {
            try {
                if (!(Math.abs(drank[i]) >= threshold)) continue;
                rtmp.add(this.estimate(freq, regs, C.row(i)));
                continue;
            }
            catch (Exception j) {
                // empty catch block
            }
        }
        RegArimaEstimation[] rslts = new RegArimaEstimation[rtmp.size() + 1];
        rslts[0] = this.m_rslts[0];
        int ir = 1;
        for (RegArimaEstimation regArimaEstimation : rtmp) {
            rslts[ir++] = regArimaEstimation;
        }
        this.m_rslts = rslts;
        return true;
    }

    private boolean recursiveEstimation(int freq, RegArimaModel<GeneralizedAirlineModel> regs) {
        int freq2 = freq / 2;
        int nm = 1;
        int i = 1;
        for (int j = freq2; i <= this.m_spec.getMaxFrequencyGroup() && j > 0; ++i, --j) {
            if (i < this.m_spec.getMinFrequencyGroup()) continue;
            nm += j;
        }
        this.m_rslts = new RegArimaEstimation[nm + 1];
        if (!this.calcInitialValues(freq, regs)) {
            return false;
        }
        int[] C = new int[freq2];
        int istart = this.m_spec.isFreeZeroFrequencyParameter() ? 2 : 1;
        for (int i2 = 0; i2 < freq2; ++i2) {
            C[i2] = istart;
        }
        int ridx = 0;
        for (int i3 = 1; i3 <= this.m_spec.getMaxFrequencyGroup(); ++i3) {
            ridx = this.RCalc(i3 >= this.m_spec.getMinFrequencyGroup(), ridx, freq, regs, SubArrayOfInt.create(C));
        }
        return true;
    }

    private int RCalc(boolean save, int ridx, int freq, RegArimaModel<GeneralizedAirlineModel> regs, SubArrayOfInt C) {
        int q = this.m_spec.isFreeZeroFrequencyParameter() ? 3 : 2;
        int jbest = -1;
        double ll = Double.MIN_VALUE;
        for (int j = 0; j < C.getLength(); ++j) {
            if (C.get(j) == q) continue;
            C.set(j, q);
            RegArimaEstimation<GeneralizedAirlineModel> est = this.estimate(freq, regs, C);
            if (save) {
                this.m_rslts[++ridx] = est;
            }
            if (est != null) {
                double curll = est.likelihood.getLogLikelihood();
                if (jbest < 0 || curll >= ll) {
                    jbest = j;
                    ll = curll;
                }
            }
            C.set(j, q - 1);
        }
        if (jbest >= 0) {
            C.set(jbest, q);
        }
        return ridx;
    }

    private boolean exhaustiveEstimation(int freq, RegArimaModel<GeneralizedAirlineModel> regs) {
        TableOfInt C = this.m_spec.generateParameters(freq);
        int n = C.getRowsCount() + 1;
        this.m_rslts = new RegArimaEstimation[n];
        if (!this.calcInitialValues(freq, regs)) {
            return false;
        }
        for (int i = 1; i < this.m_rslts.length; ++i) {
            try {
                this.m_rslts[i] = this.estimate(freq, regs, C.row(i - 1));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private RegArimaModel<GeneralizedAirlineModel> buildModel(int[] c) {
        int np = 2;
        if (c != null) {
            np = this.m_spec.isFreeZeroFrequencyParameter() ? 4 : 3;
        }
        GeneralizedAirlineModel model = new GeneralizedAirlineModel(this.m_series.getFrequency().intValue(), np, c);
        RegArimaModel<GeneralizedAirlineModel> regModel = new RegArimaModel<GeneralizedAirlineModel>(model, new DataBlock(this.m_series.internalStorage()));
        regModel.setMeanCorrection(this.m_mean);
        if (this.m_regs != null) {
            List<DataBlock> X = this.m_regs.all().data(this.m_series.getDomain());
            for (DataBlock x : X) {
                regModel.addX(x);
            }
        }
        return regModel;
    }

    private RegArimaEstimation<GeneralizedAirlineModel> estimate(int freq, RegArimaModel<GeneralizedAirlineModel> regs, SubArrayOfInt c) {
        GeneralizedAirlineModel gairline;
        RegArimaEstimation<GeneralizedAirlineModel> e;
        int nparams;
        int n = nparams = this.m_spec.isFreeZeroFrequencyParameter() ? 4 : 3;
        if (this.m_bfreeestimation && (e = this.estimate(regs, gairline = new GeneralizedAirlineModel(freq, nparams, c))) != null && e.likelihood != null && (this.m_rslts[0] == null || e.likelihood.getLogLikelihood() >= this.m_rslts[0].likelihood.getLogLikelihood())) {
            return e;
        }
        if (nparams == 3) {
            return this.estimate3(freq, regs, c);
        }
        return this.estimate4(freq, regs, c);
    }

    private RegArimaEstimation<GeneralizedAirlineModel> estimate3(int freq, RegArimaModel<GeneralizedAirlineModel> regs, SubArrayOfInt c) {
        RegArimaEstimation<GeneralizedAirlineModel> est = this.estimate3(freq, regs, this.m_startairline, c, true);
        if (est == null || est.likelihood == null || est.likelihood.getLogLikelihood() < this.m_rslts[0].likelihood.getLogLikelihood()) {
            return this.estimate3(freq, regs, this.m_startairline, c, false);
        }
        return est;
    }

    private RegArimaEstimation<GeneralizedAirlineModel> estimate3(int freq, RegArimaModel<GeneralizedAirlineModel> regs, DataBlock p, SubArrayOfInt c, boolean checkur) {
        RegArimaEstimation<GeneralizedAirlineModel> rslt;
        long ckey = GeneralizedAirlineModel.CKey(c);
        if (!checkur && this.m_smodel.containsKey(ckey)) {
            this.m_smodel.remove(ckey);
        }
        if ((rslt = this.m_smodel.get(ckey)) == null) {
            GeneralizedAirlineModel gairline = new GeneralizedAirlineModel(freq, 3, p.get(0), p.get(1), c);
            if (checkur) {
                gairline.checkRoots(0.98);
            }
            regs.setArima(gairline);
            rslt = this.estimate(regs, gairline);
            if (!checkur) {
                this.m_smodel.put(ckey, rslt);
            }
        }
        return rslt;
    }

    private RegArimaEstimation<GeneralizedAirlineModel> estimate4(int freq, RegArimaModel<GeneralizedAirlineModel> regs, SubArrayOfInt c) {
        DataBlock pinit = null;
        int[] C3 = new int[c.getLength()];
        SubArrayOfInt c3 = SubArrayOfInt.create(C3);
        c3.copy(c);
        int nr = 0;
        for (int i = 0; i < c3.getLength(); ++i) {
            c3.set(i, c3.get(i) - 1);
            if (c3.get(i) != 0) continue;
            ++nr;
        }
        if (c.getLength() % 2 == 0 && nr == c.getLength() / 2) {
            RegArimaEstimation<GeneralizedAirlineModel> g31 = this.estimate3(freq, regs, c3);
            for (int i = 0; i < c3.getLength(); ++i) {
                if (c3.get(i) == 1) {
                    c3.set(i, 0);
                    continue;
                }
                c3.set(i, 1);
            }
            RegArimaEstimation<GeneralizedAirlineModel> g32 = this.estimate3(freq, regs, c3);
            if (g31 != null && g32 != null && g31.likelihood != null && g32.likelihood != null) {
                pinit = g31.likelihood.getLogLikelihood() > g32.likelihood.getLogLikelihood() ? new DataBlock(((GeneralizedAirlineModel)g31.model.getArima()).getParameters()) : new DataBlock(((GeneralizedAirlineModel)g32.model.getArima()).getParameters());
            } else if (g31 != null) {
                pinit = new DataBlock(((GeneralizedAirlineModel)g31.model.getArima()).getParameters());
            } else if (g32 != null) {
                pinit = new DataBlock(((GeneralizedAirlineModel)g32.model.getArima()).getParameters());
            }
        } else {
            RegArimaEstimation<GeneralizedAirlineModel> g3 = this.estimate3(freq, regs, c3);
            if (g3 != null && g3.likelihood != null && g3.likelihood.getLogLikelihood() > this.m_rslts[0].likelihood.getLogLikelihood()) {
                pinit = new DataBlock(((GeneralizedAirlineModel)g3.model.getArima()).getCoefficients());
            }
        }
        RegArimaEstimation<GeneralizedAirlineModel> est = this.estimate4(freq, regs, pinit, c, true);
        if (est == null || est.likelihood == null || est.likelihood.getLogLikelihood() < this.m_rslts[0].likelihood.getLogLikelihood()) {
            return this.estimate4(freq, regs, pinit, c, false);
        }
        return est;
    }

    private RegArimaEstimation<GeneralizedAirlineModel> estimate4(int freq, RegArimaModel<GeneralizedAirlineModel> regs, IReadDataBlock p, SubArrayOfInt c, boolean checkur) {
        double p0;
        double[] xp = new double[4];
        if (p != null) {
            p0 = p.get(0);
            double p1 = p.get(1);
            if (p0 >= 0.98) {
                p0 = 0.98;
            }
            if (p1 >= 0.98) {
                p1 = 0.98;
            }
            xp[0] = -(p0 + p1);
            xp[1] = p0 * p1;
            xp[2] = p.get(1);
            xp[3] = p.get(2);
        } else {
            p0 = this.m_startairline.get(0);
            double p1 = this.m_startairline.get(1);
            if (p0 >= 0.98) {
                p0 = 0.98;
            }
            if (p1 >= 0.98) {
                p1 = 0.98;
            }
            xp[0] = -(p0 + p1);
            xp[1] = p0 * p1;
            xp[2] = this.m_startairline.get(1);
            xp[3] = this.m_startairline.get(1);
        }
        GeneralizedAirlineModel gairline = new GeneralizedAirlineModel(freq, xp, c);
        if (checkur) {
            gairline.checkRoots(0.98);
        }
        regs.setArima(gairline);
        return this.estimate(regs, gairline);
    }

    private RegArimaEstimation<GeneralizedAirlineModel> estimate(RegArimaModel<GeneralizedAirlineModel> regs, GeneralizedAirlineModel gairline) {
        try {
            boolean ok = false;
            GlsArimaMonitor<GeneralizedAirlineModel> monitor = new GlsArimaMonitor<GeneralizedAirlineModel>();
            monitor.setMinimizer(new ProxyMinimizer(new LevenbergMarquardtMethod()));
            RegArimaEstimation<GeneralizedAirlineModel> est = null;
            do {
                regs.setArima(gairline);
                GeneralizedAirlineMapper mapper = new GeneralizedAirlineMapper(gairline);
                monitor.setMapping(mapper);
                est = monitor.process(regs);
                ok = monitor.hasConverged();
                if (est == null) {
                    return null;
                }
                gairline = (GeneralizedAirlineModel)est.model.getArima();
                mapper.setStrict(true);
                DataBlock p = new DataBlock(mapper.map(gairline));
                if (mapper.validate(p) != ParamValidation.Changed) continue;
                gairline = mapper.map(p);
                est.model.setArima(gairline);
            } while (this.m_spec.isFixingUnitRoots() && gairline.fixUnitRoots(ok ? 0.001 : 0.01) && gairline.getParametersCount() > 0);
            return est;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean calcInitialValues(int freq, RegArimaModel<GeneralizedAirlineModel> regs) {
        SarimaSpecification spec = new SarimaSpecification(freq);
        spec.airline();
        SarimaModel arima = new SarimaModel(spec);
        HannanRissanen hr = new HannanRissanen();
        boolean ok = false;
        if (regs.getVarsCount() > 0) {
            Ols ols = new Ols();
            ols.process(regs.getDModel());
            ok = hr.process(ols.getResiduals(), spec.doStationary());
        } else {
            ok = hr.process(regs.getDModel().getY(), spec.doStationary());
        }
        if (ok) {
            arima.setParameters(hr.getModel().getParameters());
            SarimaMapping.stabilize(arima);
        } else {
            DataBlock start = new DataBlock(2);
            start.set(0, -0.95);
            start.set(1, -0.95);
            arima.setParameters(start);
        }
        this.m_starthr = new DataBlock(arima.getParameters());
        this.m_starthr.set(0, -this.m_starthr.get(0));
        double sq = -this.m_starthr.get(1);
        if (sq < 0.0) {
            sq = 0.2;
        }
        this.m_starthr.set(1, Math.pow(sq, 1.0 / (double)freq));
        GeneralizedAirlineModel gairline = new GeneralizedAirlineModel(freq, 2, this.m_starthr.get(0), this.m_starthr.get(1), null);
        this.m_rslts[0] = this.estimate(regs, gairline);
        if (this.m_rslts[0] == null) {
            return false;
        }
        this.m_startairline = new DataBlock(((GeneralizedAirlineModel)this.m_rslts[0].model.getArima()).getCoefficients());
        return true;
    }

    public int searchBestEstimation() {
        if (this.m_rslts == null) {
            return -1;
        }
        double c = Double.MAX_VALUE;
        int imax = -1;
        for (int i = 0; i < this.m_rslts.length; ++i) {
            if (this.m_rslts[i] == null) continue;
            GeneralizedAirlineModel ga = (GeneralizedAirlineModel)this.m_rslts[i].model.getArima();
            ConcentratedLikelihood ll = this.m_rslts[i].likelihood;
            if (ga == null || ll == null) continue;
            int np = ga.getType() + ll.getNx();
            double cur = 0.0;
            cur = this.m_spec.getCriterion() == GaSpecification.Criterion.AIC ? ll.AIC(np) : ll.BIC(np);
            if (!(cur < c)) continue;
            imax = i;
            c = cur;
        }
        return imax;
    }

    public RegArimaEstimation<GeneralizedAirlineModel> result(int idx) {
        if (this.m_rslts == null) {
            return null;
        }
        return this.m_rslts[idx];
    }

    public RegArimaEstimation<GeneralizedAirlineModel> getBestResult() {
        if (this.m_rslts == null) {
            return null;
        }
        int imax = this.searchBestEstimation();
        if (imax == -1) {
            return null;
        }
        return this.result(imax);
    }

    public int getResultsCount() {
        return this.m_rslts == null ? 0 : this.m_rslts.length;
    }

    public int getValidResultsCount() {
        if (this.m_rslts == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.m_rslts.length; ++i) {
            if (this.m_rslts[i] == null) continue;
            ++n;
        }
        return n;
    }

    public GaSpecification getSpecification() {
        return this.m_spec;
    }

    public void setSpecification(GaSpecification value) {
        this.m_spec = value.clone();
    }

    public boolean isFreeEstimation() {
        return this.m_bfreeestimation;
    }

    public void setFreeEstimation(boolean value) {
        this.m_bfreeestimation = value;
    }

    public boolean isMeanCorrection() {
        return this.m_mean;
    }

    public void setMeanCorrection(boolean value) {
        this.m_mean = value;
    }
}

