/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.functions.MathFunctionWithDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithIntegral;

public class ShiftedMathFunction
implements MathFunction,
MathFunctionWithFirstDerivative,
MathFunctionWithDerivative,
MathFunctionWithIntegral {
    MathFunction func;
    double delta;

    public ShiftedMathFunction(MathFunction mathFunction, double d) {
        if (mathFunction == null) {
            throw new NullPointerException();
        }
        this.func = mathFunction;
        this.delta = d;
    }

    public MathFunction getFunction() {
        return this.func;
    }

    public double getDelta() {
        return this.delta;
    }

    public double evaluate(double d) {
        return this.func.evaluate(d) - this.delta;
    }

    public double derivative(double d) {
        return MathFunctionUtil.derivative(this.func, d);
    }

    public double derivative(double d, int n) {
        return MathFunctionUtil.derivative(this.func, d, n);
    }

    public double integral(double d, double d2) {
        return MathFunctionUtil.integral(this.func, d, d2) - (d2 - d) * this.getDelta();
    }
}

