/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.text;

import edu.cens.text.AbstractTermFrequencyViewer;
import edu.cens.text.FrequencyBarChartViewer;
import edu.cens.text.FrequencyTotalViewer;
import edu.cens.text.WordCloudViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.rosuda.deducer.toolkit.HelpButton;

public class TermFrequencyDialog
extends JFrame {
    private static final String HELP_URL = "index.php?n=Main.WordCount";
    public static final int BAR_CHART = 1;
    public static final int TOTAL_FREQUENCIES = 0;
    public static final int WORD_CLOUD = 2;
    private boolean useDocumentFrequency = false;
    JTextField topPercentField;
    JTextField minFreqField;
    JTextField absoluteNTermsField;
    JComboBox corpusSelector;
    JComboBox viewMethodSelector;
    JRadioButton useAllButton = new JRadioButton();
    JRadioButton useTopNButton = new JRadioButton();
    JRadioButton useTopPercentButton = new JRadioButton();
    JPanel optionsPanel;
    GridBagConstraints optionsPanelConstraints;
    private AbstractTermFrequencyViewer[] viewers = new AbstractTermFrequencyViewer[]{new FrequencyTotalViewer(this), new FrequencyBarChartViewer(this), new WordCloudViewer(this)};

    public boolean getUseDocumentFrequency() {
        return this.useDocumentFrequency;
    }

    public TermFrequencyDialog(JFrame jFrame) {
        super("Term Frequency");
        this.constructGui();
        this.setDefaultCloseOperation(1);
    }

    public void setCorpora(String[] stringArray) {
        if (stringArray != null && this.corpusSelector != null) {
            this.corpusSelector.removeAllItems();
            for (String string : stringArray) {
                this.corpusSelector.addItem(string);
            }
        }
    }

    public void setViewMethod(int n) {
        this.viewMethodSelector.setSelectedIndex(n);
    }

    public void constructGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        JPanel jPanel = this.constructSourceDataSelectionPanel();
        JPanel jPanel2 = this.constructOkHelpPanel();
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.constructFilteringPanel(), gridBagConstraints);
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.constructViewMethodPanel(), gridBagConstraints);
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jPanel2, gridBagConstraints);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(false);
    }

    public int getMinFrequency() {
        return Integer.parseInt(this.minFreqField.getText());
    }

    public int getAbsoluteNTerms() {
        if (this.useTopNButton.isSelected()) {
            return Integer.parseInt(this.absoluteNTermsField.getText());
        }
        return 0;
    }

    public int getPercent() {
        if (this.useTopPercentButton.isSelected()) {
            return Integer.parseInt(this.topPercentField.getText());
        }
        return 0;
    }

    public String getCorpus() {
        if (this.corpusSelector.getSelectedItem() != null) {
            return this.corpusSelector.getSelectedItem().toString();
        }
        return null;
    }

    private GridBagConstraints getTopLevelLayoutDefaults() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        return gridBagConstraints;
    }

    private JPanel constructOkHelpPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JButton jButton = new JButton("View");
        JButton jButton2 = new JButton("Close");
        this.getRootPane().setDefaultButton(jButton);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TermFrequencyDialog.this.setVisible(false);
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TermFrequencyDialog.this.doVisualization();
            }
        };
        jButton.addActionListener(actionListener);
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        jPanel.add((Component)new HelpButton(HELP_URL), gridBagConstraints);
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel constructSourceDataSelectionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.ipady = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        JLabel jLabel = new JLabel("Source Data:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.corpusSelector = new JComboBox();
        this.corpusSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (AbstractTermFrequencyViewer abstractTermFrequencyViewer : TermFrequencyDialog.this.viewers) {
                    abstractTermFrequencyViewer.onCorpusChange(TermFrequencyDialog.this.getCorpus());
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.corpusSelector, gridBagConstraints);
        return jPanel;
    }

    private JPanel constructFrequencyMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JRadioButton jRadioButton = new JRadioButton("Term Frequency");
        JRadioButton jRadioButton2 = new JRadioButton("Document Frequency");
        jRadioButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TermFrequencyDialog.this.useDocumentFrequency = false;
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TermFrequencyDialog.this.useDocumentFrequency = true;
            }
        });
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        return jPanel;
    }

    private JPanel constructFilteringPanel() {
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.useAllButton = new JRadioButton();
        this.useTopNButton = new JRadioButton();
        this.useTopPercentButton = new JRadioButton();
        this.useTopNButton.setSelected(true);
        this.useAllButton.setPreferredSize(new Dimension(this.useAllButton.getPreferredSize().width, new JTextField().getPreferredSize().height));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useAllButton);
        buttonGroup.add(this.useTopNButton);
        buttonGroup.add(this.useTopPercentButton);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.useAllButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel("All Terms"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.useTopNButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("Top"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.absoluteNTermsField = new JTextField("100", 3);
        jPanel.add((Component)this.absoluteNTermsField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.useTopPercentButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("Top"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.topPercentField = new JTextField("20", 3);
        jPanel.add((Component)this.topPercentField, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel("%"), gridBagConstraints);
        TitledBorder titledBorder = new TitledBorder("Use:"){};
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new JLabel("Frequency :"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.minFreqField = new JTextField(4);
        this.minFreqField.setText("0");
        jPanel2.add((Component)this.minFreqField, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Filtering:"));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)new JLabel(""), gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)this.constructFrequencyMethodPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        return jPanel3;
    }

    private JPanel constructViewOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("View Options:"));
        JPanel jPanel2 = this.getSelectedViewer().getOptionsPanel();
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private JPanel constructViewMethodPanel() {
        final JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel("View As:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.viewMethodSelector = new JComboBox();
        jPanel.add((Component)this.viewMethodSelector, gridBagConstraints);
        final TermFrequencyDialog termFrequencyDialog = this;
        this.viewMethodSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TermFrequencyDialog.this.optionsPanel != null) {
                    jPanel.remove(TermFrequencyDialog.this.optionsPanel);
                    TermFrequencyDialog.this.optionsPanel = TermFrequencyDialog.this.constructViewOptionsPanel();
                    jPanel.add((Component)TermFrequencyDialog.this.optionsPanel, TermFrequencyDialog.this.optionsPanelConstraints);
                    termFrequencyDialog.setMinimumSize(null);
                    termFrequencyDialog.pack();
                    termFrequencyDialog.setMinimumSize(termFrequencyDialog.getSize());
                    jPanel.validate();
                    termFrequencyDialog.repaint();
                }
            }
        });
        for (AbstractTermFrequencyViewer abstractTermFrequencyViewer : this.viewers) {
            this.viewMethodSelector.addItem(abstractTermFrequencyViewer);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.optionsPanel = this.constructViewOptionsPanel();
        this.optionsPanel.setEnabled(false);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.optionsPanelConstraints = gridBagConstraints;
        jPanel.add((Component)this.optionsPanel, gridBagConstraints);
        return jPanel;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(bl);
    }

    public String getTermFreqCall(String string) {
        int n = this.getPercent();
        int n2 = this.getAbsoluteNTerms();
        int n3 = this.getMinFrequency();
        String string2 = "term.freq(d=" + this.getCorpus() + ", " + "percent=" + n + ", " + "topN=" + n2 + ", " + "minFreq=" + n3 + "," + "useDocFreq=" + ("" + this.useDocumentFrequency).toUpperCase() + "," + string + ")";
        return string2;
    }

    private void doVisualization() {
        if (this.getCorpus() == null) {
            JOptionPane.showMessageDialog(this.getContentPane(), "You do not have any corpuses to visualize!", "Warning", 2);
        } else {
            this.getSelectedViewer().executeView();
        }
    }

    private AbstractTermFrequencyViewer getSelectedViewer() {
        return (AbstractTermFrequencyViewer)this.viewMethodSelector.getSelectedItem();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        TermFrequencyDialog termFrequencyDialog = new TermFrequencyDialog(jFrame){

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (!bl) {
                    System.exit(0);
                }
            }
        };
        termFrequencyDialog.setCorpora(new String[0]);
        termFrequencyDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        termFrequencyDialog.setVisible(true);
        termFrequencyDialog.setDefaultCloseOperation(2);
    }
}

