/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.shrinkage;

import dr.inference.distribution.ExponentialTiltedStableDistribution;
import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.distributions.GammaDistribution;

public class BayesianBridgeShrinkageOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private final BayesianBridgeStatisticsProvider provider;
    private final Parameter globalScale;
    private final Parameter localScale;
    private final Parameter regressionExponent;
    private final int dim;
    private final GammaDistribution globalScalePrior;

    public BayesianBridgeShrinkageOperator(BayesianBridgeStatisticsProvider bayesianBridgeStatisticsProvider, GammaDistribution gammaDistribution, double d) {
        this.setWeight(d);
        this.provider = bayesianBridgeStatisticsProvider;
        this.globalScale = bayesianBridgeStatisticsProvider.getGlobalScale();
        this.localScale = bayesianBridgeStatisticsProvider.getLocalScale();
        this.regressionExponent = bayesianBridgeStatisticsProvider.getExponent();
        this.dim = bayesianBridgeStatisticsProvider.getDimension();
        this.globalScalePrior = gammaDistribution;
    }

    @Override
    public String getOperatorName() {
        return "bayesianBridgeGibbsOperator";
    }

    @Override
    public double doOperation() {
        if (this.globalScalePrior != null) {
            this.sampleGlobalScale();
        }
        if (this.localScale != null) {
            this.sampleLocalScale();
        }
        return 0.0;
    }

    private void sampleGlobalScale() {
        double d = this.globalScalePrior.getShape();
        double d2 = this.globalScalePrior.getScale();
        double d3 = this.regressionExponent.getParameterValue(0);
        double d4 = (double)this.dim / d3;
        double d5 = this.absSumBeta();
        if (d > 0.0) {
            d4 += d;
            d5 += 1.0 / d2;
        }
        double d6 = GammaDistribution.nextGamma(d4, 1.0 / d5);
        double d7 = Math.pow(d6, -1.0 / d3);
        this.globalScale.setParameterValue(0, d7);
    }

    private double absSumBeta() {
        double d = this.regressionExponent.getParameterValue(0);
        double d2 = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            d2 += Math.pow(Math.abs(this.provider.getCoefficient(i)), d);
        }
        return d2;
    }

    private void sampleLocalScale() {
        double d = this.regressionExponent.getParameterValue(0);
        double d2 = this.globalScale.getParameterValue(0);
        for (int i = 0; i < this.dim; ++i) {
            double d3 = ExponentialTiltedStableDistribution.nextTiltedStable(d / 2.0, Math.pow(this.provider.getCoefficient(i) / d2, 2.0));
            this.localScale.setParameterValueQuietly(i, Math.sqrt(1.0 / (2.0 * d3)));
        }
        this.localScale.fireParameterChangedEvent();
    }
}

