/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.DiscreteTraitBranchRateGradient;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class BranchRateGradientForDiscreteTrait
extends DiscreteTraitBranchRateGradient
implements Citable {
    private static final Citation CITATION = new Citation(new Author[]{new Author("X", "Ji"), new Author("Z", "Zhang"), new Author("A", "Holbrook"), new Author("A", "Nishimura"), new Author("G", "Beale"), new Author("A", "Rambaut"), new Author("P", "Lemey"), new Author("MA", "Suchard")}, "Gradients do grow on trees: a linear-time O(N)-dimensional gradient for statistical phylogenetics", "Annals of Applied Statistics", Citation.Status.IN_SUBMISSION);

    public BranchRateGradientForDiscreteTrait(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, Parameter parameter, boolean bl) {
        super(string, treeDataLikelihood, beagleDataLikelihoodDelegate, parameter, bl);
    }

    @Override
    protected double getChainGradient(Tree tree, NodeRef nodeRef) {
        return this.branchRateModel.getBranchRateDifferential(tree, nodeRef) * tree.getBranchLength(nodeRef);
    }

    @Override
    protected double getChainSecondDerivative(Tree tree, NodeRef nodeRef) {
        return this.branchRateModel.getBranchRateSecondDifferential(tree, nodeRef) * tree.getBranchLength(nodeRef);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.FRAMEWORK;
    }

    @Override
    public String getDescription() {
        return "Using linear-time branch-rate differential calculations";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

