/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.alloppnet.speciation.AlloppDiploidHistory;
import dr.evomodel.alloppnet.speciation.AlloppLeggedTree;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.evomodel.alloppnet.tree.SlidableTree;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;
import jebl.util.FixedBitSet;

public class AlloppNetworkNodeSlide
extends SimpleMCMCOperator {
    private final AlloppSpeciesNetworkModel apspnet;
    private final AlloppSpeciesBindings apsp;

    public AlloppNetworkNodeSlide(AlloppSpeciesNetworkModel alloppSpeciesNetworkModel, AlloppSpeciesBindings alloppSpeciesBindings, double d) {
        this.apspnet = alloppSpeciesNetworkModel;
        this.apsp = alloppSpeciesBindings;
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return "None";
    }

    @Override
    public String getOperatorName() {
        return "networkNodeReHeight(" + this.apspnet.getId() + "," + this.apsp.getId() + ")";
    }

    @Override
    public double doOperation() {
        this.operateOneNodeInNet(0.0);
        return 0.0;
    }

    private NodeHeightInNetIndex randomnode() {
        int n;
        int n2;
        int n3 = this.apspnet.getNumberOfTetraTrees();
        int n4 = 0;
        int n5 = this.apspnet.getNumberOfInternalNodesInDipHist();
        n4 += n5;
        int n6 = n3;
        n4 += n6;
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.apspnet.getNumberOfInternalNodesInTetTree(n2);
            n4 += n;
        }
        n2 = MathUtils.nextInt(n4);
        if (n2 < n5) {
            return new NodeHeightInNetIndex(2, 0, n2, false);
        }
        if ((n2 -= n5) < n6) {
            n = n2 + (MathUtils.nextBoolean() ? 0 : n6);
            return new NodeHeightInNetIndex(2, 0, n, true);
        }
        n2 -= n6;
        for (n = 0; n < n3; ++n) {
            int n7 = this.apspnet.getNumberOfInternalNodesInTetTree(n);
            if (n2 < n7) {
                return new NodeHeightInNetIndex(4, n, n2, false);
            }
            n2 -= n7;
        }
        assert (false);
        return new NodeHeightInNetIndex(-1, -1, -1, false);
    }

    private void operateOneNodeInNet(double d) {
        assert (this.apspnet.getDiploidHistory().diphistOK(this.apspnet.getDiploidRootIsRoot()));
        NodeHeightInNetIndex nodeHeightInNetIndex = this.randomnode();
        if (nodeHeightInNetIndex.doHybheight) {
            this.operateHybridHeight(nodeHeightInNetIndex.index);
        } else if (nodeHeightInNetIndex.ploidy == 2) {
            this.operateOneNodeInDiploidHistory(nodeHeightInNetIndex.index, d);
        } else {
            assert (nodeHeightInNetIndex.ploidy == 4);
            AlloppLeggedTree alloppLeggedTree = this.apspnet.getTetraploidTree(nodeHeightInNetIndex.tree);
            this.operateOneNodeInTetraTree(alloppLeggedTree, nodeHeightInNetIndex.index, d);
        }
    }

    private void operateHybridHeight(int n) {
        AlloppDiploidHistory alloppDiploidHistory = this.apspnet.getDiploidHistory();
        ArrayList<Integer> arrayList = alloppDiploidHistory.collectFeet();
        assert (n < arrayList.size());
        int n2 = arrayList.get(n);
        int n3 = alloppDiploidHistory.getNodeTettree(n2);
        AlloppLeggedTree alloppLeggedTree = this.apspnet.getTetraploidTree(n3);
        double d = alloppLeggedTree.getRootHeight();
        int n4 = alloppLeggedTree.getDiphistLftLeg();
        int n5 = alloppLeggedTree.getDiphistRgtLeg();
        assert (n2 == n4 || n2 == n5);
        this.apspnet.beginNetworkEdit();
        alloppDiploidHistory.moveHybridHeight(n4, n5, d);
        this.apspnet.endNetworkEdit();
    }

    private void operateOneNodeInTetraTree(AlloppLeggedTree alloppLeggedTree, int n, double d) {
        Object object;
        FixedBitSet fixedBitSet;
        int n2;
        NodeRef[] nodeRefArray = SlidableTree.Utils.mnlCanonical(alloppLeggedTree);
        FixedBitSet fixedBitSet2 = this.apsp.speciesseqEmptyUnion();
        FixedBitSet fixedBitSet3 = this.apsp.speciesseqEmptyUnion();
        for (n2 = 0; n2 < 2 * n + 1; n2 += 2) {
            fixedBitSet = this.apsp.taxonseqToTipUnion(alloppLeggedTree.getSlidableNodeTaxon(nodeRefArray[n2]), 0);
            object = this.apsp.taxonseqToTipUnion(alloppLeggedTree.getSlidableNodeTaxon(nodeRefArray[n2]), 1);
            fixedBitSet2.union(fixedBitSet);
            fixedBitSet2.union((FixedBitSet)object);
        }
        for (n2 = 2 * (n + 1); n2 < nodeRefArray.length; n2 += 2) {
            fixedBitSet = this.apsp.taxonseqToTipUnion(alloppLeggedTree.getSlidableNodeTaxon(nodeRefArray[n2]), 0);
            object = this.apsp.taxonseqToTipUnion(alloppLeggedTree.getSlidableNodeTaxon(nodeRefArray[n2]), 1);
            fixedBitSet3.union(fixedBitSet);
            fixedBitSet3.union((FixedBitSet)object);
        }
        double d2 = this.apsp.spseqUpperBound(fixedBitSet2, fixedBitSet3);
        object = this.apspnet.getDiploidHistory();
        double d3 = ((AlloppDiploidHistory)object).getHybHeight(alloppLeggedTree);
        double d4 = Math.min(d2, d3);
        double d5 = -1.0;
        d5 = d > 0.0 ? alloppLeggedTree.getSlidableNodeHeight(nodeRefArray[2 * n + 1]) * d : MathUtils.nextDouble() * d4;
        this.apspnet.beginNetworkEdit();
        NodeRef nodeRef = nodeRefArray[2 * n + 1];
        alloppLeggedTree.setSlidableNodeHeight(nodeRef, d5);
        SlidableTree.Utils.mnlReconstruct(alloppLeggedTree, nodeRefArray);
        this.apspnet.endNetworkEdit();
    }

    RootHeightRange findRootRangeForDiploidRootIsRoot(AlloppDiploidHistory alloppDiploidHistory, NodeRef[] nodeRefArray, int n) {
        int n2;
        double d;
        int n3;
        RootHeightRange rootHeightRange = new RootHeightRange(0.0, Double.MAX_VALUE);
        int n4 = -1;
        double d2 = 0.0;
        for (n3 = 1; n3 < nodeRefArray.length; n3 += 2) {
            d = alloppDiploidHistory.getSlidableNodeHeight(nodeRefArray[n3]);
            if (!(d > d2)) continue;
            d2 = d;
            n4 = n3;
        }
        n3 = -1;
        d = 0.0;
        for (n2 = 1; n2 < nodeRefArray.length; n2 += 2) {
            double d3;
            if (n2 == n4 || !((d3 = alloppDiploidHistory.getSlidableNodeHeight(nodeRefArray[n2])) > d)) continue;
            d = d3;
            n3 = n2;
        }
        n2 = -1;
        int n5 = -1;
        for (int i = 0; i < nodeRefArray.length; i += 2) {
            if (!alloppDiploidHistory.tipIsDiploidTip(nodeRefArray[i])) continue;
            if (n2 < 0) {
                n2 = i;
            }
            n5 = i;
        }
        if (n == n4 && (n3 < n2 || n3 > n5)) {
            rootHeightRange.lowerlimit = alloppDiploidHistory.getSlidableNodeHeight(nodeRefArray[n3]);
        }
        if (n < n2 || n > n5) {
            rootHeightRange.upperlimit = alloppDiploidHistory.getSlidableNodeHeight(nodeRefArray[n4]);
        }
        return rootHeightRange;
    }

    private void operateOneNodeInDiploidHistory(int n, double d) {
        FixedBitSet fixedBitSet;
        int n2;
        this.apspnet.beginNetworkEdit();
        int n3 = 2 * n + 1;
        AlloppDiploidHistory alloppDiploidHistory = this.apspnet.getDiploidHistory();
        NodeRef[] nodeRefArray = SlidableTree.Utils.mnlCanonical(alloppDiploidHistory);
        FixedBitSet fixedBitSet2 = this.apsp.speciesseqEmptyUnion();
        FixedBitSet fixedBitSet3 = this.apsp.speciesseqEmptyUnion();
        for (n2 = 0; n2 < n3; n2 += 2) {
            fixedBitSet = this.apspnet.calculateDipHistTipUnion(nodeRefArray[n2]);
            fixedBitSet2.union(fixedBitSet);
        }
        for (n2 = n3 + 1; n2 < nodeRefArray.length; n2 += 2) {
            fixedBitSet = this.apspnet.calculateDipHistTipUnion(nodeRefArray[n2]);
            fixedBitSet3.union(fixedBitSet);
        }
        double d2 = this.apsp.spseqUpperBound(fixedBitSet2, fixedBitSet3);
        double d3 = 0.0;
        if (n3 - 1 >= 0) {
            d3 = Math.max(d3, alloppDiploidHistory.getSlidableNodeHeight(nodeRefArray[n3 - 1]));
        }
        if (n3 + 1 < nodeRefArray.length) {
            d3 = Math.max(d3, alloppDiploidHistory.getSlidableNodeHeight(nodeRefArray[n3 + 1]));
        }
        RootHeightRange rootHeightRange = new RootHeightRange(0.0, Double.MAX_VALUE);
        if (this.apspnet.getDiploidRootIsRoot()) {
            rootHeightRange = this.findRootRangeForDiploidRootIsRoot(alloppDiploidHistory, nodeRefArray, n3);
        }
        double d4 = Math.min(d2, rootHeightRange.upperlimit);
        double d5 = Math.max(d3, rootHeightRange.lowerlimit);
        double d6 = -1.0;
        d6 = d > 0.0 ? alloppDiploidHistory.getSlidableNodeHeight(nodeRefArray[n3]) * d : MathUtils.uniform(d5, d4);
        assert (alloppDiploidHistory.diphistOK(this.apspnet.getDiploidRootIsRoot()));
        NodeRef nodeRef = nodeRefArray[n3];
        alloppDiploidHistory.setSlidableNodeHeight(nodeRef, d6);
        SlidableTree.Utils.mnlReconstruct(alloppDiploidHistory, nodeRefArray);
        if (!alloppDiploidHistory.diphistOK(this.apspnet.getDiploidRootIsRoot())) {
            System.out.println("BUG in operateOneNodeInDiploidHistory()");
        }
        assert (alloppDiploidHistory.diphistOK(this.apspnet.getDiploidRootIsRoot()));
        this.apspnet.endNetworkEdit();
    }

    private class RootHeightRange {
        public double lowerlimit;
        public double upperlimit;

        RootHeightRange(double d, double d2) {
            this.lowerlimit = d;
            this.upperlimit = d2;
        }
    }

    private class NodeHeightInNetIndex {
        public int ploidy;
        public int tree;
        public int index;
        public boolean doHybheight;

        public NodeHeightInNetIndex(int n, int n2, int n3, boolean bl) {
            this.ploidy = n;
            this.tree = n2;
            this.index = n3;
            this.doHybheight = bl;
        }
    }
}

