## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(mbend)

## -----------------------------------------------------------------------------
V = matrix(nrow=5, ncol=5, c(
  100,  95,  80,  40,  40,
   95, 100,  95,  80,  40,
   80,  95, 100,  95,  80,
   40,  80,  95, 100,  95,
   40,  40,  80,  95, 100))

## -----------------------------------------------------------------------------
bend(V)

## ---- eval=FALSE--------------------------------------------------------------
#  bend(V, max.iter=10000, small.positive=0.0001, method="hj")

## -----------------------------------------------------------------------------
W = matrix(nrow=5, ncol=5, c(
  1000,  500,   20,   50,  200,
   500, 1000,  500,    5,   50,
    20,  500, 1000,   20,   20,
    50,    5,   20, 1000,  200,
   200,   50,   20,  200, 1000))

## -----------------------------------------------------------------------------
bend(inmat=V, wtmat=W, reciprocal=TRUE)

## -----------------------------------------------------------------------------
W2 = W; W2[1:2, 1:2] = 0
bend(V, W2, reciprocal=TRUE)

## -----------------------------------------------------------------------------
bend(inmat=V, method="lrs")

## -----------------------------------------------------------------------------
bend(V, W, reciprocal=TRUE, method="lrs")

## -----------------------------------------------------------------------------
V2 = cov2cor(V)
bend(V2, W, reciprocal=TRUE)

## -----------------------------------------------------------------------------
bend(V2, W, reciprocal=TRUE, method="lrs")

## -----------------------------------------------------------------------------
bend(V2, method="lrs")

