/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector;

import choco.cp.common.util.preprocessor.AbstractDetector;
import choco.cp.model.CPModel;
import choco.cp.model.managers.variables.IntegerVariableManager;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.set.SetVariable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;

public class AnalysisModelDetector
extends AbstractDetector {
    static int NB_STATS = 0;
    static final int EXT_CSTR = NB_STATS++;
    static final int BIG_DOM = NB_STATS++;
    static final int DOM_TYPE = NB_STATS++;
    static final int FREE_VAR = NB_STATS++;
    static long[] STATS = new long[NB_STATS];
    static String[] DEF_STATS = new String[NB_STATS];
    static final String ROW_SEP = "-";

    public AnalysisModelDetector(CPModel model) {
        super(model);
        Arrays.fill(STATS, 0L);
    }

    @Override
    public void apply() {
        if (LOGGER.getLevel().intValue() > Level.INFO.intValue()) {
            LOGGER.severe("AnalysisModelDetector: LOGGER verbosity is not sufficient to print all messages (minimum required : INFO)");
        }
        this.analyseIntegerVariables(this.model);
        this.analyseRealVariables(this.model);
        this.analyseSetVariables(this.model);
        this.analyseConstants(this.model);
        this.analyseMultipleVariables(this.model);
        this.print();
    }

    @Override
    public void commit() {
    }

    public void analyseIntegerVariables(CPModel model) {
        Iterator<IntegerVariable> it = model.getIntVarIterator();
        while (it.hasNext()) {
            IntegerVariable i = it.next();
            this.analyseNbConstraint(i);
            this.analyseDomainSize(i);
            this.analyseDomainType(i);
        }
    }

    public void analyseRealVariables(CPModel model) {
        Iterator<RealVariable> it = model.getRealVarIterator();
        while (it.hasNext()) {
            RealVariable r = it.next();
            this.analyseNbConstraint(r);
        }
    }

    public void analyseSetVariables(CPModel model) {
        Iterator<SetVariable> it = model.getSetVarIterator();
        while (it.hasNext()) {
            SetVariable s = it.next();
            this.analyseNbConstraint(s);
        }
    }

    public void analyseConstants(CPModel model) {
        Iterator<Variable> it = model.getConstVarIterator();
        while (it.hasNext()) {
            Variable v = it.next();
            this.analyseNbConstraint(v);
        }
    }

    public void analyseMultipleVariables(CPModel model) {
        Iterator<MultipleVariables> it = model.getMultipleVarIterator();
        while (it.hasNext()) {
            MultipleVariables mv = it.next();
            this.analyseNbConstraint(mv);
        }
    }

    private void print() {
        LOGGER.info("\n");
        LOGGER.info(StringUtils.pad("", 5, ROW_SEP));
        LOGGER.info("Relevant statistics on Model @" + this.model.hashCode() + ":\n");
        for (int i = 0; i < NB_STATS; ++i) {
            if (STATS[i] <= 0L) continue;
            LOGGER.info("> " + DEF_STATS[i] + STATS[i]);
        }
        LOGGER.info(StringUtils.pad("", 5, ROW_SEP));
        LOGGER.info("\n");
    }

    private void analyseNbConstraint(Variable v) {
        if (v.getConstraints().length > this.model.getNbConstraints()) {
            int n = EXT_CSTR;
            STATS[n] = STATS[n] + 1L;
        }
    }

    private void analyseDomainSize(IntegerVariable v) {
        if (v.getLowB() < -21474836 || v.getUppB() > 21474836) {
            int n = BIG_DOM;
            STATS[n] = STATS[n] + 1L;
        }
    }

    private void analyseDomainType(IntegerVariable v) {
        int bestDom;
        int actualDom = -1;
        if (v.containsOption("cp:bound")) {
            actualDom = 1;
        } else if (v.containsOption("cp:enum")) {
            actualDom = 0;
        } else if (v.containsOption("cp:link")) {
            actualDom = 2;
        } else if (v.containsOption("cp:blist")) {
            actualDom = 4;
        } else if (v.containsOption("cp:btree")) {
            actualDom = 3;
        }
        if (actualDom > -1 && actualDom != (bestDom = IntegerVariableManager.getIntelligentDomain(this.model, v))) {
            int n = DOM_TYPE;
            STATS[n] = STATS[n] + 1L;
        }
    }

    private void analyseFreeVar(Variable v) {
        if (v.getNbConstraint(this.model) == 0) {
            int n = FREE_VAR;
            STATS[n] = STATS[n] + 1L;
        }
    }

    static {
        AnalysisModelDetector.DEF_STATS[AnalysisModelDetector.EXT_CSTR] = "Number of variables involved in more constraints than those of the current model: ";
        AnalysisModelDetector.DEF_STATS[AnalysisModelDetector.BIG_DOM] = "Number of integer variables with very large domain: ";
        AnalysisModelDetector.DEF_STATS[AnalysisModelDetector.DOM_TYPE] = "Number of integer variables with inappropriate domain type: ";
        AnalysisModelDetector.DEF_STATS[AnalysisModelDetector.FREE_VAR] = "Number of free variables: ";
    }
}

