/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import moa.AbstractMOAObject;

public class ADWIN
extends AbstractMOAObject {
    public static final double DELTA = 0.002;
    private static final int mintMinimLongitudWindow = 10;
    private double mdbldelta = 0.002;
    private int mintTime = 0;
    private int mintClock = 32;
    private double mdblWidth = 0.0;
    public static final int MAXBUCKETS = 5;
    private int lastBucketRow = 0;
    private double TOTAL = 0.0;
    private double VARIANCE = 0.0;
    private int WIDTH = 0;
    private int BucketNumber = 0;
    private int Detect = 0;
    private int numberDetections = 0;
    private int DetectTwice = 0;
    private boolean blnBucketDeleted = false;
    private int BucketNumberMAX = 0;
    private int mintMinWinLength = 5;
    private List listRowBuckets;

    public boolean getChange() {
        return this.blnBucketDeleted;
    }

    public void resetChange() {
        this.blnBucketDeleted = false;
    }

    public int getBucketsUsed() {
        return this.BucketNumberMAX;
    }

    public int getWidth() {
        return this.WIDTH;
    }

    public void setClock(int intClock) {
        this.mintClock = intClock;
    }

    public int getClock() {
        return this.mintClock;
    }

    public boolean getWarning() {
        return false;
    }

    public boolean getDetect() {
        return this.Detect == this.mintTime;
    }

    public int getNumberDetections() {
        return this.numberDetections;
    }

    public double getTotal() {
        return this.TOTAL;
    }

    public double getEstimation() {
        return this.TOTAL / (double)this.WIDTH;
    }

    public double getVariance() {
        return this.VARIANCE / (double)this.WIDTH;
    }

    public double getWidthT() {
        return this.mdblWidth;
    }

    private void initBuckets() {
        this.listRowBuckets = new List();
        this.lastBucketRow = 0;
        this.TOTAL = 0.0;
        this.VARIANCE = 0.0;
        this.WIDTH = 0;
        this.BucketNumber = 0;
    }

    private void insertElement(double Value) {
        ++this.WIDTH;
        this.insertElementBucket(0.0, Value, this.listRowBuckets.head());
        double incVariance = 0.0;
        if (this.WIDTH > 1) {
            incVariance = (double)(this.WIDTH - 1) * (Value - this.TOTAL / (double)(this.WIDTH - 1)) * (Value - this.TOTAL / (double)(this.WIDTH - 1)) / (double)this.WIDTH;
        }
        this.VARIANCE += incVariance;
        this.TOTAL += Value;
        this.compressBuckets();
    }

    private void insertElementBucket(double Variance, double Value, ListItem Node2) {
        Node2.insertBucket(Value, Variance);
        ++this.BucketNumber;
        if (this.BucketNumber > this.BucketNumberMAX) {
            this.BucketNumberMAX = this.BucketNumber;
        }
    }

    private int bucketSize(int Row) {
        return (int)Math.pow(2.0, Row);
    }

    public int deleteElement() {
        ListItem Node2 = this.listRowBuckets.tail();
        int n1 = this.bucketSize(this.lastBucketRow);
        this.WIDTH -= n1;
        this.TOTAL -= Node2.Total(0);
        double u1 = Node2.Total(0) / (double)n1;
        double incVariance = Node2.Variance(0) + (double)(n1 * this.WIDTH) * (u1 - this.TOTAL / (double)this.WIDTH) * (u1 - this.TOTAL / (double)this.WIDTH) / (double)(n1 + this.WIDTH);
        this.VARIANCE -= incVariance;
        Node2.RemoveBucket();
        --this.BucketNumber;
        if (Node2.bucketSizeRow == 0) {
            this.listRowBuckets.removeFromTail();
            --this.lastBucketRow;
        }
        return n1;
    }

    public void compressBuckets() {
        int k;
        ListItem cursor = this.listRowBuckets.head();
        int i = 0;
        while ((k = cursor.bucketSizeRow) == 6) {
            ListItem nextNode = cursor.next();
            if (nextNode == null) {
                this.listRowBuckets.addToTail();
                nextNode = cursor.next();
                ++this.lastBucketRow;
            }
            int n1 = this.bucketSize(i);
            int n2 = this.bucketSize(i);
            double u1 = cursor.Total(0) / (double)n1;
            double u2 = cursor.Total(1) / (double)n2;
            double incVariance = (double)(n1 * n2) * (u1 - u2) * (u1 - u2) / (double)(n1 + n2);
            nextNode.insertBucket(cursor.Total(0) + cursor.Total(1), cursor.Variance(0) + cursor.Variance(1) + incVariance);
            ++this.BucketNumber;
            cursor.compressBucketsRow(2);
            if (nextNode.bucketSizeRow <= 5) break;
            cursor = cursor.next();
            ++i;
            if (cursor != null) continue;
        }
    }

    public boolean setInput(double intEntrada) {
        return this.setInput(intEntrada, this.mdbldelta);
    }

    public boolean setInput(double intEntrada, double delta) {
        boolean blnChange = false;
        boolean blnExit = false;
        ++this.mintTime;
        this.insertElement(intEntrada);
        this.blnBucketDeleted = false;
        if (this.mintTime % this.mintClock == 0 && this.getWidth() > 10) {
            boolean blnReduceWidth = true;
            while (blnReduceWidth) {
                blnReduceWidth = false;
                blnExit = false;
                int n0 = 0;
                int n1 = this.WIDTH;
                double u0 = 0.0;
                double u1 = this.getTotal();
                double v0 = 0.0;
                double v1 = this.VARIANCE;
                double n2 = 0.0;
                double u2 = 0.0;
                ListItem cursor = this.listRowBuckets.tail();
                int i = this.lastBucketRow;
                do {
                    for (int k = 0; k <= cursor.bucketSizeRow - 1; ++k) {
                        n2 = this.bucketSize(i);
                        u2 = cursor.Total(k);
                        if (n0 > 0) {
                            v0 += cursor.Variance(k) + (double)n0 * n2 * (u0 / (double)n0 - u2 / n2) * (u0 / (double)n0 - u2 / n2) / ((double)n0 + n2);
                        }
                        if (n1 > 0) {
                            v1 -= cursor.Variance(k) + (double)n1 * n2 * (u1 / (double)n1 - u2 / n2) * (u1 / (double)n1 - u2 / n2) / ((double)n1 + n2);
                        }
                        n0 += this.bucketSize(i);
                        n1 -= this.bucketSize(i);
                        u0 += cursor.Total(k);
                        u1 -= cursor.Total(k);
                        if (i == 0 && k == cursor.bucketSizeRow - 1) {
                            blnExit = true;
                            break;
                        }
                        double absvalue = u0 / (double)n0 - u1 / (double)n1;
                        if (n1 <= this.mintMinWinLength + 1 || n0 <= this.mintMinWinLength + 1 || !this.blnCutexpression(n0, n1, u0, u1, v0, v1, absvalue, delta)) continue;
                        this.blnBucketDeleted = true;
                        this.Detect = this.mintTime;
                        if (this.Detect == 0) {
                            this.Detect = this.mintTime;
                        } else if (this.DetectTwice == 0) {
                            this.DetectTwice = this.mintTime;
                        }
                        blnReduceWidth = true;
                        blnChange = true;
                        if (this.getWidth() <= 0) continue;
                        n0 -= this.deleteElement();
                        blnExit = true;
                        break;
                    }
                    cursor = cursor.previous();
                    --i;
                } while (!blnExit && cursor != null);
            }
        }
        this.mdblWidth += (double)this.getWidth();
        if (blnChange) {
            ++this.numberDetections;
        }
        return blnChange;
    }

    private boolean blnCutexpression(int n0, int n1, double u0, double u1, double v0, double v1, double absvalue, double delta) {
        int n = this.getWidth();
        double dd = Math.log(2.0 * Math.log(n) / delta);
        double v = this.getVariance();
        double m = 1.0 / (double)(n0 - this.mintMinWinLength + 1) + 1.0 / (double)(n1 - this.mintMinWinLength + 1);
        double epsilon = Math.sqrt(2.0 * m * v * dd) + 0.6666666666666666 * dd * m;
        return Math.abs(absvalue) > epsilon;
    }

    public ADWIN() {
        this.mdbldelta = 0.002;
        this.initBuckets();
        this.Detect = 0;
        this.numberDetections = 0;
        this.DetectTwice = 0;
    }

    public ADWIN(double d) {
        this.mdbldelta = d;
        this.initBuckets();
        this.Detect = 0;
        this.numberDetections = 0;
        this.DetectTwice = 0;
    }

    public ADWIN(int cl) {
        this.mdbldelta = 0.002;
        this.initBuckets();
        this.Detect = 0;
        this.numberDetections = 0;
        this.DetectTwice = 0;
        this.mintClock = cl;
    }

    public String getEstimatorInfo() {
        return "ADWIN;;";
    }

    public void setW(int W0) {
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    private class ListItem
    extends AbstractMOAObject {
        protected ListItem next;
        protected ListItem previous;
        protected int bucketSizeRow = 0;
        protected int MAXBUCKETS = 5;
        protected double[] bucketTotal = new double[this.MAXBUCKETS + 1];
        protected double[] bucketVariance = new double[this.MAXBUCKETS + 1];

        public ListItem() {
            this(null, null);
        }

        public void clear() {
            this.bucketSizeRow = 0;
            for (int k = 0; k <= this.MAXBUCKETS; ++k) {
                this.clearBucket(k);
            }
        }

        private void clearBucket(int k) {
            this.setTotal(0.0, k);
            this.setVariance(0.0, k);
        }

        public ListItem(ListItem nextNode, ListItem previousNode) {
            this.next = nextNode;
            this.previous = previousNode;
            if (nextNode != null) {
                nextNode.previous = this;
            }
            if (previousNode != null) {
                previousNode.next = this;
            }
            this.clear();
        }

        public void insertBucket(double Value, double Variance) {
            int k = this.bucketSizeRow++;
            this.setTotal(Value, k);
            this.setVariance(Variance, k);
        }

        public void RemoveBucket() {
            this.compressBucketsRow(1);
        }

        public void compressBucketsRow(int NumberItemsDeleted) {
            int k;
            for (k = NumberItemsDeleted; k <= this.MAXBUCKETS; ++k) {
                this.bucketTotal[k - NumberItemsDeleted] = this.bucketTotal[k];
                this.bucketVariance[k - NumberItemsDeleted] = this.bucketVariance[k];
            }
            for (k = 1; k <= NumberItemsDeleted; ++k) {
                this.clearBucket(this.MAXBUCKETS - k + 1);
            }
            this.bucketSizeRow -= NumberItemsDeleted;
        }

        public ListItem previous() {
            return this.previous;
        }

        public void setPrevious(ListItem previous) {
            this.previous = previous;
        }

        public ListItem next() {
            return this.next;
        }

        public void setNext(ListItem next) {
            this.next = next;
        }

        public double Total(int k) {
            return this.bucketTotal[k];
        }

        public double Variance(int k) {
            return this.bucketVariance[k];
        }

        public void setTotal(double value, int k) {
            this.bucketTotal[k] = value;
        }

        public void setVariance(double value, int k) {
            this.bucketVariance[k] = value;
        }

        public void getDescription(StringBuilder sb, int indent) {
        }
    }

    private class List
    extends AbstractMOAObject {
        protected int count;
        protected ListItem head;
        protected ListItem tail;

        public List() {
            this.clear();
            this.addToHead();
        }

        public int size() {
            return this.count;
        }

        public ListItem head() {
            return this.head;
        }

        public ListItem tail() {
            return this.tail;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void clear() {
            this.head = null;
            this.tail = null;
            this.count = 0;
        }

        public void addToHead() {
            this.head = new ListItem(this.head, null);
            if (this.tail == null) {
                this.tail = this.head;
            }
            ++this.count;
        }

        public void removeFromHead() {
            this.head = this.head.next();
            if (this.head != null) {
                this.head.setPrevious(null);
            } else {
                this.tail = null;
            }
            --this.count;
        }

        public void addToTail() {
            this.tail = new ListItem(null, this.tail);
            if (this.head == null) {
                this.head = this.tail;
            }
            ++this.count;
        }

        public void removeFromTail() {
            this.tail = this.tail.previous();
            if (this.tail == null) {
                this.head = null;
            } else {
                this.tail.setNext(null);
            }
            --this.count;
        }

        public void getDescription(StringBuilder sb, int indent) {
        }
    }
}

