/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Randomize;

public class myDataset {
    public static final int REAL = 0;
    public static final int INTEGER = 1;
    public static final int NOMINAL = 2;
    private double[][] X = null;
    private boolean[][] missing = null;
    private int[] outputInteger = null;
    private double[] outputReal = null;
    private String[] output = null;
    private double[] emax;
    private double[] emin;
    private int nData;
    private int nVars;
    private int nInputs;
    private int nClasses;
    private int[] list_of_classes;
    private InstanceSet IS;
    private double[] stdev;
    private double[] average;
    private double[][] stdevPerClass;
    private double[][] averagePerClass;
    private int[] instancesCl;
    private double[] ir;

    public myDataset() {
        this.IS = new InstanceSet();
    }

    public myDataset(myDataset copia, double[] distribution) {
        int i;
        this.nVars = copia.getnVars();
        this.nInputs = copia.getnInputs();
        this.nClasses = copia.getnClasses();
        double[][] X_aux = new double[copia.size()][copia.getnInputs()];
        int[] outputInteger_aux = new int[copia.size()];
        String[] output_aux = new String[copia.size()];
        this.nData = 0;
        for (i = 0; i < copia.size(); ++i) {
            double r = Randomize.Rand();
            int j = -1;
            double acumSum = 0.0;
            while ((acumSum += distribution[++j]) < r) {
            }
            X_aux[this.nData] = (double[])copia.getExample(j).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(j);
            output_aux[this.nData] = copia.getOutputAsString(j);
            ++this.nData;
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.list_of_classes = (int[])copia.list_of_classes.clone();
        this.computeInstancesPerClass();
    }

    public myDataset(myDataset copia) {
        this.nVars = copia.getnVars();
        this.nInputs = copia.getnInputs();
        this.nClasses = copia.getnClasses();
        this.nData = 0;
        this.list_of_classes = (int[])copia.list_of_classes.clone();
        copia.IS.setAttributesAsNonStatic();
        this.IS = new InstanceSet(copia.IS);
    }

    public myDataset(myDataset copia, int clase_1, int clase_2) {
        int i;
        this.nVars = copia.getnVars();
        this.nInputs = copia.getnInputs();
        this.nClasses = copia.getnClasses();
        double[][] X_aux = new double[copia.size()][copia.getnInputs()];
        int[] outputInteger_aux = new int[copia.size()];
        String[] output_aux = new String[copia.size()];
        this.nData = 0;
        for (i = 0; i < copia.size(); ++i) {
            if (copia.getOutputAsInteger(i) != clase_1 && copia.getOutputAsInteger(i) != clase_2) continue;
            X_aux[this.nData] = (double[])copia.getExample(i).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(i);
            output_aux[this.nData] = copia.getOutputAsString(i);
            ++this.nData;
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.list_of_classes = new int[2];
        this.list_of_classes[0] = clase_1;
        this.list_of_classes[1] = clase_2;
        copia.computeInstancesPerClass();
        this.instancesCl = new int[copia.getnClasses()];
        for (i = 0; i < this.instancesCl.length; ++i) {
            this.instancesCl[i] = copia.numberInstances(i);
        }
    }

    public myDataset(myDataset copia, String bagType) {
        int i;
        this.nVars = copia.getnVars();
        this.nInputs = copia.getnInputs();
        this.nClasses = copia.getnClasses();
        double[][] X_aux = new double[copia.size()][copia.getnInputs()];
        int[] outputInteger_aux = new int[copia.size()];
        String[] output_aux = new String[copia.size()];
        this.nData = 0;
        int r = 0;
        int maj = copia.claseNumerica(copia.claseMasFrecuente());
        int min = maj == 1 ? 0 : 1;
        int bagT = 0;
        int tam = 0;
        if (bagType.equals("OVERBAGGING")) {
            bagT = maj == 1 ? 0 : 1;
            X_aux = new double[copia.instancesCl[maj] * 2][copia.getnInputs()];
            outputInteger_aux = new int[copia.instancesCl[maj] * 2];
            output_aux = new String[copia.instancesCl[maj] * 2];
            tam = maj;
        } else if (bagType.equals("UNDERBAGGING")) {
            X_aux = new double[copia.instancesCl[min] * 2][copia.getnInputs()];
            outputInteger_aux = new int[copia.instancesCl[min] * 2];
            output_aux = new String[copia.instancesCl[min] * 2];
            bagT = maj;
            tam = min;
        }
        for (i = 0; i < copia.size(); ++i) {
            if (copia.getOutputAsInteger(i) == min && bagType.equals("UNDERBAGGING")) {
                X_aux[this.nData] = (double[])copia.getExample(i).clone();
                outputInteger_aux[this.nData] = copia.getOutputAsInteger(i);
                output_aux[this.nData] = copia.getOutputAsString(i);
                ++this.nData;
                continue;
            }
            if (copia.getOutputAsInteger(i) != maj || !bagType.equals("OVERBAGGING")) continue;
            X_aux[this.nData] = (double[])copia.getExample(i).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(i);
            output_aux[this.nData] = copia.getOutputAsString(i);
            ++this.nData;
        }
        for (i = this.nData; i < copia.instancesCl[tam] * 2; ++i) {
            while (copia.getOutputAsInteger(r = Randomize.RandintClosed(0, copia.size() - 1)) != bagT) {
            }
            X_aux[this.nData] = (double[])copia.getExample(r).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(r);
            output_aux[this.nData] = copia.getOutputAsString(r);
            ++this.nData;
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.list_of_classes = copia.list_of_classes;
        this.computeInstancesPerClass();
    }

    public myDataset(myDataset copia, int clase_1, int clase_2, int[] empate) {
        int i;
        this.nVars = copia.getnVars();
        this.nInputs = copia.getnInputs();
        this.nClasses = copia.getnClasses();
        double[][] X_aux = new double[copia.size()][copia.getnInputs()];
        int[] outputInteger_aux = new int[copia.size()];
        String[] output_aux = new String[copia.size()];
        this.nData = 0;
        for (i = 0; i < copia.size(); ++i) {
            if (copia.getOutputAsInteger(i) != clase_1 && copia.getOutputAsInteger(i) != clase_2 || empate[i] != 1) continue;
            X_aux[this.nData] = (double[])copia.getExample(i).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(i);
            output_aux[this.nData] = copia.getOutputAsString(i);
            ++this.nData;
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.list_of_classes = new int[2];
        this.list_of_classes[0] = clase_1;
        this.list_of_classes[1] = clase_2;
        copia.computeInstancesPerClass();
        this.instancesCl = new int[copia.getnClasses()];
        for (i = 0; i < this.instancesCl.length; ++i) {
            this.instancesCl[i] = copia.numberInstances(i);
        }
    }

    public myDataset(myDataset copia, int majC, double[][] Xmaj, int minC, double[][] Xmin) {
        int i;
        this.nVars = copia.getnVars();
        this.nInputs = copia.getnInputs();
        this.nClasses = copia.getnClasses();
        int newNData = copia.size() + Xmaj.length + Xmin.length;
        double[][] X_aux = new double[newNData][copia.getnInputs()];
        int[] outputInteger_aux = new int[newNData];
        String[] output_aux = new String[newNData];
        this.nData = 0;
        for (i = 0; i < copia.size(); ++i) {
            X_aux[this.nData] = (double[])copia.getExample(i).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(i);
            output_aux[this.nData] = copia.getOutputAsString(i);
            ++this.nData;
        }
        for (i = 0; i < Xmaj.length; ++i) {
            X_aux[this.nData] = (double[])Xmaj[i].clone();
            outputInteger_aux[this.nData] = majC;
            output_aux[this.nData] = copia.getOutputValue(majC);
            ++this.nData;
        }
        for (i = 0; i < Xmin.length; ++i) {
            X_aux[this.nData] = (double[])Xmin[i].clone();
            outputInteger_aux[this.nData] = minC;
            output_aux[this.nData] = copia.getOutputValue(minC);
            ++this.nData;
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.list_of_classes = (int[])copia.list_of_classes.clone();
        this.computeInstancesPerClass();
    }

    public int[] randomUnderSampling(myDataset copia, int majC, int N) {
        int i;
        int[] majExamples = new int[copia.size()];
        int majCount = 0;
        int size = copia.numberInstances(majC == 0 ? 1 : 0) * (100 + 2 * N) / 100;
        int[] selected = new int[size];
        double[][] X_aux = new double[size][copia.getnInputs()];
        int[] outputInteger_aux = new int[size];
        String[] output_aux = new String[size];
        this.nData = 0;
        for (int i2 = 0; i2 < copia.size(); ++i2) {
            if (copia.getOutputAsInteger(i2) == majC) {
                majExamples[majCount] = i2;
                ++majCount;
                continue;
            }
            selected[this.nData] = i2;
            X_aux[this.nData] = (double[])copia.getExample(i2).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(i2);
            output_aux[this.nData] = copia.getOutputAsString(i2);
            ++this.nData;
        }
        for (i = this.nData; i < size; ++i) {
            int r = Randomize.Randint(0, majCount - 1);
            selected[this.nData] = majExamples[r];
            X_aux[this.nData] = (double[])copia.getExample(majExamples[r]).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(majExamples[r]);
            output_aux[this.nData] = copia.getOutputAsString(majExamples[r]);
            ++this.nData;
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.computeInstancesPerClass();
        return selected;
    }

    public int[] randomSampling(myDataset copia, int majC, int minC, int a) {
        int i;
        int[] majExamples = new int[copia.size()];
        int[] minExamples = new int[copia.size()];
        int majCount = 0;
        int minCount = 0;
        int size = copia.numberInstances(majC) * a / 100 * 2;
        int[] selected = new int[size];
        double[][] X_aux = new double[size][copia.getnInputs()];
        int[] outputInteger_aux = new int[size];
        String[] output_aux = new String[size];
        this.nData = 0;
        for (int i2 = 0; i2 < copia.size(); ++i2) {
            if (copia.getOutputAsInteger(i2) == majC) {
                majExamples[majCount] = i2;
                ++majCount;
                continue;
            }
            minExamples[minCount] = i2;
            ++minCount;
        }
        for (i = 0; i < size / 2; ++i) {
            int r = Randomize.Randint(0, majCount - 1);
            selected[this.nData] = majExamples[r];
            X_aux[this.nData] = (double[])copia.getExample(majExamples[r]).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(majExamples[r]);
            output_aux[this.nData] = copia.getOutputAsString(majExamples[r]);
            ++this.nData;
            r = Randomize.Randint(0, minCount - 1);
            selected[this.nData] = minExamples[r];
            X_aux[this.nData] = (double[])copia.getExample(minExamples[r]).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(minExamples[r]);
            output_aux[this.nData] = copia.getOutputAsString(minExamples[r]);
            ++this.nData;
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.computeInstancesPerClass();
        return selected;
    }

    public int[] randomSampling(myDataset copia, int majC, int minC, int nMaj, int nMin) {
        int i;
        int r;
        int i2;
        int[] majExamples = new int[copia.size()];
        int[] minExamples = new int[copia.size()];
        int majCount = 0;
        int minCount = 0;
        int size = nMaj + nMin;
        int[] selected = new int[size];
        double[][] X_aux = new double[size][copia.getnInputs()];
        int[] outputInteger_aux = new int[size];
        String[] output_aux = new String[size];
        this.nData = 0;
        for (int i3 = 0; i3 < copia.size(); ++i3) {
            if (copia.getOutputAsInteger(i3) == majC) {
                majExamples[majCount] = i3;
                ++majCount;
                continue;
            }
            minExamples[minCount] = i3;
            ++minCount;
        }
        boolean[] taken = new boolean[copia.size()];
        for (i2 = 0; i2 < nMaj; ++i2) {
            r = Randomize.Randint(0, majCount - 1);
            selected[this.nData] = majExamples[r];
            taken[majExamples[r]] = true;
            X_aux[this.nData] = (double[])copia.getExample(majExamples[r]).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(majExamples[r]);
            output_aux[this.nData] = copia.getOutputAsString(majExamples[r]);
            ++this.nData;
        }
        for (i2 = 0; i2 < nMin; ++i2) {
            r = Randomize.Randint(0, minCount - 1);
            selected[this.nData] = minExamples[r];
            taken[minExamples[r]] = true;
            X_aux[this.nData] = (double[])copia.getExample(minExamples[r]).clone();
            outputInteger_aux[this.nData] = copia.getOutputAsInteger(minExamples[r]);
            output_aux[this.nData] = copia.getOutputAsString(minExamples[r]);
            ++this.nData;
        }
        int deleted = 0;
        for (i = 0; i < copia.size(); ++i) {
            if (taken[i]) continue;
            this.IS.removeInstance(i - deleted);
            ++deleted;
        }
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.computeInstancesPerClass();
        return selected;
    }

    public boolean[] importanceSampling(myDataset copia, int size, boolean[] oob, double oobErr) {
        boolean[] selected = new boolean[copia.getnData()];
        this.IS.clearInstances();
        this.X = new double[size][copia.getnInputs()];
        this.outputInteger = new int[size];
        this.output = new String[size];
        this.nData = 0;
        while (this.nData < size) {
            int r = Randomize.Randint(0, copia.getnData());
            if (oob[r] && !(Randomize.RandClosed() <= oobErr / (1.0 - oobErr))) continue;
            selected[r] = true;
            this.IS.addInstance(copia.IS.getInstance(r));
            this.X[this.nData] = (double[])copia.getExample(r).clone();
            this.outputInteger[this.nData] = copia.getOutputAsInteger(r);
            this.output[this.nData] = copia.getOutputAsString(r);
            ++this.nData;
        }
        this.computeInstancesPerClass();
        return selected;
    }

    public double[][] getX() {
        return this.X;
    }

    public double[] getExample(int pos) {
        return this.X[pos];
    }

    public int[] getOutputAsInteger() {
        int[] output = new int[this.outputInteger.length];
        for (int i = 0; i < this.outputInteger.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public double[] getOutputAsReal() {
        double[] output = new double[this.outputReal.length];
        for (int i = 0; i < this.outputReal.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public String[] getOutputAsString() {
        String[] output = new String[this.output.length];
        for (int i = 0; i < this.output.length; ++i) {
            output[i] = this.output[i];
        }
        return output;
    }

    public String getOutputAsString(int pos) {
        return this.output[pos];
    }

    public int getOutputAsInteger(int pos) {
        return this.outputInteger[pos];
    }

    public double getOutputAsReal(int pos) {
        return this.outputReal[pos];
    }

    public double[] getemax() {
        return this.emax;
    }

    public double[] getemin() {
        return this.emin;
    }

    public double getMax(int variable) {
        return this.emax[variable];
    }

    public double getMin(int variable) {
        return this.emin[variable];
    }

    public int getnData() {
        return this.nData;
    }

    public int getnVars() {
        return this.nVars;
    }

    public int getnInputs() {
        return this.nInputs;
    }

    public int getnClasses() {
        return this.nClasses;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public void readClassificationSet(String datasetFile, boolean train) throws IOException {
        try {
            this.IS.readSet(datasetFile, train);
            this.nData = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVars = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
                System.exit(1);
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
                System.exit(1);
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.outputInteger = new int[this.nData];
            this.outputReal = new double[this.nData];
            this.output = new String[this.nData];
            this.emax = new double[this.nInputs];
            this.emin = new double[this.nInputs];
            for (int i = 0; i < this.nInputs; ++i) {
                this.emax[i] = Attributes.getAttribute(i).getMaxAttribute();
                this.emin[i] = Attributes.getAttribute(i).getMinAttribute();
            }
            this.nClasses = 0;
            int aux = 0;
            int datos = 0;
            int datosMal = 0;
            for (int i = 0; i < this.nData; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[datos][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (!this.missing[i][j]) continue;
                    j = this.nInputs;
                    ++datosMal;
                }
                if (noOutputs) {
                    this.outputInteger[datos] = 0;
                    this.output[datos] = "";
                } else {
                    this.outputInteger[datos] = (int)this.IS.getOutputNumericValue(i, 0);
                    this.output[datos] = this.IS.getOutputNominalValue(i, 0);
                }
                if (this.outputInteger[datos] > this.nClasses) {
                    this.nClasses = this.outputInteger[datos];
                }
                ++datos;
                if (datosMal <= aux) continue;
                --datos;
                aux = datosMal;
            }
            this.nData -= datosMal;
            ++this.nClasses;
            System.out.println("Number of classes=" + this.nClasses);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
        this.list_of_classes = new int[this.nClasses];
        for (int i = 0; i < this.nClasses; ++i) {
            this.list_of_classes[i] = i;
        }
        this.computeStatistics();
        this.computeInstancesPerClass();
    }

    public void readInstanceSet(InstanceSet IS) throws IOException {
        try {
            this.IS = IS;
            this.nData = IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVars = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
                System.exit(1);
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
                System.exit(1);
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.outputInteger = new int[this.nData];
            this.outputReal = new double[this.nData];
            this.output = new String[this.nData];
            this.emax = new double[this.nInputs];
            this.emin = new double[this.nInputs];
            for (int i = 0; i < this.nInputs; ++i) {
                this.emax[i] = Attributes.getAttribute(i).getMaxAttribute();
                this.emin[i] = Attributes.getAttribute(i).getMinAttribute();
            }
            this.nClasses = 0;
            int aux = 0;
            int datos = 0;
            int datosMal = 0;
            for (int i = 0; i < this.nData; ++i) {
                Instance inst = IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[datos][j] = IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (!this.missing[i][j]) continue;
                    j = this.nInputs;
                    ++datosMal;
                }
                if (noOutputs) {
                    this.outputInteger[datos] = 0;
                    this.output[datos] = "";
                } else {
                    this.outputInteger[datos] = (int)IS.getOutputNumericValue(i, 0);
                    this.output[datos] = IS.getOutputNominalValue(i, 0);
                }
                if (this.outputInteger[datos] > this.nClasses) {
                    this.nClasses = this.outputInteger[datos];
                }
                ++datos;
                if (datosMal <= aux) continue;
                --datos;
                aux = datosMal;
            }
            this.nData -= datosMal;
            ++this.nClasses;
            System.out.println("Number of classes=" + this.nClasses);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
        this.list_of_classes = new int[this.nClasses];
        for (int i = 0; i < this.nClasses; ++i) {
            this.list_of_classes[i] = i;
        }
        this.computeStatistics();
        this.computeInstancesPerClass();
    }

    public String copyHeader() {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        return p;
    }

    public void normalize() {
        int atts = this.getnInputs();
        double[] maxs = new double[atts];
        for (int j = 0; j < atts; ++j) {
            maxs[j] = 1.0 / (this.emax[j] - this.emin[j]);
        }
        for (int i = 0; i < this.getnData(); ++i) {
            for (int j = 0; j < atts; ++j) {
                if (this.isMissing(i, j)) continue;
                this.X[i][j] = (this.X[i][j] - this.emin[j]) * maxs[j];
            }
        }
    }

    public void computeStatisticsPerClass() {
        int c;
        int i;
        this.stdevPerClass = new double[this.nClasses][this.getnInputs()];
        this.averagePerClass = new double[this.nClasses][this.getnInputs()];
        for (i = 0; i < this.getnInputs(); ++i) {
            int j;
            for (j = 0; j < this.getnClasses(); ++j) {
                this.averagePerClass[j][i] = 0.0;
            }
            for (j = 0; j < this.getnData(); ++j) {
                c = this.outputInteger[j];
                if (this.isMissing(j, i)) continue;
                double[] dArray = this.averagePerClass[c];
                int n = i;
                dArray[n] = dArray[n] + this.X[j][i];
            }
            for (j = 0; j < this.getnClasses(); ++j) {
                double[] dArray = this.averagePerClass[j];
                int n = i;
                dArray[n] = dArray[n] / (double)this.numEjemplos(j);
                if (!Double.isNaN(this.averagePerClass[j][i])) continue;
                this.averagePerClass[j][i] = this.average(i);
            }
        }
        for (i = 0; i < this.getnInputs(); ++i) {
            int j;
            double[] sum = new double[this.nClasses];
            for (j = 0; j < this.getnClasses(); ++j) {
                sum[j] = 0.0;
            }
            for (j = 0; j < this.getnData(); ++j) {
                c = this.outputInteger[j];
                if (this.isMissing(j, i)) continue;
                int n = c;
                sum[n] = sum[n] + (this.X[j][i] - this.averagePerClass[c][i]) * (this.X[j][i] - this.averagePerClass[c][i]);
            }
            for (j = 0; j < this.getnClasses(); ++j) {
                int n = j;
                sum[n] = sum[n] / (double)this.numEjemplos(j);
                this.stdevPerClass[j][i] = Math.sqrt(sum[j]);
            }
        }
    }

    public double[][] getAveragePerClass() {
        return this.averagePerClass;
    }

    public double[][] getStdPerClass() {
        return this.stdevPerClass;
    }

    public boolean hasRealAttributes() {
        return Attributes.hasRealAttributes();
    }

    public boolean hasNumericalAttributes() {
        return Attributes.hasIntegerAttributes() || Attributes.hasRealAttributes();
    }

    public boolean hasMissingAttributes() {
        return this.sizeWithoutMissing() < this.getnData();
    }

    public int sizeWithoutMissing() {
        int tam = 0;
        for (int i = 0; i < this.nData; ++i) {
            int j;
            for (j = 1; j < this.nInputs && !this.isMissing(i, j); ++j) {
            }
            if (j != this.nInputs) continue;
            ++tam;
        }
        return tam;
    }

    public int size() {
        return this.nData;
    }

    private void computeStatistics() {
        this.stdev = new double[this.getnVars()];
        this.average = new double[this.getnVars()];
        int i = 0;
        while (i < this.getnInputs()) {
            this.average[i] = 0.0;
            for (int j = 0; j < this.getnData(); ++j) {
                if (this.isMissing(j, i)) continue;
                int n = i;
                this.average[n] = this.average[n] + this.X[j][i];
            }
            int n = i++;
            this.average[n] = this.average[n] / (double)this.getnData();
        }
        this.average[this.average.length - 1] = 0.0;
        for (int j = 0; j < this.outputReal.length; ++j) {
            int n = this.average.length - 1;
            this.average[n] = this.average[n] + this.outputReal[j];
        }
        int n = this.average.length - 1;
        this.average[n] = this.average[n] / (double)this.outputReal.length;
        for (i = 0; i < this.getnInputs(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.getnData(); ++j) {
                if (this.isMissing(j, i)) continue;
                sum += (this.X[j][i] - this.average[i]) * (this.X[j][i] - this.average[i]);
            }
            this.stdev[i] = Math.sqrt(sum /= (double)this.getnData());
        }
        double sum = 0.0;
        for (int j = 0; j < this.outputReal.length; ++j) {
            sum += (this.outputReal[j] - this.average[this.average.length - 1]) * (this.outputReal[j] - this.average[this.average.length - 1]);
        }
        this.stdev[this.stdev.length - 1] = Math.sqrt(sum /= (double)this.outputReal.length);
    }

    public double stdDev(int position) {
        return this.stdev[position];
    }

    public double average(int position) {
        return this.average[position];
    }

    public void computeInstancesPerClass() {
        this.instancesCl = new int[this.nClasses];
        for (int i = 0; i < this.getnData(); ++i) {
            int n = this.outputInteger[i];
            this.instancesCl[n] = this.instancesCl[n] + 1;
        }
    }

    public int numberInstances(int clas) {
        return this.instancesCl[clas];
    }

    public void computeIR() {
        int i;
        this.ir = new double[this.nClasses];
        double max = 0.0;
        for (i = 0; i < this.ir.length; ++i) {
            if (this.instancesCl[i] <= 0) continue;
            this.ir[i] = 1.0 * (double)this.nData / (double)this.instancesCl[i];
            if (!(this.ir[i] > max)) continue;
            max = this.ir[i];
        }
        i = 0;
        while (i < this.ir.length) {
            int n = i++;
            this.ir[n] = this.ir[n] / max;
        }
    }

    public double getIR(int clase) {
        return this.ir[clase];
    }

    public int numberValues(int attribute) {
        return Attributes.getInputAttribute(attribute).getNumNominalValues();
    }

    public String getOutputValue(int intValue) {
        return Attributes.getOutputAttribute(0).getNominalValue(intValue);
    }

    public int getTipo(int variable) {
        int n = Attributes.getInputAttribute(variable).getType();
        Attributes.getInputAttribute(0);
        if (n == 1) {
            return 1;
        }
        int n2 = Attributes.getInputAttribute(variable).getType();
        Attributes.getInputAttribute(0);
        if (n2 == 2) {
            return 0;
        }
        int n3 = Attributes.getInputAttribute(variable).getType();
        Attributes.getInputAttribute(0);
        if (n3 == 0) {
            return 2;
        }
        return 0;
    }

    public double[][] devuelveRangos() {
        double[][] rangos = new double[this.getnVars()][2];
        for (int i = 0; i < this.getnInputs(); ++i) {
            if (Attributes.getInputAttribute(i).getNumNominalValues() > 0) {
                rangos[i][0] = 0.0;
                rangos[i][1] = Attributes.getInputAttribute(i).getNumNominalValues() - 1;
                continue;
            }
            rangos[i][0] = Attributes.getInputAttribute(i).getMinAttribute();
            rangos[i][1] = Attributes.getInputAttribute(i).getMaxAttribute();
        }
        rangos[this.getnVars() - 1][0] = Attributes.getOutputAttribute(0).getMinAttribute();
        rangos[this.getnVars() - 1][1] = Attributes.getOutputAttribute(0).getMaxAttribute();
        return rangos;
    }

    public String nombreVar(int pos) {
        return Attributes.getInputAttribute(pos).getName();
    }

    public String nombreClase(int clase) {
        return Attributes.getOutputAttribute(0).getNominalValue(clase);
    }

    public void discretize(int intervalos) {
        for (int i = 0; i < this.nInputs; ++i) {
            if (this.getTipo(i) != 0) continue;
            double corte = (this.emax[i] - this.emin[i]) / (double)intervalos;
            for (int j = 0; j < this.size(); ++j) {
                double acum = this.emin[i] + corte;
                boolean salir = false;
                for (int k = 0; k < intervalos && !salir; ++k) {
                    if (this.X[j][i] < acum) {
                        this.X[j][i] = k;
                        salir = true;
                    }
                    acum += corte;
                }
            }
        }
    }

    public String[] nombres() {
        String[] nombres = new String[this.nInputs];
        for (int i = 0; i < this.nInputs; ++i) {
            nombres[i] = Attributes.getInputAttribute(i).getName();
        }
        return nombres;
    }

    public static double valorReal(int atributo, String valorNominal) {
        Vector nominales = Attributes.getInputAttribute(atributo).getNominalValuesList();
        int aux = nominales.indexOf(valorNominal);
        return 1.0 * (double)aux;
    }

    public int claseNumerica(String valorNominal) {
        Vector nominales = Attributes.getOutputAttribute(0).getNominalValuesList();
        int aux = nominales.indexOf(valorNominal);
        return aux;
    }

    public static String valorNominal(int atributo, double valorReal) {
        Vector nominales = Attributes.getInputAttribute(atributo).getNominalValuesList();
        return (String)nominales.get((int)valorReal);
    }

    public int totalNominales(int atributo) {
        return Attributes.getInputAttribute(atributo).getNumNominalValues();
    }

    public String claseMasFrecuente() {
        int[] clases = new int[this.nClasses];
        for (int i = 0; i < this.outputInteger.length; ++i) {
            int n = this.outputInteger[i];
            clases[n] = clases[n] + 1;
        }
        int claseMayoritaria = 0;
        for (int i = 0; i < clases.length; ++i) {
            if (clases[claseMayoritaria] >= clases[i]) continue;
            claseMayoritaria = i;
        }
        return this.getOutputValue(claseMayoritaria);
    }

    public int numEjemplos(int clase) {
        int ejemplos = 0;
        for (int i = 0; i < this.outputInteger.length; ++i) {
            if (clase != this.outputInteger[i]) continue;
            ++ejemplos;
        }
        return ejemplos;
    }

    public boolean vacio() {
        return this.numberInstances(this.list_of_classes[0]) == 0 || this.numberInstances(this.list_of_classes[1]) == 0;
    }

    public String printDataSet() {
        System.out.println("Printing data-set...");
        String cadena = new String("");
        cadena = cadena + this.copyHeader();
        String cadenaAux = "";
        for (int i = 0; i < this.size(); ++i) {
            double[] ejemplo = this.getExample(i);
            String cadenaAux2 = "";
            for (int j = 0; j < this.getnInputs(); ++j) {
                cadenaAux2 = this.getTipo(j) == 2 ? cadenaAux2 + Attributes.getInputAttribute(j).getNominalValue((int)ejemplo[j]) + ", " : cadenaAux2 + ejemplo[j] + ", ";
            }
            cadenaAux = cadenaAux + cadenaAux2 + this.getOutputAsString(i) + "\n";
            if (i % 1000 != 0 && i != this.size() - 1) continue;
            cadena = cadena + cadenaAux;
            cadenaAux = "";
        }
        System.out.println("Data-set printed!");
        return cadena;
    }

    public List<Integer> asList(final int[] is) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int i) {
                return is[i];
            }

            @Override
            public int size() {
                return is.length;
            }
        };
    }

    void deleteExamples(boolean[] correct, int[] selected, int minC) {
        int i;
        ArrayList<Integer> delete = new ArrayList<Integer>();
        for (int i2 = 0; i2 < selected.length; ++i2) {
            if (!correct[selected[i2]] || this.outputInteger[selected[i2]] == minC || delete.contains(selected[i2])) continue;
            delete.add(selected[i2]);
        }
        double[][] X_aux = new double[this.size() - delete.size()][this.getnInputs()];
        int[] outputInteger_aux = new int[this.size() - delete.size()];
        String[] output_aux = new String[this.size() - delete.size()];
        int nDataAux = 0;
        for (i = 0; i < this.size(); ++i) {
            if (delete.contains(i)) continue;
            X_aux[nDataAux] = (double[])this.getExample(i).clone();
            outputInteger_aux[nDataAux] = this.getOutputAsInteger(i);
            output_aux[nDataAux] = this.getOutputAsString(i);
            ++nDataAux;
        }
        this.nData = nDataAux;
        this.X = new double[this.nData][this.nInputs];
        this.outputInteger = new int[this.nData];
        this.output = new String[this.nData];
        for (i = 0; i < this.nData; ++i) {
            this.X[i] = (double[])X_aux[i].clone();
            this.outputInteger[i] = outputInteger_aux[i];
            this.output[i] = output_aux[i];
        }
        this.computeInstancesPerClass();
    }

    public InstanceSet getIS() {
        return this.IS;
    }
}

