/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETERuleContext;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RETEConflictSet {
    protected static Log logger = LogFactory.getLog((Class)FRuleEngine.class);
    protected RETERuleContext gcontext;
    protected boolean isMonotonic;
    protected ArrayList conflictSet = new ArrayList();
    protected int nPos = 0;
    protected int nNeg = 0;

    public RETEConflictSet(RETERuleContext context, boolean isMonotonic) {
        this.gcontext = context;
        this.isMonotonic = isMonotonic;
    }

    public void add(Rule rule, BindingEnvironment env, boolean isAdd) {
        if (this.isMonotonic) {
            RETERuleContext context = new RETERuleContext((ForwardRuleInfGraphI)this.gcontext.getGraph(), this.gcontext.getEngine());
            context.setEnv(env);
            context.setRule(rule);
            RETEConflictSet.execute(context, isAdd);
        } else {
            boolean done = false;
            if (isAdd && this.nNeg > 0 || !isAdd && this.nPos > 0) {
                Iterator i = this.conflictSet.iterator();
                while (i.hasNext()) {
                    CSEntry cse = (CSEntry)i.next();
                    if (cse.rule != rule || !cse.env.equals(env) || isAdd == cse.isAdd) continue;
                    i.remove();
                    if (cse.isAdd) {
                        --this.nPos;
                    } else {
                        --this.nNeg;
                    }
                    done = true;
                }
            }
            if (!done) {
                this.conflictSet.add(new CSEntry(rule, env, isAdd));
                if (isAdd) {
                    ++this.nPos;
                } else {
                    ++this.nNeg;
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.conflictSet.isEmpty();
    }

    public boolean fireOne() {
        if (this.isEmpty()) {
            return false;
        }
        int index = this.conflictSet.size() - 1;
        CSEntry cse = (CSEntry)this.conflictSet.remove(index);
        if (cse.isAdd) {
            --this.nPos;
        } else {
            --this.nNeg;
        }
        RETERuleContext context = new RETERuleContext((ForwardRuleInfGraphI)this.gcontext.getGraph(), this.gcontext.getEngine());
        context.setEnv(cse.env);
        context.setRule(cse.rule);
        if (context.shouldStillFire()) {
            RETEConflictSet.execute(context, cse.isAdd);
        }
        return true;
    }

    public static void execute(RETERuleContext context, boolean isAdd) {
        int i;
        Rule rule = context.getRule();
        BindingEnvironment env = context.getEnv();
        ForwardRuleInfGraphI infGraph = (ForwardRuleInfGraphI)context.getGraph();
        if (infGraph.shouldTrace()) {
            logger.info((Object)("Fired rule: " + rule.toShortString()));
        }
        RETEEngine engine = context.getEngine();
        engine.incRuleCount();
        ArrayList<Triple> matchList = null;
        if (infGraph.shouldLogDerivations() && isAdd) {
            matchList = new ArrayList<Triple>(rule.bodyLength());
            for (i = 0; i < rule.bodyLength(); ++i) {
                ClauseEntry clause = rule.getBodyElement(i);
                if (!(clause instanceof TriplePattern)) continue;
                matchList.add(env.instantiate((TriplePattern)clause));
            }
        }
        for (i = 0; i < rule.headLength(); ++i) {
            ClauseEntry hClause = rule.getHeadElement(i);
            if (hClause instanceof TriplePattern) {
                Triple t = env.instantiate((TriplePattern)hClause);
                if (t.getSubject().isLiteral()) continue;
                if (isAdd) {
                    if (context.contains(t)) continue;
                    engine.addTriple(t, true);
                    if (!infGraph.shouldLogDerivations()) continue;
                    infGraph.logDerivation(t, new RuleDerivation(rule, t, matchList, infGraph));
                    continue;
                }
                if (!context.contains(t)) continue;
                engine.deleteTriple(t, true);
                continue;
            }
            if (hClause instanceof Functor && isAdd) {
                Functor f = (Functor)hClause;
                Builtin imp = f.getImplementor();
                if (imp != null) {
                    imp.headAction(f.getBoundArgs(env), f.getArgLength(), context);
                    continue;
                }
                throw new ReasonerException("Invoking undefined Functor " + f.getName() + " in " + rule.toShortString());
            }
            if (!(hClause instanceof Rule)) continue;
            Rule r = (Rule)hClause;
            if (r.isBackward()) {
                if (isAdd) {
                    infGraph.addBRule(r.instantiate(env));
                    continue;
                }
                infGraph.deleteBRule(r.instantiate(env));
                continue;
            }
            throw new ReasonerException("Found non-backward subrule : " + r);
        }
    }

    private static class CSEntry {
        protected Rule rule;
        protected BindingEnvironment env;
        protected boolean isAdd;

        CSEntry(Rule rule, BindingEnvironment env, boolean isAdd) {
            this.rule = rule;
            this.env = env;
            this.isAdd = isAdd;
        }
    }
}

