---
title: "CRAN comments"
---


# Reason for submission TBA
* In response to an email from Kurt Hornik <Kurt.Hornik@wu.ac.at> requesting an update to the current CRAN version (v2.1.1) of `RJafroc` which is generating ERRORS all of which are due to failing tests in `tests/testthat.R` related to the recent update of `ggplot2` on which my package depends. 
* This update (v2.1.2) should fix the ERRORS. 


# Test environments TBA

## OS X
* R version 4.2.2 (2022-10-31)
* Platform: x86_64-apple-darwin17.0 (64-bit)
* Running under: macOS Catalina 10.15.7
* iMac, 3.4GHz Quad-Core Intel Core i7

* `R CMD check` ran with no errors, warnings or notes


## GitHub Actions

* windows-latest (release): OK 
* macOS-latest (release):  OK
* ubuntu-20.04 (release): OK
* ubuntu-20.04 (devel): OK


## Windows portability

```
devtools::check_win_devel()
devtools::check_win_release()
devtools::check_win_oldrelease() 
```

| R Version    | Platform                    | Status |
|:-------------|:----------------------------|:-------|
| R-devel      | x86_64-w64-mingw32 (64-bit) | OK     |
| R release    | x86_64-w64-mingw32 (64-bit) | OK    |
| R-oldrelease | x86_64-w64-mingw32 (64-bit) | NOTE\*  |

`*` Possibly mis-spelled words in DESCRIPTION all of which are false positives.


## CRAN compatibility

CRAN compatibility was tested using `rhub::check_for_cran()`. The last three messages were generated by the previous version. The first one is new.

| Platform                                 | Status                                     |
|:-----------------------------------------|:-------------------------------------------|
| Fedora Linux, R-devel, clang, gfortran   | NOTE\*\*\*\*                                         |
| Ubuntu Linux 20.04.1 LTS, R-release, GCC | NOTE\*\*\* (file size is 5.8Mb, see below) |
| Debian Linux, R-devel, GCC ASAN/UBSAN    | PREPERROR\* (see below)                    |
| Windows Server 2022, R-devel, 64 bit     | NOTE\*\* (see below)                       |

`****` NOTE Skipping checking HTML validation: no command 'tidy' found. I am not using `tidy` and have not turned on HTML validation.

`***` I would have to remove a significant number of code, tests and datasets to meet the strict 5MB requirement on this platform. 

`*` PREPERROR: dependency ‘openxlsx’ not available; it appears one of the packages that my package depends on is not available on this platform.

`**` checking for detritus in the temp directory ... NOTE Found the following files/directories: 'lastMiKTeXException'. There is no such file/directory on my computer. This might be some issue with `LaTeX` that I cannot reproduce, [as others have observed](https://github.com/r-hub/rhub/issues/503). 


## Summary of checks in other `rhub`implemented environments

* These were selected based on the two NOTES generated by the earlier submission.

| Platform                                           | Status                                                |
|:---------------------------------------------------|:------------------------------------------------------|
| Debian Linux, R-devel, clang, ISO-8859-15 locale   | OK                                                    |
| Debian Linux, R-devel, clang, ISO-8859-15 locale   | OK                                                    |



# FAILURE SUMMARY (from last attempted submission)

The previous version installed with 0 errors, 0 warnings and 1 note (installed size is 5.2Mb). The size of the package has been reduced. 

# All revdep maintainers were notified of the release on release date

```
devtools::revdep()
```

No reverse dependencies were found.

