/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.ws;

import ec.satoolkit.ISaSpecification;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.satoolkit.x13.X13Specification;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.jdr.ws.SaItem;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd2.datatypes.Ts;
import jd2.datatypes.TsInformationType;
import jd2.datatypes.TsMoniker;
import jd2.datatypes.sa.SaItemType;
import jd2.datatypes.sa.SaProcessingType;
import lombok.Generated;

public class MultiProcessing {
    private final String name;
    private final Map<String, String> metaData = new HashMap<String, String>();
    private final List<SaItem> items = new ArrayList<SaItem>();

    public static MultiProcessing of(String name, SaProcessingType processing) {
        MultiProcessing p = new MultiProcessing(name);
        p.metaData.putAll(processing.getMetaData());
        processing.getItems().forEach(v -> p.items.add(new SaItem((SaItemType)v)));
        return p;
    }

    public void compute(ProcessingContext context) {
        this.items.forEach(v -> v.compute(context));
    }

    public void add(String name, TsData s, TramoSeatsSpecification spec) {
        Ts ts = Ts.builder().moniker(TsMoniker.NULL).type(TsInformationType.UserDefined).data(s).name(name).build();
        SaItemType item = SaItemType.builder().name(name).domainSpec((ISaSpecification)spec).ts(ts).build();
        this.items.add(new SaItem(item));
    }

    public void add(String name, TsData s, X13Specification spec) {
        Ts ts = Ts.builder().moniker(TsMoniker.NULL).type(TsInformationType.UserDefined).data(s).name(name).build();
        SaItemType item = SaItemType.builder().name(name).domainSpec((ISaSpecification)spec).ts(ts).build();
        this.items.add(new SaItem(item));
    }

    public SaProcessingType toType() {
        SaProcessingType sa = new SaProcessingType();
        sa.getMetaData().putAll(this.metaData);
        for (SaItem cur : this.items) {
            sa.getItems().add(cur.getSaDefinition());
        }
        return sa;
    }

    public SaItem get(int pos) {
        return this.items.get(pos);
    }

    public int size() {
        return this.items.size();
    }

    @Generated
    public MultiProcessing(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    @Generated
    public List<SaItem> getItems() {
        return this.items;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiProcessing)) {
            return false;
        }
        MultiProcessing other = (MultiProcessing)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$metaData = this.getMetaData();
        Map<String, String> other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        List<SaItem> this$items = this.getItems();
        List<SaItem> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MultiProcessing;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        List<SaItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MultiProcessing(name=" + this.getName() + ", metaData=" + this.getMetaData() + ", items=" + this.getItems() + ")";
    }
}

