/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.AbstractTimeVaryingRegSsf;
import ec.tstoolkit.ssf.ISsf;

public class TimeVaryingRegSsf
extends AbstractTimeVaryingRegSsf {
    private final Matrix nvar_;
    private final Matrix wnvar_;
    private final Matrix fullnvar_;

    public TimeVaryingRegSsf(ISsf ssf, SubMatrix X, Matrix nvar, Matrix wnvar) {
        super(ssf, X);
        this.nvar_ = nvar;
        this.wnvar_ = wnvar;
        this.fullnvar_ = wnvar == null ? nvar : SymmetricMatrix.quadraticFormT(nvar, wnvar);
    }

    public TimeVaryingRegSsf(ISsf ssf, SubMatrix X, Matrix nvar) {
        super(ssf, X);
        this.nvar_ = nvar;
        this.wnvar_ = null;
        this.fullnvar_ = nvar;
    }

    public Matrix getNoiseVar() {
        return this.nvar_;
    }

    public Matrix getFullNoiseVar() {
        return this.fullnvar_;
    }

    @Override
    protected void fullRegNoise(int pos, SubMatrix vregs) {
        vregs.copy(this.fullnvar_.subMatrix());
    }

    @Override
    protected int getRegNoiseDim() {
        return this.fullnvar_.getColumnsCount();
    }

    @Override
    protected boolean isRegNoiseTimeInvariant() {
        return true;
    }

    @Override
    protected void regNoise(int pos, SubMatrix vregs) {
        vregs.copy(this.nvar_.subMatrix());
    }

    @Override
    protected void wRegNoise(int pos, SubMatrix vregs) {
        if (this.wnvar_ != null) {
            vregs.copy(this.wnvar_.subMatrix());
        }
    }
}

