/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.DisaggregationModel;
import ec.benchmarking.DisaggregationType;
import ec.benchmarking.simplets.TsDisaggregation;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.ssf.arima.SsfAr1;
import ec.tstoolkit.ssf.arima.SsfArima;
import ec.tstoolkit.ssf.arima.SsfRw;
import ec.tstoolkit.ssf.arima.SsfRwAr1;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.regression.Constant;
import ec.tstoolkit.timeseries.regression.LinearTrend;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class TsExpander {
    private double param_ = 0.0;
    private boolean cnt_ = false;
    private boolean trend_ = false;
    private boolean estimate_ = true;
    private TsAggregationType type_ = TsAggregationType.Sum;
    private Model model_ = Model.I1;

    public void estimateParameter(boolean value) {
        this.estimate_ = value;
    }

    public TsData expand(TsData s, TsDomain ndom) {
        DisaggregationModel model = new DisaggregationModel(ndom.getFrequency());
        if (this.cnt_ && this.model_ == Model.AR1) {
            model.getX().add(new Constant());
        }
        if (this.trend_ && (this.model_ == Model.AR1 || this.model_ == Model.I1 || this.model_ == Model.I1AR1)) {
            model.getX().add(new LinearTrend(ndom.getStart().firstday()));
        }
        model.setDisaggregationType(DisaggregationType.Level);
        model.setAggregationType(this.type_);
        model.setY(s);
        switch (this.model_.ordinal()) {
            case 0: {
                TsDisaggregation<SsfAr1> disagg = new TsDisaggregation<SsfAr1>();
                disagg.setSsf(new SsfAr1(this.param_));
                if (this.estimate_) {
                    disagg.setMapping(new SsfAr1.Mapping(false));
                }
                if (!disagg.process(model, ndom)) break;
                if (this.estimate_) {
                    this.param_ = ((SsfAr1)disagg.getEstimatedSsf()).getRho();
                }
                return disagg.getSmoothedSeries();
            }
            case 2: {
                TsDisaggregation<SsfRwAr1> disagg = new TsDisaggregation<SsfRwAr1>();
                disagg.setSsf(new SsfRwAr1(this.param_));
                if (this.estimate_) {
                    disagg.setMapping(new SsfRwAr1.Mapping(false));
                }
                if (!disagg.process(model, ndom)) break;
                if (this.estimate_) {
                    this.param_ = ((SsfRwAr1)disagg.getEstimatedSsf()).getRho();
                }
                return disagg.getSmoothedSeries();
            }
            case 1: {
                TsDisaggregation<SsfRw> disagg = new TsDisaggregation<SsfRw>();
                disagg.setSsf(new SsfRw());
                if (!disagg.process(model, ndom)) break;
                return disagg.getSmoothedSeries();
            }
            case 3: {
                SarimaSpecification spec = new SarimaSpecification();
                spec.setD(2);
                TsDisaggregation<SsfArima> disagg = new TsDisaggregation<SsfArima>();
                disagg.setSsf(new SsfArima(new SarimaModel(spec)));
                disagg.useDisturbanceSmoother(false);
                if (!disagg.process(model, ndom)) break;
                return disagg.getSmoothedSeries();
            }
            case 4: {
                SarimaSpecification spec = new SarimaSpecification();
                spec.setD(3);
                TsDisaggregation<SsfArima> disagg = new TsDisaggregation<SsfArima>();
                disagg.setSsf(new SsfArima(new SarimaModel(spec)));
                disagg.useDisturbanceSmoother(false);
                if (!disagg.process(model, ndom)) break;
                return disagg.getSmoothedSeries();
            }
        }
        return null;
    }

    public TsData expand(TsData s, TsFrequency nfreq) {
        int isfreq;
        int infreq = nfreq.intValue();
        if (infreq < (isfreq = s.getFrequency().intValue())) {
            return null;
        }
        if (nfreq == s.getFrequency()) {
            return s;
        }
        if (infreq % isfreq != 0) {
            return null;
        }
        TsPeriod start = s.getStart();
        int c = infreq / isfreq;
        TsPeriod nstart = new TsPeriod(nfreq, start.getYear(), start.getPosition() * c);
        TsDomain ndom = new TsDomain(nstart, s.getLength() * c);
        return this.expand(s, ndom);
    }

    public Model getModel() {
        return this.model_;
    }

    public double getParameter() {
        return this.param_;
    }

    public TsAggregationType getType() {
        return this.type_;
    }

    public boolean isEstimatingParameter() {
        return this.estimate_;
    }

    public boolean isUsingConst() {
        return this.cnt_;
    }

    public boolean isUsingTrend() {
        return this.trend_;
    }

    public void setModel(Model value) {
        this.model_ = value;
    }

    public void setParameter(double value) {
        if (value <= -1.0 || value >= 1.0) {
            throw new TsException("Invalid parameter (should be in ]-1, 1[");
        }
        this.param_ = value;
    }

    public void setType(TsAggregationType value) {
        this.type_ = value;
    }

    public void useConst(boolean value) {
        this.cnt_ = value;
    }

    public void useTrend(boolean value) {
        this.trend_ = value;
    }

    public static enum Model {
        AR1,
        I1,
        I1AR1,
        I2,
        I3;

    }
}

