# ***********************************************************
# findPat:
#   Search vec for all patterns in pat, and return the
#   matched elements in vec.
# Arguments:
#   pat - character vector of patterns to match in vec.
#   vec - character vector where matches are sought.
# -----------------------------------------------------------
findPat <- function (pat, vec) {
  n <- length(vec)
  z <- NULL
  for (xstr in pat) {
    a <- regexpr(xstr, vec)
    b <- (1:n)[a > 0]
    z <- union(z, b) }
  found <- vec[z]
  return(found) }
