/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.core.splitcriteria;

import moa.classifiers.rules.core.Utils;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.core.DoubleVector;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class MultiTargetVarianceRatio
extends AbstractOptionHandler
implements MultiLabelSplitCriterion {
    private static final long serialVersionUID = 1L;

    @Override
    public double getMeritOfSplit(DoubleVector[] preSplitDist, DoubleVector[][] postSplitDists) {
        double error = 0.0;
        int numOutputs = preSplitDist.length;
        for (int i = 0; i < numOutputs; ++i) {
            error += this.getMeritOfSplitForOutput(preSplitDist, postSplitDists, i);
        }
        return error / (double)numOutputs;
    }

    public double[] getBranchSplitVarianceOutput(DoubleVector[] postSplitDists) {
        double[] variances = new double[postSplitDists.length];
        for (int i = 0; i < postSplitDists.length; ++i) {
            variances[i] = Utils.computeVariance(postSplitDists[i]);
        }
        return variances;
    }

    @Override
    public double[] getBranchesSplitMerits(DoubleVector[][] postSplitDists) {
        int numOutputs = postSplitDists.length;
        int numBranches = postSplitDists[0].length;
        double[] merits = new double[numBranches];
        for (int j = 0; j < numOutputs; ++j) {
            double[] branchMeritsOutput = this.getBranchSplitVarianceOutput(postSplitDists[j]);
            for (int i = 0; i < numBranches; ++i) {
                if (postSplitDists[j][i].getValue(0) > 0.0) {
                    int n = i;
                    merits[n] = merits[n] - branchMeritsOutput[i];
                    continue;
                }
                merits[i] = -1.7976931348623157E308;
            }
        }
        return merits;
    }

    protected double getMeritOfSplitForOutput(DoubleVector[] preSplitDist, DoubleVector[][] postSplitDists, int outputAttributeIndex) {
        return this.getMeritOfSplitForOutput(preSplitDist[outputAttributeIndex], postSplitDists[outputAttributeIndex]);
    }

    protected double getMeritOfSplitForOutput(DoubleVector preSplitDist, DoubleVector[] postSplitDists) {
        double merit = 0.0;
        int count = 0;
        for (int i = 0; i < postSplitDists.length; ++i) {
            if (!(postSplitDists[i].getValue(0) >= 0.05 * preSplitDist.getValue(0))) continue;
            ++count;
        }
        if (count == postSplitDists.length) {
            double varPreSplit = Utils.computeVariance(preSplitDist);
            double sumVarPostSplit = 0.0;
            double weightTotal = 0.0;
            for (int i = 0; i < postSplitDists.length; ++i) {
                weightTotal += postSplitDists[i].getValue(0);
            }
            double[] variances = this.getBranchSplitVarianceOutput(postSplitDists);
            for (int i = 0; i < variances.length; ++i) {
                if (!(postSplitDists[i].getValue(0) > 0.0)) continue;
                sumVarPostSplit += postSplitDists[i].getValue(0) / weightTotal * variances[i];
            }
            merit = 1.0 - sumVarPostSplit / varPreSplit;
        }
        return merit;
    }

    @Override
    public double getRangeOfMerit(DoubleVector[] preSplitDist) {
        return 1.0;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

