/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.active;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.LinkedList;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.active.ALClassifier;
import moa.classifiers.active.budget.BudgetManager;
import moa.core.Measurement;
import moa.options.ClassOption;

public class ALRandom
extends AbstractClassifier
implements ALClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "drift.SingleClassifierDrift");
    public ClassOption budgetManagerOption = new ClassOption("budgetManager", 'b', "BudgetManager that should be used.", BudgetManager.class, "FixedBM");
    public Classifier classifier;
    public BudgetManager budgetManager;

    @Override
    public String getPurposeString() {
        return "Random Active learning classifier for evolving data streams";
    }

    @Override
    public int getLastLabelAcqReport() {
        return this.budgetManager.getLastLabelAcqReport();
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return this.classifier.getVotesForInstance(inst);
    }

    @Override
    public void resetLearningImpl() {
        this.classifier = ((Classifier)this.getPreparedClassOption(this.baseLearnerOption)).copy();
        this.classifier.resetLearning();
        this.budgetManager = (BudgetManager)this.getPreparedClassOption(this.budgetManagerOption);
        this.budgetManager.resetLearning();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        double value = this.classifierRandom.nextDouble();
        if (this.budgetManager.isAbove(value)) {
            this.classifier.trainOnInstance(inst);
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        LinkedList measurementList = new LinkedList();
        return measurementList.toArray(new Measurement[measurementList.size()]);
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        ((AbstractClassifier)this.classifier).getModelDescription(out, indent);
    }

    @Override
    public void setModelContext(InstancesHeader ih) {
        super.setModelContext(ih);
        this.classifier.setModelContext(ih);
    }
}

