/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.RealRange;

public class RealInterval
implements EuclidConstants {
    double x1;
    double x2;

    public RealInterval() {
        this(0.0, 1.0);
    }

    public RealInterval(double x1, double x2) {
        this.x1 = x1;
        this.x2 = x2;
    }

    public RealInterval(RealInterval interval) {
        this.x1 = interval.x1;
        this.x2 = interval.x2;
    }

    public double getLength() {
        return this.x2 - this.x1;
    }

    public RealInterval(RealRange range) {
        this(range.getMin(), range.getMax());
    }

    public double scaleTo(RealInterval interval) {
        double scale = Double.NaN;
        try {
            scale = interval.getLength() / this.getLength();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return scale;
    }

    static double offsetTo(double scale, double xthis, double xthat) {
        return xthat - xthis * scale;
    }

    public double offsetTo(RealInterval interval) {
        return this.offsetTo(interval, this.scaleTo(interval));
    }

    public double offsetTo(RealInterval interval, double scale) {
        return interval.x1 - scale * this.x1;
    }

    public double midPoint() {
        return (this.x1 + this.x2) / 2.0;
    }
}

