/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.util.Objects;

public class Language {
    private final String lang;
    private final double confidence;

    public Language(String lang) {
        this(lang, 0.0);
    }

    public Language(String lang, double confidence) {
        Objects.requireNonNull(lang, "lang must not be null");
        this.lang = lang;
        this.confidence = confidence;
    }

    public String getLang() {
        return this.lang;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLang()).append(" (").append(this.confidence).append(")");
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.getLang(), this.getConfidence());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Language) {
            Language a = (Language)obj;
            return this.getLang().equals(a.getLang());
        }
        return false;
    }
}

