/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.ext.problems.objectives;

import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.ext.problems.objectives.evaluations.NormalizedEvaluation;

public class NormalizedObjective<SolutionType extends Solution, DataType>
implements Objective<SolutionType, DataType> {
    private final Objective<? super SolutionType, ? super DataType> obj;
    private final double min;
    private final double max;

    public NormalizedObjective(Objective<? super SolutionType, ? super DataType> obj, double min, double max) {
        if (obj == null) {
            throw new NullPointerException("Error while initializing normalized objective: wrapped objective can not be null.");
        }
        this.obj = obj;
        this.min = min;
        this.max = max;
    }

    public Objective<? super SolutionType, ? super DataType> getUnnormalizedObjective() {
        return this.obj;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public NormalizedEvaluation evaluate(SolutionType solution, DataType data) {
        Evaluation eval = this.obj.evaluate(solution, data);
        return new NormalizedEvaluation(eval, this.min, this.max);
    }

    @Override
    public <ActualSolutionType extends SolutionType> NormalizedEvaluation evaluate(Move<? super ActualSolutionType> move, ActualSolutionType curSolution, Evaluation curEvaluation, DataType data) {
        NormalizedEvaluation normalizedEval = (NormalizedEvaluation)curEvaluation;
        Evaluation eval = normalizedEval.getUnnormalizedEvaluation();
        Evaluation newEval = this.obj.evaluate(move, curSolution, eval, data);
        NormalizedEvaluation newNormalizedEval = new NormalizedEvaluation(newEval, this.min, this.max);
        return newNormalizedEval;
    }

    @Override
    public boolean isMinimizing() {
        return this.obj.isMinimizing();
    }

    public String toString() {
        String interval = "[" + this.min + ", " + this.max + "]";
        return String.format("\"%s\" normalized from %s to [0, 1]", this.obj, interval);
    }
}

