/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.ssf.DiffusePredictionErrorDecomposition;
import ec.tstoolkit.ssf.DiffuseSquareRootInitializer;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.RegSsf;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.arima.SsfArima;

public class OneStepAheadPredictionErrors {
    public static DataBlock errors(RegArimaModel regarima) {
        ISsf ssf;
        Object arima = regarima.getArima();
        if (regarima.isMeanCorrection()) {
            arima = new ArimaModel(arima.getStationaryAR(), arima.getNonStationaryAR().times(BackFilter.D1), arima.getMA().times(BackFilter.D1), arima.getInnovationVariance());
        }
        SsfArima ssfarima = new SsfArima((IArimaModel)arima);
        DataBlock y = regarima.getY().deepClone();
        int nx = regarima.getXCount();
        if (nx > 0) {
            Matrix x = new Matrix(y.getLength(), nx);
            for (int i = 0; i < nx; ++i) {
                x.column(i).copy(regarima.X(i));
            }
            ssf = new RegSsf(ssfarima, x.all());
        } else {
            ssf = ssfarima;
        }
        Filter<ISsf> filter = new Filter<ISsf>();
        filter.setSsf(ssf);
        filter.setInitializer(new DiffuseSquareRootInitializer());
        int[] missings = regarima.getMissings();
        if (missings != null) {
            for (int i = 0; i < missings.length; ++i) {
                y.set(missings[i], Double.NaN);
            }
        }
        DiffusePredictionErrorDecomposition ped = new DiffusePredictionErrorDecomposition(true);
        filter.process(new SsfData(y, null), ped);
        return new DataBlock(ped.residuals(false));
    }
}

