/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.util.Num;

public class HypergeometricDist
extends DiscreteDistributionInt {
    private int m;
    private int l;
    private int k;
    private double p0;
    public static double MAXN = 100000.0;

    public HypergeometricDist(int n, int n2, int n3) {
        this.setParams(n, n2, n3);
    }

    public double prob(int n) {
        if (this.pdf == null || n < this.xmin || n > this.xmax) {
            return HypergeometricDist.prob(this.m, this.l, this.k, n);
        }
        return this.pdf[n - this.xmin];
    }

    public double cdf(int n) {
        if (this.cdf != null) {
            if (n >= this.xmax) {
                return 1.0;
            }
            if (n < this.xmin) {
                return HypergeometricDist.cdf(this.m, this.l, this.k, n);
            }
            if (n <= this.xmed) {
                return this.cdf[n - this.xmin];
            }
            return 1.0 - this.cdf[n + 1 - this.xmin];
        }
        return HypergeometricDist.cdf(this.m, this.l, this.k, n);
    }

    public double barF(int n) {
        if (this.cdf != null) {
            if (n > this.xmax) {
                return 0.0;
            }
            if (n <= this.xmin) {
                return 1.0;
            }
            if (n > this.xmed) {
                return this.cdf[n - this.xmin];
            }
            return 1.0 - this.cdf[n - 1 - this.xmin];
        }
        return 1.0 - HypergeometricDist.cdf(this.m, this.l, this.k, n + 1);
    }

    public int inverseFInt(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (d <= 0.0) {
            return Math.max(0, this.k - this.l + this.m);
        }
        if (d >= 1.0) {
            return Math.min(this.k, this.m);
        }
        double d2 = this.p0;
        int n = Math.max(0, this.k - this.l + this.m);
        if (d <= d2) {
            return n;
        }
        do {
            d2 = d2 * (double)(this.m - n) * (double)(this.k - n) / ((double)(n + 1) * ((double)(this.l - this.m - this.k) + 1.0 + (double)n));
            ++n;
        } while ((d -= d2) > d2);
        return n;
    }

    public double getMean() {
        return HypergeometricDist.getMean(this.m, this.l, this.k);
    }

    public double getVariance() {
        return HypergeometricDist.getVariance(this.m, this.l, this.k);
    }

    public double getStandardDeviation() {
        return HypergeometricDist.getStandardDeviation(this.m, this.l, this.k);
    }

    public static double prob(int n, int n2, int n3, int n4) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (n <= 0 || n > n2) {
            throw new IllegalArgumentException("m is invalid: 1<=m<l");
        }
        if (n3 <= 0 || n3 > n2) {
            throw new IllegalArgumentException("k is invalid: 1<=k<l");
        }
        if (n4 < Math.max(0, n3 - n2 + n) || n4 > Math.min(n3, n)) {
            return 0.0;
        }
        if (n4 <= 15) {
            return Num.combination(n, n4) * Num.combination(n2 - n, n3 - n4) / Num.combination(n2, n3);
        }
        double d = Num.lnFactorial(n) + Num.lnFactorial(n2 - n) - Num.lnFactorial(n2) - Num.lnFactorial(n4) - Num.lnFactorial(n3 - n4) + Num.lnFactorial(n3) - Num.lnFactorial(n - n4) - Num.lnFactorial(n2 - n - n3 + n4) + Num.lnFactorial(n2 - n3);
        if (d >= 709.0895657128241) {
            throw new IllegalArgumentException("term overflow");
        }
        return Math.exp(d);
    }

    public static double cdf(int n, int n2, int n3, int n4) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (n <= 0 || n > n2) {
            throw new IllegalArgumentException("m is invalid: 1<=m<l");
        }
        if (n3 <= 0 || n3 > n2) {
            throw new IllegalArgumentException("k is invalid: 1<=k<l");
        }
        int n5 = Math.max(0, n3 - n2 + n);
        int n6 = Math.min(n3, n);
        if (n4 < n5) {
            return 0.0;
        }
        if (n4 > n6) {
            return 1.0;
        }
        double d = 0.0;
        for (int i = n5; i <= n4; ++i) {
            d += HypergeometricDist.prob(n, n2, n3, i);
        }
        return d;
    }

    public static double barF(int n, int n2, int n3, int n4) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (n <= 0 || n > n2) {
            throw new IllegalArgumentException("m is invalid: 1<=m<l");
        }
        if (n3 <= 0 || n3 > n2) {
            throw new IllegalArgumentException("k is invalid: 1<=k<l");
        }
        int n5 = Math.max(0, n3 - n2 + n);
        int n6 = Math.min(n3, n);
        if (n4 < n5) {
            return 1.0;
        }
        if (n4 > n6) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = n6; i >= n4; --i) {
            d += HypergeometricDist.prob(n, n2, n3, i);
        }
        return d;
    }

    public static int inverseF(int n, int n2, int n3, double d) {
        if (d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (d <= 0.0) {
            return Math.max(0, n3 - n2 + n);
        }
        if (d >= 1.0) {
            return Math.min(n3, n);
        }
        double d2 = 0.0;
        d2 = n3 < n2 - n ? Math.exp(Num.lnFactorial(n2 - n) + Num.lnFactorial(n2 - n3) - Num.lnFactorial(n2) - Num.lnFactorial(n2 - n - n3)) : Math.exp(Num.lnFactorial(n) + Num.lnFactorial(n3) - Num.lnFactorial(n3 - n2 + n) - Num.lnFactorial(n2));
        int n4 = Math.max(0, n3 - n2 + n);
        if (d <= d2) {
            return n4;
        }
        do {
            d2 = d2 * (double)(n - n4) * (double)(n3 - n4) / ((double)(n4 + 1) * ((double)(n2 - n - n3) + 1.0 + (double)n4));
            ++n4;
        } while ((d -= d2) > d2 && d2 > 0.0);
        return n4;
    }

    public static double getMean(int n, int n2, int n3) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (n <= 0 || n > n2) {
            throw new IllegalArgumentException("m is invalid: 1<=m<l");
        }
        if (n3 <= 0 || n3 > n2) {
            throw new IllegalArgumentException("k is invalid: 1<=k<l");
        }
        return (double)n3 * (double)n / (double)n2;
    }

    public static double getVariance(int n, int n2, int n3) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (n <= 0 || n > n2) {
            throw new IllegalArgumentException("m is invalid: 1<=m<l");
        }
        if (n3 <= 0 || n3 > n2) {
            throw new IllegalArgumentException("k is invalid: 1<=k<l");
        }
        return (double)n3 * (double)n / (double)n2 * (1.0 - (double)n / (double)n2) * ((double)n2 - (double)n3) / ((double)n2 - 1.0);
    }

    public static double getStandardDeviation(int n, int n2, int n3) {
        return Math.sqrt(HypergeometricDist.getVariance(n, n2, n3));
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public int getK() {
        return this.k;
    }

    private void setHypergeometric() {
        int n;
        int n2 = Math.max(0, this.k - this.l + this.m);
        int n3 = Math.min(this.k, this.m);
        this.supportA = n2;
        this.supportB = n3;
        int n4 = n3 - n2 + 1;
        if ((double)n4 > MAXN) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        int n5 = n2;
        n2 = 0;
        n3 -= n5;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        int n6 = (int)(((double)this.k + 1.0) * ((double)this.m + 1.0) / ((double)this.l + 2.0));
        int n7 = n6 - n5;
        dArray[n7] = HypergeometricDist.prob(this.m, this.l, this.k, n6);
        for (n = n7; n > n2 && Math.abs(dArray[n]) > EPSILON; --n) {
            dArray[n - 1] = dArray[n] * (double)(n + n5) / (double)(this.m - n - n5 + 1) * (double)(this.l - this.m - this.k + n + n5) / (double)(this.k - n - n5 + 1);
        }
        n2 = n;
        for (n = n7; n < n3 && Math.abs(dArray[n]) > EPSILON; ++n) {
            dArray[n + 1] = dArray[n] * (double)(this.m - n - n5) / (double)(n + n5 + 1) * (double)(this.k - n - n5) / (double)(this.l - this.m - this.k + n + n5 + 1);
        }
        n3 = n;
        dArray2[n2] = dArray[n2];
        n = n2;
        while (n < n3 && dArray2[n] < 0.5) {
            dArray2[++n] = dArray2[n - 1] + dArray[n];
        }
        this.xmed = n;
        dArray2[n3] = dArray[n3];
        n = n3 - 1;
        do {
            dArray2[n] = dArray[n] + dArray2[n + 1];
        } while (--n > this.xmed);
        this.xmin = n2 + n5;
        this.xmax = n3 + n5;
        this.xmed += n5;
        this.pdf = new double[n3 + 1 - n2];
        this.cdf = new double[n3 + 1 - n2];
        System.arraycopy(dArray, n2, this.pdf, 0, n3 + 1 - n2);
        System.arraycopy(dArray2, n2, this.cdf, 0, n3 + 1 - n2);
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.m, this.l, this.k};
        return dArray;
    }

    public void setParams(int n, int n2, int n3) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (n <= 0 || n > n2) {
            throw new IllegalArgumentException("m is invalid: 1<=m<l");
        }
        if (n3 <= 0 || n3 > n2) {
            throw new IllegalArgumentException("k is invalid: 1<=k<l");
        }
        this.m = n;
        this.l = n2;
        this.k = n3;
        this.setHypergeometric();
        this.p0 = n3 < n2 - n ? Math.exp(Num.lnFactorial(n2 - n) + Num.lnFactorial(n2 - n3) - Num.lnFactorial(n2) - Num.lnFactorial(n2 - n - n3)) : Math.exp(Num.lnFactorial(n) + Num.lnFactorial(n3) - Num.lnFactorial(n3 - n2 + n) - Num.lnFactorial(n2));
    }

    public String toString() {
        return this.getClass().getName() + " : m = " + this.m + ", l = " + this.l + ", k = " + this.k;
    }
}

