/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeBFILE;
import oracle.jdbc.oracore.OracleTypeBINARY_DOUBLE;
import oracle.jdbc.oracore.OracleTypeBINARY_FLOAT;
import oracle.jdbc.oracore.OracleTypeBLOB;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeDATE;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeINTERVAL;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.jdbc.oracore.OracleTypeROWID;
import oracle.jdbc.oracore.OracleTypeSINT32;
import oracle.jdbc.oracore.OracleTypeTIMESTAMP;
import oracle.jdbc.oracore.OracleTypeTIMESTAMPLTZ;
import oracle.jdbc.oracore.OracleTypeTIMESTAMPTZ;
import oracle.jdbc.oracore.OracleTypeUPT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSPatch;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.jdbc.oracore.Util;
import oracle.sql.AttributeDescriptor;
import oracle.sql.BLOB;
import oracle.sql.Datum;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeADT
extends OracleNamedType
implements Serializable {
    static final long serialVersionUID = 3031304012507165702L;
    static final int S_TOP = 1;
    static final int S_EMBEDDED = 2;
    static final int S_UPT_ADT = 4;
    static final int S_JAVA_OBJECT = 16;
    static final int S_FINAL_TYPE = 32;
    static final int S_SUB_TYPE = 64;
    static final int S_ATTR_TDS = 128;
    static final int S_HAS_METADATA = 256;
    static final int S_TDS_PARSED = 512;
    private int statusBits = 1;
    int tdsVersion = -9999;
    static final int KOPT_V80 = 1;
    static final int KOPT_V81 = 2;
    static final int KOPT_VNFT = 3;
    static final int KOPT_VERSION = 3;
    boolean endOfAdt = false;
    int typeVersion = 1;
    long fixedDataSize = -1L;
    int alignmentRequirement = -1;
    OracleType[] attrTypes = null;
    String[] attrNames;
    String[] attrTypeNames;
    public long tdoCState = 0L;
    byte[] toid = null;
    int charSetId;
    int charSetForm;
    int flattenedAttrNum;
    transient int opcode;
    transient int idx = 1;
    boolean isTransient = false;
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_SYNONYM_10g = 2;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 3;
    static final int CURRENT_USER_PUBLIC_SYNONYM_10g = 4;
    static final int POSSIBLY_OTHER_USER_OBJECT = 5;
    static final int POSSIBLY_OTHER_USER_OBJECT_10g = 6;
    static final int OTHER_USER_OBJECT = 7;
    static final int OTHER_USER_SYNONYM = 8;
    static final int PUBLIC_SYNONYM = 9;
    static final int PUBLIC_SYNONYM_10g = 10;
    static final int BREAK = 11;
    static final String[] sqlString = new String[]{"SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME = :1 ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ORDER BY ATTR_NO", "DECLARE CURSOR usyn_cur IS SELECT table_name, table_owner from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; l_syntown  user_synonyms.table_owner%TYPE; BEGIN SELECT TABLE_NAME, TABLE_OWNER BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name;   l_syntown :=  table_names(lastrow).table_owner; END IF; OPEN ? FOR SELECT  ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER   FROM ALL_TYPE_ATTRS  A   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?)  AND  A.OWNER = l_syntown   ORDER BY ATTR_NO; END;", "DECLARE CURSOR usyn_cur IS SELECT table_name, table_owner from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; l_syntown  user_synonyms.table_owner%TYPE; BEGIN SELECT TABLE_NAME, TABLE_OWNER BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY NOCYCLEPRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name;   l_syntown :=  table_names(lastrow).table_owner; END IF; OPEN ? FOR SELECT  ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER   FROM ALL_TYPE_ATTRS  A   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?)  AND  A.OWNER = l_syntown   ORDER BY ATTR_NO; END;", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = :1 AND TYPE_NAME = :2 ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = (SELECT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ORDER BY ATTR_NO", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME,  ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME,  ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};
    static final int SEARCH_USER_TYPES = 0;
    static final int SEARCH_ALL_TYPES = 1;
    static final String[] sqlStringTOID = new String[]{"SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS a, USER_TYPES b WHERE b.TYPE_OID = :1 AND a.TYPE_NAME = b.TYPE_NAME ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS a, ALL_TYPES b WHERE b.TYPE_OID = :1 AND a.TYPE_NAME = b.TYPE_NAME AND a.OWNER = b.OWNER ORDER BY ATTR_NO"};
    Boolean isInstanciable;
    String superTypeName;
    int numberOfLocalAttributes = -1;
    String[] subTypeNames;
    final int LOCAL_TYPE = 0;
    final int LOOK_FOR_USER_SYNONYM = 1;
    final int LOOK_FOR_PUBLIC_SYNONYM = 2;
    final String[] initMetaData1_9_0_SQL = new String[]{"SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES FROM all_types WHERE type_name = :1 AND owner = :2 ", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM USER_SYNONYMS WHERE \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM ALL_SYNONYMS WHERE \n         OWNER = 'PUBLIC' AND \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;"};
    static final int TDS_SIZE = 4;
    static final int TDS_NUMBER = 1;
    static final int KOPM_OTS_SQL_CHAR = 1;
    static final int KOPM_OTS_DATE = 2;
    static final int KOPM_OTS_DECIMAL = 3;
    static final int KOPM_OTS_DOUBLE = 4;
    static final int KOPM_OTS_FLOAT = 5;
    static final int KOPM_OTS_NUMBER = 6;
    static final int KOPM_OTS_SQL_VARCHAR2 = 7;
    static final int KOPM_OTS_SINT32 = 8;
    static final int KOPM_OTS_REF = 9;
    static final int KOPM_OTS_VARRAY = 10;
    static final int KOPM_OTS_UINT8 = 11;
    static final int KOPM_OTS_SINT8 = 12;
    static final int KOPM_OTS_UINT16 = 13;
    static final int KOPM_OTS_UINT32 = 14;
    static final int KOPM_OTS_LOB = 15;
    static final int KOPM_OTS_UROWID = 16;
    static final int KOPM_OTS_CANONICAL = 17;
    static final int KOPM_OTS_OCTET = 18;
    static final int KOPM_OTS_RAW = 19;
    static final int KOPM_OTS_ROWID = 20;
    static final int KOPM_OTS_STAMP = 21;
    static final int KOPM_OTS_TZSTAMP = 23;
    static final int KOPM_OTS_INTERVAL = 24;
    static final int KOPM_OTS_PTR = 25;
    static final int KOPM_OTS_SINT16 = 26;
    static final int KOPM_OTS_UPT = 27;
    static final int KOPM_OTS_COLLECTION = 28;
    static final int KOPM_OTS_CLOB = 29;
    static final int KOPM_OTS_BLOB = 30;
    static final int KOPM_OTS_BFILE = 31;
    static final int KOPM_OTS_BINARY_INTEGE = 32;
    static final int KOPM_OTS_IMPTZSTAMP = 33;
    static final int KOPM_OTS_BFLOAT = 37;
    static final int KOPM_OTS_BDOUBLE = 45;
    static final int KOTTCOPQ = 58;
    static final int KOPT_OP_STARTEMBADT = 39;
    static final int KOPT_OP_ENDEMBADT = 40;
    static final int KOPT_OP_STARTADT = 41;
    static final int KOPT_OP_ENDADT = 42;
    static final int KOPT_OP_SUBTYPE_MARKER = 43;
    static final int KOPT_OP_EMBADT_INFO = 44;
    static final int KOPT_OPCODE_START = 38;
    static final int KOPT_OP_VERSION = 38;
    static final int REGULAR_PATCH = 0;
    static final int SIMPLE_PATCH = 1;

    protected OracleTypeADT() {
    }

    public OracleTypeADT(byte[] byArray, int n2, int n3, short s2, String string) throws SQLException {
        this(string, (Connection)null);
        this.toid = byArray;
        this.typeVersion = n2;
        this.charSetId = n3;
        this.charSetForm = s2;
    }

    public OracleTypeADT(String string, Connection connection) throws SQLException {
        super(string, (OracleConnection)connection);
        this.typeNameByUser = string;
    }

    public OracleTypeADT(OracleTypeADT oracleTypeADT, int n2, Connection connection) throws SQLException {
        super(oracleTypeADT, n2, (OracleConnection)connection);
    }

    public OracleTypeADT(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        this.sqlName = sQLName;
        this.init(byArray2, oracleConnection);
        this.toid = byArray;
        this.typeVersion = n2;
    }

    public OracleTypeADT(AttributeDescriptor[] attributeDescriptorArray, OracleConnection oracleConnection) throws SQLException {
        int n2;
        this.setConnectionInternal(oracleConnection);
        this.isTransient = true;
        this.flattenedAttrNum = attributeDescriptorArray.length;
        this.attrTypes = new OracleType[this.flattenedAttrNum];
        this.attrNames = new String[this.flattenedAttrNum];
        for (n2 = 0; n2 < this.flattenedAttrNum; ++n2) {
            this.attrNames[n2] = attributeDescriptorArray[n2].getAttributeName();
        }
        this.statusBits |= 0x100;
        block25: for (n2 = 0; n2 < this.flattenedAttrNum; ++n2) {
            TypeDescriptor typeDescriptor = attributeDescriptorArray[n2].getTypeDescriptor();
            switch (typeDescriptor.getInternalTypeCode()) {
                case 12: {
                    this.attrTypes[n2] = new OracleTypeDATE();
                    continue block25;
                }
                case 9: {
                    this.attrTypes[n2] = new OracleTypeCHAR(this.connection, 12);
                    ((OracleTypeCHAR)this.attrTypes[n2]).length = (int)typeDescriptor.getPrecision();
                    ((OracleTypeCHAR)this.attrTypes[n2]).form = 1;
                    continue block25;
                }
                case 96: {
                    this.attrTypes[n2] = new OracleTypeCHAR(this.connection, 1);
                    ((OracleTypeCHAR)this.attrTypes[n2]).length = (int)typeDescriptor.getPrecision();
                    ((OracleTypeCHAR)this.attrTypes[n2]).form = 1;
                    continue block25;
                }
                case 108: {
                    this.attrTypes[n2] = (OracleTypeADT)typeDescriptor.getPickler();
                    ((OracleTypeADT)this.attrTypes[n2]).setEmbeddedADT();
                    continue block25;
                }
                case 2: {
                    this.attrTypes[n2] = new OracleTypeNUMBER(2);
                    ((OracleTypeNUMBER)this.attrTypes[n2]).precision = (int)typeDescriptor.getPrecision();
                    ((OracleTypeNUMBER)this.attrTypes[n2]).scale = typeDescriptor.getScale();
                    continue block25;
                }
                case 7: {
                    this.attrTypes[n2] = new OracleTypeNUMBER(3);
                    ((OracleTypeNUMBER)this.attrTypes[n2]).precision = (int)typeDescriptor.getPrecision();
                    ((OracleTypeNUMBER)this.attrTypes[n2]).scale = typeDescriptor.getScale();
                    continue block25;
                }
                case 22: {
                    this.attrTypes[n2] = new OracleTypeNUMBER(8);
                    ((OracleTypeNUMBER)this.attrTypes[n2]).precision = (int)typeDescriptor.getPrecision();
                    ((OracleTypeNUMBER)this.attrTypes[n2]).scale = typeDescriptor.getScale();
                    continue block25;
                }
                case 4: {
                    this.attrTypes[n2] = new OracleTypeFLOAT();
                    ((OracleTypeFLOAT)this.attrTypes[n2]).precision = (int)typeDescriptor.getPrecision();
                    continue block25;
                }
                case 100: {
                    this.attrTypes[n2] = new OracleTypeBINARY_FLOAT();
                    continue block25;
                }
                case 101: {
                    this.attrTypes[n2] = new OracleTypeBINARY_DOUBLE();
                    continue block25;
                }
                case 29: {
                    this.attrTypes[n2] = new OracleTypeSINT32(false);
                    continue block25;
                }
                case 110: {
                    this.attrTypes[n2] = new OracleTypeREF(this, n2, this.connection);
                    continue block25;
                }
                case 114: {
                    this.attrTypes[n2] = new OracleTypeBFILE(this.connection);
                    continue block25;
                }
                case 95: {
                    this.attrTypes[n2] = new OracleTypeRAW();
                    continue block25;
                }
                case 112: {
                    this.attrTypes[n2] = new OracleTypeCLOB(this.connection);
                    continue block25;
                }
                case 113: {
                    this.attrTypes[n2] = new OracleTypeBLOB(this.connection);
                    continue block25;
                }
                case 187: {
                    this.attrTypes[n2] = new OracleTypeTIMESTAMP(this.connection);
                    ((OracleTypeTIMESTAMP)this.attrTypes[n2]).precision = (int)typeDescriptor.getPrecision();
                    continue block25;
                }
                case 188: {
                    this.attrTypes[n2] = new OracleTypeTIMESTAMPTZ(this.connection);
                    ((OracleTypeTIMESTAMPTZ)this.attrTypes[n2]).precision = (int)typeDescriptor.getPrecision();
                    continue block25;
                }
                case 232: {
                    this.attrTypes[n2] = new OracleTypeTIMESTAMPLTZ(this.connection);
                    ((OracleTypeTIMESTAMPLTZ)this.attrTypes[n2]).precision = (int)typeDescriptor.getPrecision();
                    continue block25;
                }
                case 189: {
                    this.attrTypes[n2] = new OracleTypeINTERVAL(this.connection);
                    ((OracleTypeINTERVAL)this.attrTypes[n2]).typeId = (byte)7;
                    ((OracleTypeINTERVAL)this.attrTypes[n2]).precision = (int)typeDescriptor.getPrecision();
                    ((OracleTypeINTERVAL)this.attrTypes[n2]).scale = typeDescriptor.getScale();
                    continue block25;
                }
                case 190: {
                    this.attrTypes[n2] = new OracleTypeINTERVAL(this.connection);
                    ((OracleTypeINTERVAL)this.attrTypes[n2]).typeId = (byte)10;
                    ((OracleTypeINTERVAL)this.attrTypes[n2]).precision = (int)typeDescriptor.getPrecision();
                    ((OracleTypeINTERVAL)this.attrTypes[n2]).scale = typeDescriptor.getScale();
                    continue block25;
                }
                case 122: {
                    this.attrTypes[n2] = new OracleTypeCOLLECTION(this, n2, this.connection);
                    continue block25;
                }
                default: {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 48, "type: " + typeDescriptor.getInternalTypeCode()).fillInStackTrace();
                }
            }
        }
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof STRUCT) {
                return (STRUCT)object;
            }
            if (object instanceof SQLData || object instanceof ObjectData) {
                return STRUCT.toSTRUCT(object, oracleConnection);
            }
            if (object instanceof Object[]) {
                StructDescriptor structDescriptor = this.createStructDescriptor();
                STRUCT sTRUCT = this.createObjSTRUCT(structDescriptor, (Object[])object);
                return sTRUCT;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object).fillInStackTrace();
        }
        return null;
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n3 = (int)(n2 == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    datumArray[i2] = this.toDatum(objectArray[(int)l2 + i2 - 1], oracleConnection);
                }
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object).fillInStackTrace();
            }
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() throws SQLException {
        if ((this.getStatus() & 0x10) != 0) {
            return 2008;
        }
        return 2002;
    }

    public OracleType[] getAttrTypes() throws SQLException {
        if (this.attrTypes == null) {
            this.init(this.connection);
        }
        return this.attrTypes;
    }

    @Override
    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        if (oracleType == null) {
            return false;
        }
        if (!oracleType.isObjectType()) {
            return false;
        }
        StructDescriptor structDescriptor = (StructDescriptor)oracleType.getTypeDescriptor();
        return this.descriptor.isInHierarchyOf(structDescriptor.getName());
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        if (structDescriptor == null) {
            return false;
        }
        return this.descriptor.isInHierarchyOf(structDescriptor.getName());
    }

    @Override
    public boolean isObjectType() {
        return true;
    }

    @Override
    public TypeDescriptor getTypeDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(OracleConnection oracleConnection) throws SQLException {
        OracleConnection oracleConnection2 = oracleConnection;
        synchronized (oracleConnection2) {
            byte[] byArray = this.initMetadata(oracleConnection);
            this.init(byArray, oracleConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(byte[] byArray, OracleConnection oracleConnection) throws SQLException {
        OracleConnection oracleConnection2 = oracleConnection;
        synchronized (oracleConnection2) {
            this.statusBits = 1;
            this.connection = oracleConnection;
            if (byArray != null) {
                this.parseTDS(byArray, 0L);
            }
            this.setStatusBits(256);
        }
    }

    public byte[] initMetadata(OracleConnection oracleConnection) throws SQLException {
        short s2 = oracleConnection.getVersionNumber();
        byte[] byArray = null;
        byArray = s2 >= 12000 ? this.initMetadata12(oracleConnection) : this.initMetadata11_2(oracleConnection);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] initMetadata12(OracleConnection oracleConnection) throws SQLException {
        OracleConnection oracleConnection2 = this.connection;
        synchronized (oracleConnection2) {
            byte[] byArray = null;
            if ((this.statusBits & 0x100) != 0) {
                return null;
            }
            if ((this.statusBits & 0x100) == 0) {
                Statement statement = null;
                this.connection.beginNonRequestCalls();
                try {
                    block34: {
                        Object object;
                        Object object2;
                        String string = "begin :1 := sys.dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7,:8,:9,:10); end;";
                        String string2 = this.typeNameByUser == null ? this.getFullName() : this.typeNameByUser;
                        statement = this.connection.prepareCall(string);
                        statement.registerOutParameter(1, 2);
                        statement.setString(2, string2);
                        statement.registerOutParameter(2, 12, 256);
                        statement.registerOutParameter(3, -3, 16);
                        statement.registerOutParameter(4, 4);
                        statement.registerOutParameter(5, -4);
                        statement.registerOutParameter(6, 12, 5);
                        statement.registerOutParameter(7, 12, 256);
                        statement.registerOutParameter(8, 12, 256);
                        statement.registerOutParameter(9, -10);
                        statement.registerOutParameter(10, -10);
                        statement.execute();
                        boolean bl = false;
                        int n2 = statement.getInt(1);
                        if (n2 != 0) {
                            if (n2 != 24331) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 74, this.typeNameByUser).fillInStackTrace();
                            }
                            if (n2 == 24331) {
                                bl = true;
                                statement.registerOutParameter(5, 2004);
                                statement.execute();
                                n2 = statement.getInt(1);
                                if (n2 != 0) {
                                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 74, this.typeNameByUser).fillInStackTrace();
                                }
                            }
                        }
                        this.toid = statement.getBytes(3);
                        this.typeVersion = NUMBER.toInt(statement.getBytes(4));
                        if (!bl) {
                            byArray = statement.getBytes(5);
                        } else {
                            try {
                                object2 = ((OracleCallableStatement)statement).getBlob(5);
                                object = object2.getBinaryStream();
                                byArray = new byte[(int)object2.length()];
                                ((InputStream)object).read(byArray);
                                ((InputStream)object).close();
                                ((BLOB)object2).freeTemporary();
                            }
                            catch (IOException iOException) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
                            }
                        }
                        this.metaDataInitialized = true;
                        this.isInstanciable = "YES".equalsIgnoreCase(statement.getString(6));
                        object = statement.getString(8);
                        if (object != null) {
                            object = statement.getString(7) + (String)object;
                        }
                        object2 = null;
                        ResultSet resultSet = null;
                        try {
                            ArrayList<String> arrayList;
                            object2 = (ResultSet)statement.getObject(9);
                            if (object2 != null && object2.next()) {
                                if (object2.getInt(1) == 1) {
                                    Object[] objectArray;
                                    arrayList = new ArrayList<String>(5);
                                    ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>(5);
                                    do {
                                        arrayList.add(object2.getString(2));
                                        objectArray = object2.getString(5);
                                        String string3 = object2.getString(6);
                                        Object[] objectArray2 = "";
                                        if (objectArray != null) {
                                            objectArray2 = (String)objectArray2 + (String)objectArray + '.';
                                        }
                                        if (string3 != null) {
                                            objectArray2 = (String)objectArray2 + string3 + '.';
                                        }
                                        objectArray2 = (String)objectArray2 + object2.getString(4);
                                        arrayList2.add(objectArray2);
                                    } while (object2.next());
                                    objectArray = arrayList.toArray();
                                    this.attrNames = new String[arrayList.size()];
                                    int n3 = 0;
                                    for (Object object3 : objectArray) {
                                        this.attrNames[n3++] = (String)object3;
                                    }
                                    objectArray = arrayList2.toArray();
                                    this.attrTypeNames = new String[arrayList2.size()];
                                    n3 = 0;
                                    for (Object object3 : objectArray) {
                                        this.attrTypeNames[n3++] = (String)object3;
                                    }
                                } else {
                                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown image format").fillInStackTrace();
                                }
                            }
                            object2.close();
                            object2 = null;
                            resultSet = (ResultSet)statement.getObject(10);
                            if (resultSet == null || !resultSet.next()) break block34;
                            if (resultSet.getInt(1) == 1) {
                                arrayList = new ArrayList(5);
                                do {
                                    arrayList.add(resultSet.getString(2) + "." + resultSet.getString(3));
                                } while (resultSet.next());
                                this.subTypeNames = new String[arrayList.size()];
                                for (int i2 = 0; i2 < this.subTypeNames.length; ++i2) {
                                    this.subTypeNames[i2] = (String)arrayList.get(i2);
                                }
                                break block34;
                            }
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown image format").fillInStackTrace();
                        }
                        finally {
                            if (object2 != null) {
                                object2.close();
                            }
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                    }
                    this.flattenedAttrNum = Util.getUnsignedByte(byArray[8]) * 256 + Util.getUnsignedByte(byArray[9]);
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                    this.connection.endNonRequestCalls();
                }
            }
            this.setStatusBits(256);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] initMetadata11_2(OracleConnection oracleConnection) throws SQLException {
        OracleConnection oracleConnection2 = this.connection;
        synchronized (oracleConnection2) {
            byte[] byArray = null;
            if ((this.statusBits & 0x100) != 0) {
                return null;
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            if ((this.statusBits & 0x100) == 0) {
                Statement statement = null;
                this.connection.beginNonRequestCalls();
                try {
                    if (this.tdoCState == 0L) {
                        this.tdoCState = this.connection.getTdoCState(this.sqlName.getSchema(), this.sqlName.getSimpleName());
                    }
                    String string = "begin :1 := sys.dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7); end;";
                    boolean bl = false;
                    statement = this.connection.prepareCall(string);
                    statement.registerOutParameter(1, 2);
                    statement.registerOutParameter(4, -3, 16);
                    statement.registerOutParameter(5, 4);
                    statement.registerOutParameter(6, -4);
                    statement.registerOutParameter(7, -4);
                    String string2 = this.sqlName.getSchema();
                    statement.setString(2, this.sqlName.getSchema());
                    statement.setString(3, this.sqlName.getSimpleName());
                    statement.execute();
                    int n2 = statement.getInt(1);
                    if (n2 != 0) {
                        if (n2 != 24331) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 74, this.sqlName.toString()).fillInStackTrace();
                        }
                        if (n2 == 24331) {
                            bl = true;
                            statement.registerOutParameter(6, 2004);
                            statement.execute();
                            n2 = statement.getInt(1);
                            if (n2 != 0) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 74, this.sqlName.toString()).fillInStackTrace();
                            }
                        }
                    }
                    this.toid = statement.getBytes(4);
                    this.typeVersion = NUMBER.toInt(statement.getBytes(5));
                    if (!bl) {
                        byArray = statement.getBytes(6);
                    } else {
                        try {
                            Blob blob = ((OracleCallableStatement)statement).getBlob(6);
                            InputStream inputStream = blob.getBinaryStream();
                            byArray = new byte[(int)blob.length()];
                            inputStream.read(byArray);
                            inputStream.close();
                            ((BLOB)blob).freeTemporary();
                        }
                        catch (IOException iOException) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
                        }
                    }
                    this.metaDataInitialized = true;
                    this.flattenedAttrNum = Util.getUnsignedByte(byArray[8]) * 256 + Util.getUnsignedByte(byArray[9]);
                    statement.getBytes(7);
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                    this.connection.endNonRequestCalls();
                }
            }
            this.setStatusBits(256);
            return byArray;
        }
    }

    TDSReader parseTDS(byte[] byArray, long l2) throws SQLException {
        if (this.attrTypes != null) {
            return null;
        }
        TDSReader tDSReader = new TDSReader(byArray, l2);
        long l3 = tDSReader.readLong() + tDSReader.offset();
        tDSReader.checkNextByte((byte)38);
        this.tdsVersion = tDSReader.readByte();
        tDSReader.skipBytes(2);
        this.flattenedAttrNum = tDSReader.readUB2();
        if ((tDSReader.readByte() & 0xFF) == 255) {
            this.setStatusBits(128);
        }
        long l4 = tDSReader.offset();
        tDSReader.checkNextByte((byte)41);
        if (tDSReader.readUB2() != 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS").fillInStackTrace();
        }
        long l5 = tDSReader.readLong();
        this.parseTDSrec(tDSReader);
        if (this.tdsVersion >= 3) {
            tDSReader.skip_to(l4 + l5 + 2L);
            tDSReader.skipBytes(2 * this.flattenedAttrNum);
            byte by = tDSReader.readByte();
            if (tDSReader.isJavaObject(this.tdsVersion, by)) {
                this.setStatusBits(16);
            }
            if (tDSReader.isFinalType(this.tdsVersion, by)) {
                this.setStatusBits(32);
            }
            if (tDSReader.readByte() != 1) {
                this.setStatusBits(64);
            }
        } else {
            this.setStatusBits(32);
        }
        tDSReader.skip_to(l3);
        return tDSReader;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        Vector<OracleType> vector = new Vector<OracleType>(5);
        OracleType oracleType = null;
        this.idx = 1;
        while ((oracleType = this.getNextTypeObject(tDSReader)) != null) {
            vector.addElement(oracleType);
        }
        if (this.opcode == 42) {
            this.endOfAdt = true;
            this.applyTDSpatches(tDSReader);
        }
        this.attrTypes = new OracleType[vector.size()];
        vector.copyInto(this.attrTypes);
    }

    private void applyTDSpatches(TDSReader tDSReader) throws SQLException {
        TDSPatch tDSPatch = tDSReader.getNextPatch();
        while (tDSPatch != null) {
            tDSReader.moveToPatchPos(tDSPatch);
            int n2 = tDSPatch.getType();
            if (n2 == 0) {
                tDSReader.readByte();
                byte by = tDSPatch.getUptTypeCode();
                switch (by) {
                    case -6: {
                        tDSReader.readLong();
                    }
                    case -5: {
                        OracleNamedType oracleNamedType = tDSPatch.getOwner();
                        OracleTypeADT oracleTypeADT = null;
                        oracleTypeADT = oracleNamedType.hasName() ? new OracleTypeADT(oracleNamedType.getFullName(), (Connection)this.connection) : new OracleTypeADT(oracleNamedType.getParent(), oracleNamedType.getOrder(), (Connection)this.connection);
                        oracleTypeADT.setUptADT();
                        TDSReader tDSReader2 = oracleTypeADT.parseTDS(tDSReader.tds(), tDSReader.absoluteOffset());
                        tDSReader.skipBytes((int)tDSReader2.offset());
                        tDSPatch.apply(oracleTypeADT.cleanup());
                        break;
                    }
                    case 58: {
                        OracleNamedType oracleNamedType = tDSPatch.getOwner();
                        OracleTypeADT oracleTypeADT = null;
                        oracleTypeADT = oracleNamedType.hasName() ? new OracleTypeOPAQUE(oracleNamedType.getFullName(), this.connection) : new OracleTypeOPAQUE(oracleNamedType.getParent(), oracleNamedType.getOrder(), this.connection);
                        ((OracleTypeOPAQUE)oracleTypeADT).parseTDSrec(tDSReader);
                        tDSPatch.apply(oracleTypeADT);
                        break;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
                    }
                }
            } else if (n2 == 1) {
                OracleType oracleType = this.getNextTypeObject(tDSReader);
                tDSPatch.apply(oracleType, this.opcode);
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS").fillInStackTrace();
            }
            tDSPatch = tDSReader.getNextPatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleNamedType cleanup() {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.attrTypes.length == 1 && this.attrTypes[0] instanceof OracleTypeCOLLECTION) {
                OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.attrTypes[0];
                oracleTypeCOLLECTION.copy_properties(this);
                return oracleTypeCOLLECTION;
            }
            if (this.attrTypes.length == 1 && (this.statusBits & 0x80) != 0 && this.attrTypes[0] instanceof OracleTypeUPT && ((OracleTypeUPT)this.attrTypes[0]).realType instanceof OracleTypeOPAQUE) {
                OracleTypeOPAQUE oracleTypeOPAQUE = (OracleTypeOPAQUE)((OracleTypeUPT)this.attrTypes[0]).realType;
                oracleTypeOPAQUE.copy_properties(this);
                return oracleTypeOPAQUE;
            }
            return this;
        }
    }

    void copy_properties(OracleTypeADT oracleTypeADT) {
        this.sqlName = oracleTypeADT.sqlName;
        this.typeNameByUser = oracleTypeADT.typeNameByUser;
        this.parent = oracleTypeADT.parent;
        this.idx = oracleTypeADT.idx;
        this.connection = oracleTypeADT.connection;
        this.toid = oracleTypeADT.toid;
        this.tdsVersion = oracleTypeADT.tdsVersion;
        this.typeVersion = oracleTypeADT.typeVersion;
        this.tdoCState = oracleTypeADT.tdoCState;
        this.endOfAdt = oracleTypeADT.endOfAdt;
        this.attrTypeNames = oracleTypeADT.attrTypeNames;
        if (this.attrNames != null && oracleTypeADT.attrTypeNames == null) {
            this.attrNames = oracleTypeADT.attrNames;
        }
    }

    OracleType getNextTypeObject(TDSReader tDSReader) throws SQLException {
        while (true) {
            this.opcode = tDSReader.readByte();
            if (this.opcode == 43) continue;
            if (this.opcode != 44) break;
            byte by = tDSReader.readByte();
            if (!tDSReader.isJavaObject(3, by)) continue;
            this.setStatusBits(16);
        }
        switch (this.opcode) {
            case 40: 
            case 42: {
                return null;
            }
            case 2: {
                OracleTypeDATE oracleTypeDATE = new OracleTypeDATE();
                oracleTypeDATE.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeDATE;
            }
            case 7: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.connection, 12);
                oracleTypeCHAR.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeCHAR;
            }
            case 1: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.connection, 1);
                oracleTypeCHAR.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeCHAR;
            }
            case 39: {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(this, this.idx, (Connection)this.connection);
                oracleTypeADT.setEmbeddedADT();
                oracleTypeADT.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeADT;
            }
            case 6: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER(2);
                oracleTypeNUMBER.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 3: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER(3);
                oracleTypeNUMBER.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 4: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER(8);
                oracleTypeNUMBER.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 5: {
                OracleTypeFLOAT oracleTypeFLOAT = new OracleTypeFLOAT();
                oracleTypeFLOAT.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeFLOAT;
            }
            case 37: {
                OracleTypeBINARY_FLOAT oracleTypeBINARY_FLOAT = new OracleTypeBINARY_FLOAT();
                oracleTypeBINARY_FLOAT.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeBINARY_FLOAT;
            }
            case 45: {
                OracleTypeBINARY_DOUBLE oracleTypeBINARY_DOUBLE = new OracleTypeBINARY_DOUBLE();
                oracleTypeBINARY_DOUBLE.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeBINARY_DOUBLE;
            }
            case 8: {
                OracleTypeSINT32 oracleTypeSINT32 = new OracleTypeSINT32(false);
                oracleTypeSINT32.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeSINT32;
            }
            case 9: {
                OracleTypeREF oracleTypeREF = new OracleTypeREF(this, this.idx, this.connection);
                oracleTypeREF.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeREF;
            }
            case 31: {
                OracleTypeBFILE oracleTypeBFILE = new OracleTypeBFILE(this.connection);
                oracleTypeBFILE.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeBFILE;
            }
            case 19: {
                OracleTypeRAW oracleTypeRAW = new OracleTypeRAW();
                oracleTypeRAW.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeRAW;
            }
            case 29: {
                OracleTypeCLOB oracleTypeCLOB = new OracleTypeCLOB(this.connection);
                oracleTypeCLOB.parseTDSrec(tDSReader);
                if (this.attrTypeNames != null && this.attrTypeNames.length > this.idx - 1) {
                    oracleTypeCLOB.form = "NCLOB".equals(this.attrTypeNames[this.idx - 1]) ? 2 : 1;
                } else if (this.sqlName != null && !this.endOfAdt) {
                    this.connection.getForm(this, oracleTypeCLOB, this.idx);
                }
                ++this.idx;
                return oracleTypeCLOB;
            }
            case 30: {
                OracleTypeBLOB oracleTypeBLOB = new OracleTypeBLOB(this.connection);
                oracleTypeBLOB.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeBLOB;
            }
            case 21: {
                OracleTypeTIMESTAMP oracleTypeTIMESTAMP = new OracleTypeTIMESTAMP(this.connection);
                oracleTypeTIMESTAMP.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeTIMESTAMP;
            }
            case 23: {
                OracleTypeTIMESTAMPTZ oracleTypeTIMESTAMPTZ = new OracleTypeTIMESTAMPTZ(this.connection);
                oracleTypeTIMESTAMPTZ.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeTIMESTAMPTZ;
            }
            case 33: {
                OracleTypeTIMESTAMPLTZ oracleTypeTIMESTAMPLTZ = new OracleTypeTIMESTAMPLTZ(this.connection);
                oracleTypeTIMESTAMPLTZ.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeTIMESTAMPLTZ;
            }
            case 24: {
                OracleTypeINTERVAL oracleTypeINTERVAL = new OracleTypeINTERVAL(this.connection);
                oracleTypeINTERVAL.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeINTERVAL;
            }
            case 28: {
                OracleTypeCOLLECTION oracleTypeCOLLECTION = new OracleTypeCOLLECTION(this, this.idx, this.connection);
                oracleTypeCOLLECTION.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeCOLLECTION;
            }
            case 27: {
                OracleTypeUPT oracleTypeUPT = new OracleTypeUPT(this, this.idx, this.connection);
                oracleTypeUPT.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeUPT;
            }
            case 16: {
                OracleTypeROWID oracleTypeROWID = new OracleTypeROWID();
                oracleTypeROWID.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeROWID;
            }
        }
        Object var2_26 = null;
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 48, "get_next_type: " + this.opcode).fillInStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] linearize(Datum datum) throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            return this.pickle81(datum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getConnection();
        Datum datum2 = null;
        if (oracleConnection == null) {
            datum2 = this._unlinearize(byArray, l2, datum, n2, map);
        } else {
            OracleConnection oracleConnection2 = oracleConnection;
            synchronized (oracleConnection2) {
                datum2 = this._unlinearize(byArray, l2, datum, n2, map);
            }
        }
        return datum2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum _unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (byArray == null) {
                return null;
            }
            PickleContext pickleContext = new PickleContext(byArray, l2);
            return (Datum)((Object)this.unpickle81(pickleContext, (OracleStruct)((Object)datum), 1, n2, map));
        }
    }

    protected OracleStruct unpickle81(PickleContext pickleContext, OracleStruct oracleStruct, int n2, int n3, Map map) throws SQLException {
        OracleStruct oracleStruct2 = oracleStruct;
        long l2 = pickleContext.offset();
        byte by = pickleContext.readByte();
        if (!PickleContext.is81format(by)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format").fillInStackTrace();
        }
        if (PickleContext.isCollectionImage_pctx(by)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is a collection image, expecting ADT").fillInStackTrace();
        }
        if (!pickleContext.readAndCheckVersion()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image version is not recognized").fillInStackTrace();
        }
        block0 : switch (n2) {
            case 9: {
                pickleContext.skipBytes(pickleContext.readLength(true) - 2);
                break;
            }
            case 3: {
                long l3 = pickleContext.readLength();
                oracleStruct2 = this.unpickle81Prefix(pickleContext, oracleStruct2, by);
                if (oracleStruct2 == null) {
                    StructDescriptor structDescriptor = this.createStructDescriptor();
                    oracleStruct2 = this.createByteSTRUCT(structDescriptor, null);
                }
                oracleStruct2.setImage(pickleContext.image(), l2, 0L);
                oracleStruct2.setImageLength(l3);
                pickleContext.skipTo(l2 + l3);
                break;
            }
            default: {
                OracleType[] oracleTypeArray;
                pickleContext.skipLength();
                oracleStruct2 = this.unpickle81Prefix(pickleContext, oracleStruct2, by);
                if (oracleStruct2 == null) {
                    oracleTypeArray = this.createStructDescriptor();
                    oracleStruct2 = this.createByteSTRUCT((StructDescriptor)oracleTypeArray, null);
                }
                oracleTypeArray = oracleStruct2.getDescriptor().getOracleTypeADT().getAttrTypes();
                switch (n3) {
                    case 1: {
                        Datum[] datumArray = new Datum[oracleTypeArray.length];
                        for (int i2 = 0; i2 < oracleTypeArray.length; ++i2) {
                            datumArray[i2] = (Datum)oracleTypeArray[i2].unpickle81rec(pickleContext, n3, map);
                        }
                        oracleStruct2.setDatumArray(datumArray);
                        break block0;
                    }
                    case 2: {
                        Object[] objectArray = new Object[oracleTypeArray.length];
                        for (int i3 = 0; i3 < oracleTypeArray.length; ++i3) {
                            objectArray[i3] = oracleTypeArray[i3].unpickle81rec(pickleContext, n3, map);
                        }
                        oracleStruct2.setObjArray(objectArray);
                        break block0;
                    }
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        return oracleStruct2;
    }

    protected OracleStruct unpickle81Prefix(PickleContext pickleContext, OracleStruct oracleStruct, byte by) throws SQLException {
        OracleStruct oracleStruct2 = oracleStruct;
        if (PickleContext.hasPrefix(by)) {
            boolean bl;
            long l2 = pickleContext.readLength() + pickleContext.absoluteOffset();
            byte by2 = pickleContext.readByte();
            byte by3 = (byte)(by2 & 0xC);
            boolean bl2 = by3 == 0;
            boolean bl3 = by3 == 4;
            boolean bl4 = by3 == 8;
            boolean bl5 = by3 == 12;
            boolean bl6 = bl = (by2 & 0x10) != 0;
            if (bl3) {
                byte[] byArray = pickleContext.readBytes(16);
                String string = OracleTypeADT.toid2typename(this.connection, byArray);
                StructDescriptor structDescriptor = (StructDescriptor)TypeDescriptor.getTypeDescriptor(string, this.connection);
                if (oracleStruct2 == null) {
                    oracleStruct2 = this.createByteSTRUCT(structDescriptor, null);
                } else {
                    oracleStruct2.setDescriptor(structDescriptor);
                }
            }
            if (bl) {
                pickleContext.readLength();
            }
            if (bl4 | bl5) {
                throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            }
            pickleContext.skipTo(l2);
        }
        return oracleStruct2;
    }

    @Override
    protected Object unpickle81rec(PickleContext pickleContext, int n2, Map map) throws SQLException {
        byte by = pickleContext.readByte();
        byte by2 = 0;
        if (PickleContext.isAtomicNull(by)) {
            return null;
        }
        if (PickleContext.isImmediatelyEmbeddedNull(by)) {
            by2 = pickleContext.readByte();
        }
        STRUCT sTRUCT = this.unpickle81datum(pickleContext, by, by2);
        return this.toObject(sTRUCT, n2, map);
    }

    @Override
    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n2, Map map) throws SQLException {
        STRUCT sTRUCT = this.unpickle81datum(pickleContext, by, (byte)0);
        return this.toObject(sTRUCT, n2, map);
    }

    private STRUCT unpickle81datum(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        int n2 = this.getNumAttrs();
        StructDescriptor structDescriptor = this.createStructDescriptor();
        STRUCT sTRUCT = this.createByteSTRUCT(structDescriptor, null);
        OracleType oracleType = this.getAttrTypeAt(0);
        Object object = null;
        object = PickleContext.isImmediatelyEmbeddedNull(by) && by2 == 1 ? null : (PickleContext.isImmediatelyEmbeddedNull(by) ? ((OracleTypeADT)oracleType).unpickle81datum(pickleContext, by, (byte)(by2 - 1)) : (PickleContext.isElementNull(by) ? (oracleType.getTypeCode() == 2002 || oracleType.getTypeCode() == 2008 ? oracleType.unpickle81datumAsNull(pickleContext, by, by2) : null) : oracleType.unpickle81rec(pickleContext, by, 1, null)));
        Datum[] datumArray = new Datum[n2];
        datumArray[0] = (Datum)object;
        for (int i2 = 1; i2 < n2; ++i2) {
            oracleType = this.getAttrTypeAt(i2);
            datumArray[i2] = (Datum)oracleType.unpickle81rec(pickleContext, 1, null);
        }
        sTRUCT.setDatumArray(datumArray);
        return sTRUCT;
    }

    @Override
    protected Datum unpickle81datumAsNull(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        int n2 = this.getNumAttrs();
        StructDescriptor structDescriptor = this.createStructDescriptor();
        STRUCT sTRUCT = this.createByteSTRUCT(structDescriptor, null);
        Datum[] datumArray = new Datum[n2];
        int n3 = 0;
        OracleType oracleType = this.getAttrTypeAt(n3);
        datumArray[n3++] = oracleType.getTypeCode() == 2002 || oracleType.getTypeCode() == 2008 ? oracleType.unpickle81datumAsNull(pickleContext, by, by2) : (Datum)null;
        while (n3 < n2) {
            oracleType = this.getAttrTypeAt(n3);
            datumArray[n3] = oracleType.getTypeCode() == 2002 || oracleType.getTypeCode() == 2008 ? (Datum)oracleType.unpickle81rec(pickleContext, 1, null) : (Datum)oracleType.unpickle81rec(pickleContext, 1, null);
            ++n3;
        }
        sTRUCT.setDatumArray(datumArray);
        return sTRUCT;
    }

    public byte[] pickle81(Datum datum) throws SQLException {
        PickleContext pickleContext = new PickleContext();
        pickleContext.initStream();
        this.pickle81(pickleContext, datum);
        byte[] byArray = pickleContext.stream2Bytes();
        datum.setShareBytes(byArray);
        return byArray;
    }

    @Override
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n2 = pickleContext.offset() + 2;
        int n3 = 0;
        n3 += pickleContext.writeImageHeader(this.shouldHavePrefix());
        n3 += this.pickle81Prefix(pickleContext);
        pickleContext.patchImageLen(n2, n3 += this.pickle81rec(pickleContext, datum, 0));
        return n3;
    }

    private boolean hasVersion() {
        return this.typeVersion > 1;
    }

    private boolean needsToid() {
        if (this.isTransient) {
            return false;
        }
        return (this.statusBits & 0x40) != 0 || (this.statusBits & 0x20) == 0 || this.hasVersion();
    }

    private boolean shouldHavePrefix() {
        if (this.isTransient) {
            return false;
        }
        return this.hasVersion() || this.needsToid();
    }

    protected int pickle81Prefix(PickleContext pickleContext) throws SQLException {
        if (this.shouldHavePrefix()) {
            int n2 = 0;
            int n3 = 1;
            int n4 = 1;
            if (this.needsToid()) {
                n4 += this.getTOID().length;
                n3 |= 4;
            }
            if (this.hasVersion()) {
                n3 |= 0x10;
                n4 = this.typeVersion > PickleContext.KOPI20_LN_MAXV ? (n4 += 5) : (n4 += 2);
            }
            n2 = pickleContext.writeLength(n4);
            n2 += pickleContext.writeData((byte)n3);
            if (this.needsToid()) {
                n2 += pickleContext.writeData(this.toid);
            }
            if (this.hasVersion()) {
                n2 = this.typeVersion > PickleContext.KOPI20_LN_MAXV ? (n2 += pickleContext.writeLength(this.typeVersion)) : (n2 += pickleContext.writeSB2(this.typeVersion));
            }
            return n2;
        }
        return 0;
    }

    private int pickle81rec(PickleContext pickleContext, Datum datum, int n2) throws SQLException {
        int n3 = 0;
        if (!this.metaDataInitialized) {
            this.copy_properties((OracleTypeADT)((OracleStruct)((Object)datum)).getDescriptor().getPickler());
        }
        Datum[] datumArray = ((OracleStruct)((Object)datum)).getOracleAttributes();
        int n4 = datumArray.length;
        int n5 = 0;
        OracleType oracleType = this.getAttrTypeAt(0);
        if (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT)) {
            n5 = 1;
            n3 = datumArray[0] == null ? (n2 > 0 ? (n3 += pickleContext.writeImmediatelyEmbeddedElementNull((byte)n2)) : (n3 += pickleContext.writeAtomicNull())) : (n3 += ((OracleTypeADT)oracleType).pickle81rec(pickleContext, datumArray[0], n2 + 1));
        }
        while (n5 < n4) {
            oracleType = this.getAttrTypeAt(n5);
            n3 = datumArray[n5] == null ? (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT) ? (n3 += pickleContext.writeAtomicNull()) : (n3 += pickleContext.writeElementNull())) : (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT) ? (n3 += ((OracleTypeADT)oracleType).pickle81rec(pickleContext, datumArray[n5], 1)) : (n3 += oracleType.pickle81(pickleContext, datumArray[n5])));
            ++n5;
        }
        return n3;
    }

    private Object toObject(STRUCT sTRUCT, int n2, Map map) throws SQLException {
        switch (n2) {
            case 1: {
                return sTRUCT;
            }
            case 2: {
                if (sTRUCT == null) break;
                return sTRUCT.toJdbc(map);
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        return null;
    }

    public String getAttributeType(int n2) throws SQLException {
        return this.getAttributeType(n2, true);
    }

    public String getAttributeType(int n2, boolean bl) throws SQLException {
        if (bl) {
            if (this.sqlName == null) {
                this.getFullName();
            }
            if (this.attrNames == null) {
                this.initADTAttrNames();
            }
        }
        if (n2 < 1 || this.attrTypeNames != null && n2 > this.attrTypeNames.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid index").fillInStackTrace();
        }
        if (this.attrTypeNames != null) {
            return this.attrTypeNames[n2 - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeName(int n2) throws SQLException {
        if (this.attrNames == null) {
            this.initADTAttrNames();
        }
        String string = null;
        if (this.attrNames != null) {
            OracleConnection oracleConnection = this.connection;
            synchronized (oracleConnection) {
                if (n2 < 1 || n2 > this.attrNames.length) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid index").fillInStackTrace();
                }
            }
            string = this.attrNames[n2 - 1];
        }
        return string;
    }

    public String getAttributeName(int n2, boolean bl) throws SQLException {
        if (bl && this.connection != null) {
            return this.getAttributeName(n2);
        }
        if (n2 < 1 || this.attrNames != null && n2 > this.attrNames.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid index").fillInStackTrace();
        }
        if (this.attrNames != null) {
            return this.attrNames[n2 - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADTAttrNames() throws SQLException {
        if (this.connection == null) {
            return;
        }
        if (this.sqlName == null) {
            this.getFullName();
        }
        if (this.toid != null) {
            this.initADTAttrNamesUsingTOID();
            return;
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            Statement statement = null;
            Statement statement2 = null;
            ResultSet resultSet = null;
            String[] stringArray = new String[this.attrTypes.length];
            String[] stringArray2 = new String[this.attrTypes.length];
            int n2 = 0;
            int n3 = 0;
            if (this.attrNames == null) {
                this.connection.beginNonRequestCalls();
                try {
                    int n4 = n2 = this.sqlName.getSchema().equals(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 7;
                    while (n2 != 11) {
                        switch (n2) {
                            case 0: {
                                statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                                statement2.setString(1, this.sqlName.getSimpleName());
                                statement2.setFetchSize(this.idx);
                                resultSet = statement2.executeQuery();
                                n2 = 5;
                                break;
                            }
                            case 1: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    n2 = 2;
                                }
                            }
                            case 2: {
                                statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                                statement2.setString(1, this.sqlName.getSimpleName());
                                statement2.setString(2, this.sqlName.getSimpleName());
                                statement2.setFetchSize(this.idx);
                                resultSet = statement2.executeQuery();
                                n2 = 3;
                                break;
                            }
                            case 3: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    n2 = 4;
                                }
                            }
                            case 4: {
                                statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                                statement2.setString(1, this.sqlName.getSimpleName());
                                statement2.setString(2, this.sqlName.getSimpleName());
                                statement2.setFetchSize(this.idx);
                                resultSet = statement2.executeQuery();
                                n2 = 8;
                                break;
                            }
                            case 5: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    n2 = 6;
                                }
                            }
                            case 6: {
                                statement = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + sqlString[n2]);
                                statement.setString(1, this.sqlName.getSimpleName());
                                statement.setString(3, this.sqlName.getSimpleName());
                                statement.registerOutParameter(2, -10);
                                statement.execute();
                                resultSet = ((OracleCallableStatement)statement).getCursor(2);
                                resultSet.setFetchSize(1);
                                n2 = 1;
                                break;
                            }
                            case 7: {
                                statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                                statement2.setString(1, this.sqlName.getSchema());
                                statement2.setString(2, this.sqlName.getSimpleName());
                                statement2.setFetchSize(this.idx);
                                resultSet = statement2.executeQuery();
                                n2 = 8;
                                break;
                            }
                            case 8: {
                                statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                                statement2.setString(1, this.sqlName.getSimpleName());
                                statement2.setString(2, this.sqlName.getSimpleName());
                                statement2.setFetchSize(this.idx);
                                resultSet = statement2.executeQuery();
                                n2 = 9;
                                break;
                            }
                            case 9: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    n2 = 10;
                                }
                            }
                            case 10: {
                                statement = this.connection.prepareCall(this.getSqlHint() + sqlString[n2]);
                                statement.setString(1, this.sqlName.getSimpleName());
                                statement.registerOutParameter(2, -10);
                                statement.execute();
                                resultSet = ((OracleCallableStatement)statement).getCursor(2);
                                n2 = 11;
                            }
                        }
                        try {
                            n3 = 0;
                            while (n3 < this.attrTypes.length && resultSet.next()) {
                                if (resultSet.getInt(1) != n3 + 1) {
                                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "inconsistent ADT attribute").fillInStackTrace();
                                }
                                stringArray[n3] = resultSet.getString(2);
                                String string = resultSet.getString(4);
                                stringArray2[n3] = "";
                                if (string != null) {
                                    stringArray2[n3] = string + ".";
                                }
                                int n5 = n3++;
                                stringArray2[n5] = stringArray2[n5] + resultSet.getString(3);
                            }
                            if (n3 != 0) {
                                this.attrTypeNames = stringArray2;
                                this.attrNames = stringArray;
                                n2 = 11;
                                continue;
                            }
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (statement2 != null) {
                                statement2.close();
                            }
                            if (statement == null) continue;
                            statement.close();
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (statement2 != null) {
                                statement2.close();
                            }
                            if (statement == null) continue;
                            statement.close();
                        }
                    }
                }
                finally {
                    this.connection.endNonRequestCalls();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADTAttrNamesUsingTOID() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            Statement statement = null;
            Statement statement2 = null;
            ResultSet resultSet = null;
            String[] stringArray = new String[this.attrTypes.length];
            String[] stringArray2 = new String[this.attrTypes.length];
            int n2 = 0;
            int n3 = 0;
            if (this.attrNames == null) {
                this.connection.beginNonRequestCalls();
                try {
                    int n4 = n2 = this.sqlName.getSchema().equals(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 1;
                    while (n2 != 11) {
                        switch (n2) {
                            case 0: {
                                statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlStringTOID[n2]);
                                statement2.setBytes(1, this.toid);
                                statement2.setFetchSize(this.idx);
                                resultSet = statement2.executeQuery();
                                n2 = 1;
                                break;
                            }
                            case 1: {
                                statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlStringTOID[n2]);
                                statement2.setBytes(1, this.toid);
                                statement2.setFetchSize(this.idx);
                                resultSet = statement2.executeQuery();
                                n2 = 11;
                            }
                        }
                        try {
                            n3 = 0;
                            while (n3 < this.attrTypes.length && resultSet.next()) {
                                if (resultSet.getInt(1) != n3 + 1 && n2 == 1) {
                                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "inconsistent ADT attribute").fillInStackTrace();
                                }
                                stringArray[n3] = resultSet.getString(2);
                                String string = resultSet.getString(4);
                                stringArray2[n3] = "";
                                if (string != null) {
                                    stringArray2[n3] = string + ".";
                                }
                                int n5 = n3++;
                                stringArray2[n5] = stringArray2[n5] + resultSet.getString(3);
                            }
                            if (n3 != 0) {
                                this.attrTypeNames = stringArray2;
                                this.attrNames = stringArray;
                                n2 = 11;
                                continue;
                            }
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (statement2 == null) continue;
                            statement2.close();
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (statement2 != null) {
                                statement2.close();
                            }
                            if (statement == null) continue;
                            statement.close();
                        }
                    }
                }
                finally {
                    this.connection.endNonRequestCalls();
                }
            }
        }
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        StructDescriptor structDescriptor = (StructDescriptor)this.descriptor;
        if (this.typeNameByUser == null && this.parent != null && this.parent.getTypeCode() == 2003) {
            this.typeNameByUser = this.parent.getAttributeType(1);
        }
        if (structDescriptor == null) {
            structDescriptor = new StructDescriptor(this, (Connection)this.connection);
        }
        return structDescriptor;
    }

    STRUCT createObjSTRUCT(StructDescriptor structDescriptor, Object[] objectArray) throws SQLException {
        if ((this.statusBits & 0x10) != 0) {
            return new JAVA_STRUCT(structDescriptor, (Connection)this.connection, objectArray);
        }
        return new STRUCT(structDescriptor, (Connection)this.connection, objectArray);
    }

    STRUCT createByteSTRUCT(StructDescriptor structDescriptor, byte[] byArray) throws SQLException {
        if ((this.statusBits & 0x10) != 0) {
            return new JAVA_STRUCT(structDescriptor, byArray, this.connection);
        }
        return new STRUCT(structDescriptor, byArray, this.connection);
    }

    public static String getSubtypeName(Connection connection, byte[] byArray, long l2) throws SQLException {
        byte by;
        PickleContext pickleContext;
        block6: {
            block5: {
                pickleContext = new PickleContext(byArray, l2);
                by = pickleContext.readByte();
                if (!PickleContext.is81format(by)) break block5;
                if (PickleContext.isCollectionImage_pctx(by)) break block5;
                if (PickleContext.hasPrefix(by)) break block6;
            }
            return null;
        }
        if (!pickleContext.readAndCheckVersion()) {
            throw (SQLException)DatabaseError.createSqlException(1, "Image version is not recognized").fillInStackTrace();
        }
        pickleContext.skipLength();
        pickleContext.skipLength();
        by = pickleContext.readByte();
        if ((by & 4) != 0) {
            byte[] byArray2 = pickleContext.readBytes(16);
            return OracleTypeADT.toid2typename(connection, byArray2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toid2typename(Connection connection, byte[] byArray) throws SQLException {
        String string;
        block7: {
            string = (String)((OracleConnection)connection).getDescriptor(byArray);
            if (string == null) {
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                ((OracleConnection)connection).beginNonRequestCalls();
                try {
                    preparedStatement = connection.prepareStatement("select owner, type_name from all_types where type_oid = :1");
                    preparedStatement.setBytes(1, byArray);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string = resultSet.getString(1) + "." + resultSet.getString(2);
                        ((OracleConnection)connection).putDescriptor(byArray, (Object)string);
                        break block7;
                    }
                    throw (SQLException)DatabaseError.createSqlException(1, "Invalid type oid").fillInStackTrace();
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    ((OracleConnection)connection).endNonRequestCalls();
                }
            }
        }
        return string;
    }

    public int getTdsVersion() {
        return this.tdsVersion;
    }

    public void printDebug() {
    }

    private String debugText() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("OracleTypeADT = " + this);
        printWriter.println("sqlName = " + this.sqlName);
        printWriter.println("OracleType[] : ");
        if (this.attrTypes != null) {
            for (int i2 = 0; i2 < this.attrTypes.length; ++i2) {
                printWriter.println("[" + i2 + "] = " + this.attrTypes[i2]);
            }
        } else {
            printWriter.println("null");
        }
        printWriter.println("toid : ");
        if (this.toid != null) {
            this.printUnsignedByteArray(this.toid, printWriter);
        } else {
            printWriter.println("null");
        }
        printWriter.println("tds version : " + this.tdsVersion);
        printWriter.println("type version : " + this.typeVersion);
        printWriter.println("type version : " + this.typeVersion);
        printWriter.println("opcode : " + this.opcode);
        printWriter.println("tdoCState : " + this.tdoCState);
        return stringWriter.getBuffer().substring(0);
    }

    public byte[] getTOID() {
        try {
            if (this.toid == null) {
                this.initMetadata(this.connection);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.toid;
    }

    public int getImageFormatVersion() {
        return PickleContext.KOPI20_VERSION;
    }

    @Override
    public int getTypeVersion() {
        try {
            if (this.typeVersion == -1) {
                this.initMetadata(this.connection);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.typeVersion;
    }

    public int getCharSet() {
        return this.charSetId;
    }

    public int getCharSetForm() {
        return this.charSetForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTdoCState() {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            try {
                if (this.tdoCState == 0L) {
                    if (this.connection.getVersionNumber() >= 12000 && this.typeNameByUser != null) {
                        this.tdoCState = this.connection.getTdoCState(this.typeNameByUser);
                    } else {
                        this.getFullName();
                        this.tdoCState = this.connection.getTdoCState(this.sqlName.getSchema(), this.sqlName.getSimpleName());
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return this.tdoCState;
        }
    }

    public long getFIXED_DATA_SIZE() {
        try {
            return this.getFixedDataSize();
        }
        catch (SQLException sQLException) {
            return 0L;
        }
    }

    public long getFixedDataSize() throws SQLException {
        return this.fixedDataSize;
    }

    public int getAlignmentReq() throws SQLException {
        return this.alignmentRequirement;
    }

    public int getNumAttrs() throws SQLException {
        if (this.attrTypes == null && this.connection != null) {
            this.init(this.connection);
        }
        return this.attrTypes.length;
    }

    public OracleType getAttrTypeAt(int n2) throws SQLException {
        if (this.attrTypes == null && this.connection != null) {
            this.init(this.connection);
        }
        return this.attrTypes[n2];
    }

    public boolean isEmbeddedADT() throws SQLException {
        return (this.statusBits & 2) != 0;
    }

    public boolean isUptADT() throws SQLException {
        return (this.statusBits & 4) != 0;
    }

    public boolean isTopADT() throws SQLException {
        return (this.statusBits & 1) != 0;
    }

    public void setStatus(int n2) throws SQLException {
        this.statusBits = n2;
    }

    void setEmbeddedADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 2);
    }

    void setUptADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 4);
    }

    public boolean isSubType() throws SQLException {
        return (this.statusBits & 0x40) != 0;
    }

    public boolean isFinalType() throws SQLException {
        return (this.statusBits & 0x20) != 0 | (this.statusBits & 2) != 0;
    }

    public boolean isJavaObject() throws SQLException {
        return (this.statusBits & 0x10) != 0;
    }

    public int getStatus() throws SQLException {
        if ((this.statusBits & 1) != 0 && (this.statusBits & 0x100) == 0) {
            this.init(this.connection);
        }
        return this.statusBits;
    }

    public static OracleTypeADT shallowClone(OracleTypeADT oracleTypeADT) throws SQLException {
        OracleTypeADT oracleTypeADT2 = new OracleTypeADT();
        OracleTypeADT.shallowCopy(oracleTypeADT, oracleTypeADT2);
        return oracleTypeADT2;
    }

    public static void shallowCopy(OracleTypeADT oracleTypeADT, OracleTypeADT oracleTypeADT2) throws SQLException {
        oracleTypeADT2.connection = oracleTypeADT.connection;
        oracleTypeADT2.sqlName = oracleTypeADT.sqlName;
        oracleTypeADT2.parent = oracleTypeADT.parent;
        oracleTypeADT2.idx = oracleTypeADT.idx;
        oracleTypeADT2.descriptor = oracleTypeADT.descriptor;
        oracleTypeADT2.statusBits = oracleTypeADT.statusBits;
        oracleTypeADT2.typeCode = oracleTypeADT.typeCode;
        oracleTypeADT2.dbTypeCode = oracleTypeADT.dbTypeCode;
        oracleTypeADT2.tdsVersion = oracleTypeADT.tdsVersion;
        oracleTypeADT2.typeVersion = oracleTypeADT.typeVersion;
        oracleTypeADT2.fixedDataSize = oracleTypeADT.fixedDataSize;
        oracleTypeADT2.alignmentRequirement = oracleTypeADT.alignmentRequirement;
        oracleTypeADT2.attrTypes = oracleTypeADT.attrTypes;
        oracleTypeADT2.sqlName = oracleTypeADT.sqlName;
        oracleTypeADT2.tdoCState = oracleTypeADT.tdoCState;
        oracleTypeADT2.toid = oracleTypeADT.toid;
        oracleTypeADT2.charSetId = oracleTypeADT.charSetId;
        oracleTypeADT2.charSetForm = oracleTypeADT.charSetForm;
        oracleTypeADT2.flattenedAttrNum = oracleTypeADT.flattenedAttrNum;
        oracleTypeADT2.statusBits = oracleTypeADT.statusBits;
        oracleTypeADT2.attrNames = oracleTypeADT.attrNames;
        oracleTypeADT2.attrTypeNames = oracleTypeADT.attrTypeNames;
        oracleTypeADT2.opcode = oracleTypeADT.opcode;
        oracleTypeADT2.idx = oracleTypeADT.idx;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.statusBits);
        objectOutputStream.writeInt(this.tdsVersion);
        objectOutputStream.writeInt(this.typeVersion);
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
        objectOutputStream.writeLong(this.fixedDataSize);
        objectOutputStream.writeInt(this.alignmentRequirement);
        objectOutputStream.writeObject(this.attrTypes);
        objectOutputStream.writeObject(this.attrNames);
        objectOutputStream.writeObject(this.attrTypeNames);
        objectOutputStream.writeLong(this.tdoCState);
        objectOutputStream.writeObject(this.toid);
        objectOutputStream.writeObject(null);
        objectOutputStream.writeInt(this.charSetId);
        objectOutputStream.writeInt(this.charSetForm);
        objectOutputStream.writeBoolean(true);
        objectOutputStream.writeInt(this.flattenedAttrNum);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.statusBits = objectInputStream.readInt();
        this.tdsVersion = objectInputStream.readInt();
        this.typeVersion = objectInputStream.readInt();
        objectInputStream.readObject();
        objectInputStream.readObject();
        objectInputStream.readLong();
        objectInputStream.readInt();
        this.attrTypes = (OracleType[])objectInputStream.readObject();
        this.attrNames = (String[])objectInputStream.readObject();
        this.attrTypeNames = (String[])objectInputStream.readObject();
        objectInputStream.readLong();
        this.toid = (byte[])objectInputStream.readObject();
        objectInputStream.readObject();
        this.charSetId = objectInputStream.readInt();
        this.charSetForm = objectInputStream.readInt();
        objectInputStream.readBoolean();
        this.flattenedAttrNum = objectInputStream.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        OracleConnection oracleConnection2 = oracleConnection;
        synchronized (oracleConnection2) {
            this.connection = oracleConnection;
            for (int i2 = 0; i2 < this.attrTypes.length; ++i2) {
                this.attrTypes[i2].setConnection(this.connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatusBits(int n2) {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            this.statusBits |= n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maskAndSetStatusBits(int n2, int n3) {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            this.statusBits &= n2;
            this.statusBits |= n3;
        }
    }

    private void printUnsignedByteArray(byte[] byArray, PrintWriter printWriter) {
        int n2;
        int n3 = byArray.length;
        int[] nArray = Util.toJavaUnsignedBytes(byArray);
        for (n2 = 0; n2 < n3; ++n2) {
            printWriter.print("0x" + Integer.toHexString(nArray[n2]) + " ");
        }
        printWriter.println();
        for (n2 = 0; n2 < n3; ++n2) {
            printWriter.print(nArray[n2] + " ");
        }
        printWriter.println();
    }

    @Override
    public void initChildNamesRecursively(Map map) throws SQLException {
        TypeTreeElement typeTreeElement = (TypeTreeElement)map.get(this.sqlName);
        if (this.attrTypes != null && this.attrTypes.length > 0) {
            for (int i2 = 0; i2 < this.attrTypes.length; ++i2) {
                OracleType oracleType = this.attrTypes[i2];
                oracleType.setNames(typeTreeElement.getChildSchemaName(i2 + 1), typeTreeElement.getChildTypeName(i2 + 1));
                oracleType.initChildNamesRecursively(map);
                oracleType.cacheDescriptor();
            }
        }
    }

    @Override
    public void cacheDescriptor() throws SQLException {
        this.descriptor = StructDescriptor.createDescriptor(this);
    }

    private void initMetaData1() throws SQLException {
        short s2 = this.connection.getVersionNumber();
        if (s2 >= 9000) {
            this.initMetaData1_9_0();
        } else {
            this.initMetaData1_pre_9_0();
        }
    }

    public Boolean isInstanciable() throws SQLException {
        if (this.isInstanciable == null) {
            this.initMetaData1();
        }
        return this.isInstanciable;
    }

    public String getSuperTypeName() throws SQLException {
        if (this.superTypeName == null) {
            this.initMetaData1();
        }
        return this.superTypeName;
    }

    public int getNumberOfLocalAttributes() throws SQLException {
        if (this.numberOfLocalAttributes == -1) {
            this.initMetaData1();
        }
        return this.numberOfLocalAttributes;
    }

    public String[] getSubtypeNames() throws SQLException {
        if (this.subTypeNames == null) {
            this.initMetaData1();
        }
        return this.subTypeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_9_0() throws SQLException {
        if (this.getTOID() != null) {
            this.initMetaData1_9_0UseToid();
            return;
        }
        int n2 = 0;
        if (this.sqlName == null) {
            this.getFullName();
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleTypeADT oracleTypeADT = this;
            synchronized (oracleTypeADT) {
                if (this.numberOfLocalAttributes == -1) {
                    Statement statement = null;
                    Statement statement2 = null;
                    ResultSet resultSet = null;
                    int n3 = -1;
                    this.connection.beginNonRequestCalls();
                    try {
                        block15: while (true) {
                            switch (n2) {
                                case 0: {
                                    statement = this.connection.prepareStatement(this.initMetaData1_9_0_SQL[n2]);
                                    statement.setString(1, this.sqlName.getSimpleName());
                                    statement.setString(2, this.sqlName.getSchema());
                                    statement.setFetchSize(1);
                                    resultSet = statement.executeQuery();
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    try {
                                        statement2 = (OracleCallableStatement)this.connection.prepareCall(this.initMetaData1_9_0_SQL[n2]);
                                        statement2.setString(1, this.sqlName.getSimpleName());
                                        statement2.registerOutParameter(2, -10);
                                        statement2.execute();
                                        resultSet = statement2.getCursor(2);
                                        resultSet.setFetchSize(1);
                                        break;
                                    }
                                    catch (SQLException sQLException) {
                                        if (sQLException.getErrorCode() == 1403) {
                                            if (n2 == 1) {
                                                statement2.close();
                                                ++n2;
                                                continue block15;
                                            }
                                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view").fillInStackTrace();
                                        }
                                        throw sQLException;
                                    }
                                }
                            }
                            if (resultSet.next()) {
                                this.isInstanciable = new Boolean(resultSet.getString(1).equals("YES"));
                                this.superTypeName = resultSet.getString(2) + "." + resultSet.getString(3);
                                n3 = resultSet.getInt(4);
                                break;
                            }
                            if (n2 == 2) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view").fillInStackTrace();
                            }
                            resultSet.close();
                            if (statement2 != null) {
                                statement2.close();
                            }
                            ++n2;
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (statement2 != null) {
                            statement2.close();
                        }
                        this.connection.endNonRequestCalls();
                    }
                    this.numberOfLocalAttributes = n3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_9_0UseToid() throws SQLException {
        block11: {
            String string = "SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES, type_name, owner FROM all_types t WHERE TYPE_OID = :1";
            String string2 = "SELECT owner, type_name FROM all_types WHERE supertype_name = :1 and supertype_owner = :2";
            PreparedStatement preparedStatement = null;
            Statement statement = null;
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            if (this.sqlName == null) {
                this.getFullName();
            }
            try {
                preparedStatement = this.connection.prepareStatement(string);
                preparedStatement.setBytes(1, this.getTOID());
                preparedStatement.setFetchSize(1);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    this.isInstanciable = new Boolean(resultSet.getString(1).equals("YES"));
                    this.superTypeName = resultSet.getString(2) + "." + resultSet.getString(3);
                    this.numberOfLocalAttributes = resultSet.getInt(4);
                    String string3 = resultSet.getString(5);
                    String string4 = resultSet.getString(6);
                    statement = this.connection.prepareStatement(string2);
                    statement.setString(1, string3);
                    statement.setString(2, string4);
                    resultSet2 = statement.executeQuery();
                    ArrayList<String> arrayList = new ArrayList<String>(5);
                    while (resultSet2.next()) {
                        arrayList.add(resultSet2.getString(1) + "." + resultSet2.getString(2));
                    }
                    this.subTypeNames = new String[arrayList.size()];
                    for (int i2 = 0; i2 < this.subTypeNames.length; ++i2) {
                        this.subTypeNames[i2] = (String)arrayList.get(i2);
                    }
                    break block11;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view").fillInStackTrace();
            }
            finally {
                if (resultSet2 != null) {
                    resultSet2.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                this.connection.endNonRequestCalls();
            }
        }
    }

    private synchronized void initMetaData1_pre_9_0() throws SQLException {
        this.isInstanciable = new Boolean(true);
        this.superTypeName = "";
        this.numberOfLocalAttributes = 0;
    }

    private void initMetaData2() throws SQLException {
        short s2 = this.connection.getVersionNumber();
        if (s2 >= 9000) {
            this.initMetaData2_9_0();
        } else {
            this.initMetaData2_pre_9_0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData2_9_0() throws SQLException {
        if (this.getTOID() != null) {
            this.initMetaData1_9_0UseToid();
            return;
        }
        if (this.sqlName == null) {
            this.getFullName();
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleTypeADT oracleTypeADT = this;
            synchronized (oracleTypeADT) {
                if (this.subTypeNames == null) {
                    PreparedStatement preparedStatement = null;
                    ResultSet resultSet = null;
                    String[] stringArray = null;
                    this.connection.beginNonRequestCalls();
                    try {
                        preparedStatement = this.connection.prepareStatement("select owner, type_name from all_types where supertype_name = :1 and supertype_owner = :2");
                        preparedStatement.setString(1, this.sqlName.getSimpleName());
                        preparedStatement.setString(2, this.sqlName.getSchema());
                        resultSet = preparedStatement.executeQuery();
                        Vector<String> vector = new Vector<String>();
                        while (resultSet.next()) {
                            vector.addElement(resultSet.getString(1) + "." + resultSet.getString(2));
                        }
                        stringArray = new String[vector.size()];
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            stringArray[i2] = (String)vector.elementAt(i2);
                        }
                        vector.removeAllElements();
                        vector = null;
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        this.connection.endNonRequestCalls();
                    }
                    this.subTypeNames = stringArray;
                }
            }
        }
    }

    private void initMetaData2_pre_9_0() throws SQLException {
        this.subTypeNames = new String[0];
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.print("<OracleTypeADT sqlName=\"" + this.sqlName + "\" ");
        printWriter.print(" typecode=\"" + this.typeCode + "\"");
        if (this.tdsVersion != -9999) {
            printWriter.print(" tds_version=\"" + this.tdsVersion + "\"");
        }
        printWriter.println();
        for (n3 = 0; n3 < n2 + 4; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println(" is_embedded=\"" + this.isEmbeddedADT() + "\" is_top_level=\"" + this.isTopADT() + "\" is_upt=\"" + this.isUptADT() + "\" finalType=\"" + this.isFinalType() + "\" subtype=\"" + this.isSubType() + "\">");
        if (this.attrTypes != null && this.attrTypes.length > 0) {
            for (n3 = 0; n3 < n2 + 1; ++n3) {
                printWriter.print("  ");
            }
            printWriter.println("<attributes>");
            for (n3 = 0; n3 < this.attrTypes.length; ++n3) {
                int n4;
                for (n4 = 0; n4 < n2 + 2; ++n4) {
                    printWriter.print("  ");
                }
                printWriter.println("<attribute name=\"" + this.getAttributeName(n3 + 1, bl) + "\"  type=\"" + this.getAttributeType(n3 + 1, false) + "\" >");
                this.attrTypes[n3].printXML(printWriter, n2 + 3, bl);
                for (n4 = 0; n4 < n2 + 2; ++n4) {
                    printWriter.print("  ");
                }
                printWriter.println("</attribute> ");
            }
            for (n3 = 0; n3 < n2 + 1; ++n3) {
                printWriter.print("  ");
            }
            printWriter.println("</attributes>");
        }
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("</OracleTypeADT>");
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

