/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.DateAdjustment;
import org.ohdsi.circe.cohortdefinition.DrugEra;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class DrugEraSqlBuilder<T extends DrugEra>
extends CriteriaSqlBuilder<T> {
    private static final String DRUG_ERA_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/drugEra.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));
    private final List<String> DEFAULT_SELECT_COLUMNS = new ArrayList<String>(Arrays.asList("de.person_id", "de.drug_era_id", "de.drug_concept_id", "de.drug_exposure_count", "de.gap_days"));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return DRUG_ERA_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.drug_concept_id";
            }
            case ERA_OCCURRENCES: {
                return "C.drug_exposure_count";
            }
            case GAP_DAYS: {
                return "C.gap_days";
            }
            case DURATION: {
                return "DATEDIFF(d,C.start_date, C.end_date)";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Drug Era:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        String codesetClause = "";
        if (((DrugEra)criteria).codesetId != null) {
            codesetClause = String.format("where de.drug_concept_id in (SELECT concept_id from  #Codesets where codeset_id = %d)", ((DrugEra)criteria).codesetId);
        }
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)codesetClause);
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((DrugEra)criteria).first != null && ((DrugEra)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY de.person_id ORDER BY de.drug_era_start_date, de.drug_era_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveSelectClauses(T criteria) {
        ArrayList<String> selectCols = new ArrayList<String>(this.DEFAULT_SELECT_COLUMNS);
        if (((DrugEra)criteria).dateAdjustment != null) {
            selectCols.add(BuilderUtils.getDateAdjustmentExpression(((DrugEra)criteria).dateAdjustment, ((DrugEra)criteria).dateAdjustment.startWith == DateAdjustment.DateType.START_DATE ? "de.drug_era_start_date" : "de.drug_era_end_date", ((DrugEra)criteria).dateAdjustment.endWith == DateAdjustment.DateType.START_DATE ? "de.drug_era_start_date" : "de.drug_era_end_date"));
        } else {
            selectCols.add("de.drug_era_start_date as start_date, de.drug_era_end_date as end_date");
        }
        return selectCols;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((DrugEra)criteria).ageAtStart != null || ((DrugEra)criteria).ageAtEnd != null || ((DrugEra)criteria).gender != null && ((DrugEra)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        List<String> whereClauses = super.resolveWhereClauses(criteria);
        if (((DrugEra)criteria).eraStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.start_date", ((DrugEra)criteria).eraStartDate));
        }
        if (((DrugEra)criteria).eraEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.end_date", ((DrugEra)criteria).eraEndDate));
        }
        if (((DrugEra)criteria).occurrenceCount != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.drug_exposure_count", ((DrugEra)criteria).occurrenceCount));
        }
        if (((DrugEra)criteria).eraLength != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("DATEDIFF(d,C.start_date, C.end_date)", ((DrugEra)criteria).eraLength));
        }
        if (((DrugEra)criteria).gapDays != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.gap_days", ((DrugEra)criteria).eraLength));
        }
        if (((DrugEra)criteria).ageAtStart != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.start_date) - P.year_of_birth", ((DrugEra)criteria).ageAtStart));
        }
        if (((DrugEra)criteria).ageAtEnd != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.end_date) - P.year_of_birth", ((DrugEra)criteria).ageAtEnd));
        }
        if (((DrugEra)criteria).gender != null && ((DrugEra)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DrugEra)criteria).gender), (String)",")));
        }
        return whereClauses;
    }
}

