# This script was automatically generated by the shinymgr (vers. 1.0.0) R package's App Builder on 2023-05-31 11:36:23.380043.
# For more information, visit: https://code.usgs.gov/vtcfwru/shinymgr

library(ggplot2)
library(reactable)
library(stats)

jscode <- "
shinyjs.disableTab = function(name) {
var tab = $('.nav li a[data-value=' + name + ']');
tab.bind('click.tab', function(e) {
e.preventDefault();
return false;
});
tab.addClass('disabled');
}

shinyjs.enableTab = function(name) {
var tab = $('.nav li a[data-value=' + name + ']');
tab.unbind('click.tab');
tab.removeClass('disabled');
}
"

css <- "
.nav li a.disabled {
background-color: #bbb !important;
border-color: #ccc !important;
cursor: not-allowed !important;
}"


iris_explorer_ui <- function(id) {
  ns <- NS(id)
  tagList(
    fluidPage(
      shinyjs::useShinyjs(),
      shinyjs::extendShinyjs(text = jscode, functions = c('disableTab','enableTab')),
      shinyjs::inlineCSS(css),
      actionButton(
        ns("start"),
        "Start New Analysis",
        onclick = "var $btn=$(this); setTimeout(function(){$btn.remove();},0);"
      ),
      uiOutput(ns('appUI'))
    )
  )
}
iris_explorer_server <- function(id, userID, shinyMgrPath) {
  moduleServer(id, function(input, output, session) {
    ns <- session$ns
    observeEvent(input$start, {

      shinyjs::disable('start')

      output$appUI <- renderUI({
        tagList(
          tabsetPanel(
            id = ns("mainTabSet"),
            tabPanel(
              "Intro", 
              value = "tab1",
              iris_intro_ui(ns("mod1")),
              fluidRow(
                actionButton(ns('next_tab_1'), label = "Next")
              )
            ),
            tabPanel(
              "Cluster Iris Data", 
              value = "tab2",
              tags$br(),
              wellPanel(
                style = "background: skyblue",
                "Cluster data from the iris dataset by specifying the attributes and number of clusters."
              ),
              iris_cluster_ui(ns("mod2")),
              fluidRow(
                actionButton(ns('previous_tab_2'), label = "Previous"),
                actionButton(ns('next_tab_2'), label = "Next")
              )
            ),
            tabPanel(
              "Subset Rows", 
              value = "tab3",
              tags$br(),
              wellPanel(
                style = "background: skyblue",
                "Specify the number of rows to randomly select from the clustered iris data."
              ),
              subset_rows_ui(ns("mod3")),
              fluidRow(
                actionButton(ns('previous_tab_3'), label = "Previous"),
                actionButton(ns('next_tab_3'), label = "Next")
              )
            ),
            tabPanel(
              "Plot Column", 
              value = "tab4",
              tags$br(),
              wellPanel(
                style = "background: skyblue",
                "Select a column to view its distribution."
              ),
              single_column_plot_ui(ns("mod4")),
              fluidRow(
                actionButton(ns('previous_tab_4'), label = "Previous"),
                actionButton(ns('next_tab_4'), label = "Next")
              )
            ),
            tabPanel(
              "Save",
              value = "tab5",
              save_analysis_ui(ns("mod5")),
              tags$br(),
              tags$br(),
              fluidRow(
                actionButton(ns("previous_tab_5"), label = "Previous")
              )
            )
          ),
          tags$p(tags$i('App created with shinymgr'), style = "text-align:right")
        )
      })
      shinyjs::delay(50, {
        shinyjs::js$disableTab("tab2")
        shinyjs::js$disableTab("tab3")
        shinyjs::js$disableTab("tab4")
        shinyjs::js$disableTab("tab5")
      })
    })

    iris_intro_server("mod1")
    data1 <- iris_cluster_server("mod2")
    data2 <- subset_rows_server("mod3", dataset = data1$returndf)
    data3 <- single_column_plot_server("mod4", dataset = data2$subset_data)
    save_analysis_server("mod5",
      appName = "iris_explorer",
      moduleInput = input,
      returns = list(
        data1 = list(
          returndf = data1$returndf()
        ),
        data2 = list(
          subset_data = data2$subset_data()
        ),
        data3 = list(
          selectedCol = data3$selectedCol(),
          g = data3$g()
        )
      ),
      metadata = list(
        appDescription = "Cluster iris data, randomly subset some rows, and plot the distribution of a column",
        mod1 = list(
          dataset = "no returns",
          modName = "iris_intro",
          modDisplayName = "Iris Explorer introduction Page",
          modDescription = "This module is simply a page of text with instructions for the iris explorer module.",
          modArguments = "This module has no additional arguments",
          modReturns = "This module has no returns",
          modPackages = "This module has no package dependencies"
        ),
        mod2 = list(
          dataset = "data1",
          modName = "iris_cluster",
          modDisplayName = "Iris K-Means Clustering",
          modDescription = "Clusters iris data based on 2 attributes",
          modArguments = "This module has no additional arguments",
          modReturns = data.frame(
            name = c("returndf"),
            class = c("data.frame"),
            description = c("selected attributes and their assigned clusters")
          ),
          modPackages = data.frame(
            name = c("stats"),
            version = c("4.3.0")
          )
        ),
        mod3 = list(
          dataset = "data2",
          modName = "subset_rows",
          modDisplayName = "Subset Rows (random)",
          modDescription = "Randomly selects rows to create a subset of a dataframe",
          modArguments = data.frame(
            name = c("dataset"),
            class = c("data.frame"),
            description = c("dataframe to be subset")
          ),
          modReturns = data.frame(
            name = c("subset_data"),
            class = c("data.frame"),
            description = c("subset of original data")
          ),
          modPackages = data.frame(
            name = c("reactable"),
            version = c("0.3.0")
          )
        ),
        mod4 = list(
          dataset = "data3",
          modName = "single_column_plot",
          modDisplayName = "Plot Single Column",
          modDescription = "Uses qplot to plot a column in a dataset",
          modArguments = data.frame(
            name = c("dataset"),
            class = c("data.frame"),
            description = c("dataframe to be explored")
          ),
          modReturns = data.frame(
            name = c("selectedCol","g"),
            class = c("string","ggproto"),
            description = c("name of column selected","plot of column distribution")
          ),
          modPackages = data.frame(
            name = c("ggplot2"),
            version = c("3.4.1")
          )
        ),
        lockfile = list(R = list(Version = "4.4.0", Repositories = list(CRAN = "https://cran.rstudio.com/")), Packages = list(Matrix = list(Package = "Matrix", Version = "1.7-0", Source = "Repository", Repository = "CRAN", Requirements = c("R", "grDevices", "graphics", "grid", "lattice", "methods", "stats", "utils"), Hash = "1920b2f11133b12350024297d8a4ff4a"), gtable = list(Package = "gtable", Version = "0.3.5", Source = "Repository", Repository = "CRAN", Requirements = c("R", "cli", "glue", "grid", "lifecycle", "rlang"), Hash = "e18861963cbc65a27736e02b3cd3c4a0"), jsonlite = list(Package = "jsonlite", Version = "1.8.8", Source = "Repository", Repository = "CRAN", Requirements = "methods", Hash = "e1b9c55281c5adc4dd113652d9e26768"), highr = list(Package = "highr", Version = "0.10", Source = "Repository", Repository = "CRAN", Requirements = c("R", "xfun"), Hash = "06230136b2d2b9ba5805e1963fa6e890"), tinytex = list(Package = "tinytex", Version = "0.50.2", Source = "GitHub", RemoteType = "github", RemoteHost = "api.github.com", RemoteRepo = "tinytex", RemoteUsername = "rstudio", RemoteRef = "HEAD", RemoteSha = "ae0458c33fe26aa6d654af04eabe528f3d3579a0", Requirements = "xfun", Hash = "a3479ef5c5fa36b4d997350c78e37d0b"), jquerylib = list(Package = "jquerylib", Version = "0.1.4", Source = "Repository", Repository = "CRAN", Requirements = "htmltools", Hash = "5aab57a3bd297eee1c1d862735972182"), scales = list(Package = "scales", Version = "1.3.0", Source = "Repository", Repository = "CRAN", Requirements = c("R", "R6", "RColorBrewer", "cli", "farver", "glue", "labeling", "lifecycle", "munsell", "rlang", "viridisLite"), Hash = "c19df082ba346b0ffa6f833e92de34d1"), yaml = list(Package = "yaml", Version = "2.3.8", Source = "Repository", Repository = "CRAN", Hash = "29240487a071f535f5e5d5a323b7afbd"), fastmap = list(Package = "fastmap", Version = "1.1.1", Source = "Repository", Repository = "CRAN", Hash = "f7736a18de97dea803bde0a2daaafb27"), mime = list(Package = "mime", Version = "0.12", Source = "Repository", Repository = "CRAN", Requirements = "tools", Hash = "18e9c28c1d3ca1560ce30658b22ce104"), lattice = list(Package = "lattice", Version = "0.22-6", Source = "Repository", Repository = "CRAN", Requirements = c("R", "grDevices", "graphics", "grid", "stats", "utils"), Hash = "cc5ac1ba4c238c7ca9fa6a87ca11a7e2"), ggplot2 = list(Package = "ggplot2", Version = "3.5.1", Source = "Repository", Repository = "CRAN", Requirements = c("MASS", "R", "cli", "glue", "grDevices", "grid", "gtable", "isoband", "lifecycle", "mgcv", "rlang", "scales", "stats", "tibble", "vctrs", "withr"), Hash = "44c6a2f8202d5b7e878ea274b1092426"), R6 = list(Package = "R6", Version = "2.5.1", Source = "Repository", Repository = "CRAN", Requirements = "R", Hash = "470851b6d5d0ac559e9d01bb352b4021"), labeling = list(Package = "labeling", Version = "0.4.3", Source = "Repository", Repository = "CRAN", Requirements = c("graphics", "stats"), Hash = "b64ec208ac5bc1852b285f665d6368b3"), isoband = list(Package = "isoband", Version = "0.2.7", Source = "Repository", Repository = "CRAN", Requirements = c("grid", "utils"), Hash = "0080607b4a1a7b28979aecef976d8bc2"), knitr = list(Package = "knitr", Version = "1.46", Source = "Repository", Repository = "CRAN", Requirements = c("R", "evaluate", "highr", "methods", "tools", "xfun", "yaml"), Hash = "6e008ab1d696a5283c79765fa7b56b47"), htmlwidgets = list(Package = "htmlwidgets", Version = "1.6.4", Source = "Repository", Repository = "CRAN", Requirements = c("grDevices", "htmltools", "jsonlite", "knitr", "rmarkdown", "yaml"), Hash = "04291cc45198225444a397606810ac37"), MASS = list(Package = "MASS", Version = "7.3-60.2", Source = "Repository", Repository = "CRAN", Requirements = c("R", "grDevices", "graphics", "methods", "stats", "utils"), Hash = "2f342c46163b0b54d7b64d1f798e2c78"), tibble = list(Package = "tibble", Version = "3.2.1", Source = "Repository", Repository = "CRAN", Requirements = c("R", "fansi", "lifecycle", "magrittr", "methods", "pillar", "pkgconfig", "rlang", "utils", "vctrs"), Hash = "a84e2cc86d07289b3b6f5069df7a004c"), munsell = list(Package = "munsell", Version = "0.5.1", Source = "Repository", Repository = "CRAN", Requirements = c("colorspace", "methods"), Hash = "4fd8900853b746af55b81fda99da7695"), reactable = list(Package = "reactable", Version = "0.4.4", Source = "Repository", Repository = "CRAN", Requirements = c("R", "digest", "htmltools", "htmlwidgets", "jsonlite", "reactR"), Hash = "6069eb2a6597963eae0605c1875ff14c"), bslib = list(Package = "bslib", Version = "0.7.0", Source = "Repository", Repository = "CRAN", Requirements = c("R", "base64enc", "cachem", "fastmap", "grDevices", "htmltools", "jquerylib", "jsonlite", "lifecycle", "memoise", "mime", "rlang", "sass"), Hash = "8644cc53f43828f19133548195d7e59e"), pillar = list(Package = "pillar", Version = "1.9.0", Source = "Repository", Repository = "CRAN", Requirements = c("cli", "fansi", "glue", "lifecycle", "rlang", "utf8", "utils", "vctrs"), Hash = "15da5a8412f317beeee6175fbc76f4bb"), RColorBrewer = list(Package = "RColorBrewer", Version = "1.1-3", Source = "Repository", Repository = "CRAN", Requirements = "R", Hash = "45f0398006e83a5b10b72a90663d8d8c"), rlang = list(Package = "rlang", Version = "1.1.3", Source = "Repository", Repository = "CRAN", Requirements = c("R", "utils"), Hash = "42548638fae05fd9a9b5f3f437fbbbe2"), utf8 = list(Package = "utf8", Version = "1.2.4", Source = "Repository", Repository = "CRAN", Requirements = "R", Hash = "62b65c52671e6665f803ff02954446e9"), cachem = list(Package = "cachem", Version = "1.0.8", Source = "Repository", Repository = "CRAN", Requirements = c("fastmap", "rlang"), Hash = "c35768291560ce302c0a6589f92e837d"), reactR = list(Package = "reactR", Version = "0.5.0", Source = "Repository", Repository = "CRAN", Requirements = "htmltools", Hash = "c9014fd1a435b2d790dd506589cb24e5"), xfun = list(Package = "xfun", Version = "0.43", Source = "Repository", Repository = "CRAN", Requirements = c("grDevices", "stats", "tools"), Hash = "ab6371d8653ce5f2f9290f4ec7b42a8e"), fs = list(Package = "fs", Version = "1.6.4", Source = "Repository", Repository = "CRAN", Requirements = c("R", "methods"), Hash = "15aeb8c27f5ea5161f9f6a641fafd93a"), sass = list(Package = "sass", Version = "0.4.9", Source = "Repository", Repository = "CRAN", Requirements = c("R6", "fs", "htmltools", "rappdirs", "rlang"), Hash = "d53dbfddf695303ea4ad66f86e99b95d"), memoise = list(Package = "memoise", Version = "2.0.1", Source = "Repository", Repository = "CRAN", Requirements = c("cachem", "rlang"), Hash = "e2817ccf4a065c5d9d7f2cfbe7c1d78c"), viridisLite = list(Package = "viridisLite", Version = "0.4.2", Source = "Repository", Repository = "CRAN", Requirements = "R", Hash = "c826c7c4241b6fc89ff55aaea3fa7491"), cli = list(Package = "cli", Version = "3.6.2", Source = "Repository", Repository = "CRAN", Requirements = c("R", "utils"), Hash = "1216ac65ac55ec0058a6f75d7ca0fd52"), withr = list(Package = "withr", Version = "3.0.0", Source = "Repository", Repository = "CRAN", Requirements = c("R", "grDevices", "graphics"), Hash = "d31b6c62c10dcf11ec530ca6b0dd5d35"), magrittr = list(Package = "magrittr", Version = "2.0.3", Source = "Repository", Repository = "CRAN", Requirements = "R", Hash = "7ce2733a9826b3aeb1775d56fd305472"), mgcv = list(Package = "mgcv", Version = "1.9-1", Source = "Repository", Repository = "CRAN", Requirements = c("Matrix", "R", "graphics", "methods", "nlme", "splines", "stats", "utils"), Hash = "110ee9d83b496279960e162ac97764ce"), digest = list(Package = "digest", Version = "0.6.35", Source = "Repository", Repository = "CRAN", Requirements = c("R", "utils"), Hash = "698ece7ba5a4fa4559e3d537e7ec3d31"), fontawesome = list(Package = "fontawesome", Version = "0.5.2", Source = "Repository", Repository = "CRAN", Requirements = c("R", "htmltools", "rlang"), Hash = "c2efdd5f0bcd1ea861c2d4e2a883a67d"), rappdirs = list(Package = "rappdirs", Version = "0.3.3", Source = "Repository", Repository = "CRAN", Requirements = "R", Hash = "5e3c5dc0b071b21fa128676560dbe94d"), base64enc = list(Package = "base64enc", Version = "0.1-3", Source = "Repository", Repository = "CRAN", Requirements = "R", Hash = "543776ae6848fde2f48ff3816d0628bc"), lifecycle = list(Package = "lifecycle", Version = "1.0.4", Source = "Repository", Repository = "CRAN", Requirements = c("R", "cli", "glue", "rlang"), Hash = "b8552d117e1b808b09a832f589b79035"), nlme = list(Package = "nlme", Version = "3.1-164", Source = "Repository", Repository = "CRAN", Requirements = c("R", "graphics", "lattice", "stats", "utils"), Hash = "a623a2239e642806158bc4dc3f51565d"), vctrs = list(Package = "vctrs", Version = "0.6.5", Source = "Repository", Repository = "CRAN", Requirements = c("R", "cli", "glue", "lifecycle", "rlang"), Hash = "c03fa420630029418f7e6da3667aac4a"), evaluate = list(Package = "evaluate", Version = "0.23", Source = "Repository", Repository = "CRAN", Requirements = c("R", "methods"), Hash = "daf4a1246be12c1fa8c7705a0935c1a0"), glue = list(Package = "glue", Version = "1.7.0", Source = "Repository", Repository = "CRAN", Requirements = c("R", "methods"), Hash = "e0b3a53876554bd45879e596cdb10a52"), farver = list(Package = "farver", Version = "2.1.1", Source = "Repository", Repository = "CRAN", Hash = "8106d78941f34855c440ddb946b8f7a5"), fansi = list(Package = "fansi", Version = "1.0.6", Source = "Repository", Repository = "CRAN", Requirements = c("R", "grDevices", "utils"), Hash = "962174cf2aeb5b9eea581522286a911f"), colorspace = list(Package = "colorspace", Version = "2.1-0", Source = "Repository", Repository = "CRAN", Requirements = c("R", "grDevices", "graphics", "methods", "stats"), Hash = "f20c47fd52fae58b4e377c37bb8c335b"), rmarkdown = list(Package = "rmarkdown", Version = "2.26", Source = "Repository", Repository = "CRAN", Requirements = c("R", "bslib", "evaluate", "fontawesome", "htmltools", "jquerylib", "jsonlite", "knitr", "methods", "tinytex", "tools", "utils", "xfun", "yaml"), Hash = "9b148e7f95d33aac01f31282d49e4f44"), pkgconfig = list(Package = "pkgconfig", Version = "2.0.3", Source = "Repository", Repository = "CRAN", Requirements = "utils", Hash = "01f28d4278f15c76cddbea05899c5d6f"), htmltools = list(Package = "htmltools", Version = "0.5.8.1", Source = "Repository", Repository = "CRAN", Requirements = c("R", "base64enc", "digest", "fastmap", "grDevices", "rlang", "utils"), Hash = "81d371a9cc60640e74e4ab6ac46dcedc")))      )
    )
    observeEvent(input$next_tab_1, {
      shinyjs::js$enableTab('tab2')
      shinyjs::js$disableTab('tab1')
      updateTabsetPanel(
        session, 'mainTabSet',
        selected = 'tab2'
      )
    })
    observeEvent(input$next_tab_2, {
      shinyjs::js$enableTab('tab3')
      shinyjs::js$disableTab('tab2')
      updateTabsetPanel(
        session, 'mainTabSet',
        selected = 'tab3'
      )
    })
    observeEvent(input$previous_tab_2, {
      shinyjs::delay(50, {
        shinyjs::js$enableTab('tab1')
        shinyjs::js$disableTab('tab2')
      })
      removeTab('mainTabSet','tab2',session)
      insertTab(
        inputId = 'mainTabSet',
        tab = tabPanel(
          title = "Cluster Iris Data",
          value = "tab2",
          iris_cluster_ui(ns("mod2")),
          fluidRow(
            actionButton(ns('previous_tab_2'), label = "Previous"),
            actionButton(ns('next_tab_2'), label = "Next")
          )
        ),
        target = 'tab1',
        position = 'after'
      )
      updateTabsetPanel(
        session, 'mainTabSet',
                selected = 'tab1'
      )
    })
    observeEvent(input$next_tab_3, {
      shinyjs::js$enableTab('tab4')
      shinyjs::js$disableTab('tab3')
      updateTabsetPanel(
        session, 'mainTabSet',
        selected = 'tab4'
      )
    })
    observeEvent(input$previous_tab_3, {
      shinyjs::delay(50, {
        shinyjs::js$enableTab('tab2')
        shinyjs::js$disableTab('tab3')
      })
      removeTab('mainTabSet','tab3',session)
      insertTab(
        inputId = 'mainTabSet',
        tab = tabPanel(
          title = "Subset Rows",
          value = "tab3",
          subset_rows_ui(ns("mod3")),
          fluidRow(
            actionButton(ns('previous_tab_3'), label = "Previous"),
            actionButton(ns('next_tab_3'), label = "Next")
          )
        ),
        target = 'tab2',
        position = 'after'
      )
      updateTabsetPanel(
        session, 'mainTabSet',
                selected = 'tab2'
      )
    })
    observeEvent(input$next_tab_4, {
      shinyjs::js$enableTab('tab5')
      shinyjs::js$disableTab('tab4')
      updateTabsetPanel(
        session, 'mainTabSet',
        selected = 'tab5'
      )
    })
    observeEvent(input$previous_tab_4, {
      shinyjs::delay(50, {
        shinyjs::js$enableTab('tab3')
        shinyjs::js$disableTab('tab4')
      })
      removeTab('mainTabSet','tab4',session)
      insertTab(
        inputId = 'mainTabSet',
        tab = tabPanel(
          title = "Plot Column",
          value = "tab4",
          single_column_plot_ui(ns("mod4")),
          fluidRow(
            actionButton(ns('previous_tab_4'), label = "Previous"),
            actionButton(ns('next_tab_4'), label = "Next")
          )
        ),
        target = 'tab3',
        position = 'after'
      )
      updateTabsetPanel(
        session, 'mainTabSet',
                selected = 'tab3'
      )
    })
    observeEvent(input$previous_tab_5, {
      shinyjs::delay(50, {
        shinyjs::js$enableTab('tab4')
        shinyjs::js$disableTab('tab5')
      })
      updateTabsetPanel(
        session, 'mainTabSet',
                selected = 'tab4'
      )
    })
  })
}
