/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp.testing;

import com.google.common.base.Equivalence;
import java.io.InputStream;
import java.util.function.Predicate;
import org.dmg.pmml.PMML;
import org.jpmml.converter.testing.ModelEncoderBatch;
import org.jpmml.evaluator.ResultField;
import org.jpmml.rexp.Converter;
import org.jpmml.rexp.ConverterFactory;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpParser;
import org.jpmml.rexp.testing.RExpEncoderBatchTest;

public abstract class RExpEncoderBatch
extends ModelEncoderBatch {
    private Class<? extends Converter<? extends RExp>> converterClazz = null;

    public RExpEncoderBatch(String algorithm, String dataset, Predicate<ResultField> columnFilter, Equivalence<Object> equivalence) {
        super(algorithm, dataset, columnFilter, equivalence);
    }

    public abstract RExpEncoderBatchTest getArchiveBatchTest();

    public String getRdsPath() {
        return "/rds/" + this.getAlgorithm() + this.getDataset() + ".rds";
    }

    public PMML getPMML() throws Exception {
        RExp rexp;
        try (InputStream is = this.open(this.getRdsPath());){
            RExpParser parser = new RExpParser(is);
            rexp = parser.parse();
        }
        Converter<RExp> converter = this.createConverter(rexp);
        PMML pmml = converter.encodePMML();
        this.validatePMML(pmml);
        return pmml;
    }

    public Converter<RExp> createConverter(RExp rexp) {
        Class<? extends Converter<? extends RExp>> converterClazz = this.getConverterClazz();
        ConverterFactory converterFactory = ConverterFactory.newInstance();
        Converter<RExp> converter = converterClazz != null ? converterFactory.newConverter(converterClazz, rexp) : converterFactory.newConverter(rexp);
        return converter;
    }

    public Class<? extends Converter<? extends RExp>> getConverterClazz() {
        return this.converterClazz;
    }

    void setConverterClazz(Class<? extends Converter<? extends RExp>> converterClazz) {
        this.converterClazz = converterClazz;
    }
}

