/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.ubjson;

import com.devsmart.ubjson.UBArray;
import com.devsmart.ubjson.UBBool;
import com.devsmart.ubjson.UBChar;
import com.devsmart.ubjson.UBFloat32;
import com.devsmart.ubjson.UBFloat32Array;
import com.devsmart.ubjson.UBFloat64;
import com.devsmart.ubjson.UBFloat64Array;
import com.devsmart.ubjson.UBInt16;
import com.devsmart.ubjson.UBInt16Array;
import com.devsmart.ubjson.UBInt32;
import com.devsmart.ubjson.UBInt32Array;
import com.devsmart.ubjson.UBInt64;
import com.devsmart.ubjson.UBInt64Array;
import com.devsmart.ubjson.UBInt8;
import com.devsmart.ubjson.UBInt8Array;
import com.devsmart.ubjson.UBNull;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBString;
import com.devsmart.ubjson.UBStringArray;
import com.devsmart.ubjson.UBUInt8;
import com.devsmart.ubjson.UBValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class UBValueFactory {
    private static final UBNull VALUE_NULL = new UBNull();
    private static final UBBool VALUE_TRUE = new UBBool(true);
    private static final UBBool VALUE_FALSE = new UBBool(false);

    public static UBNull createNull() {
        return VALUE_NULL;
    }

    public static UBChar createChar(char value) {
        return new UBChar(value);
    }

    public static UBBool createBool(boolean value) {
        if (value) {
            return VALUE_TRUE;
        }
        return VALUE_FALSE;
    }

    static boolean inRange(long value, long min, long max) {
        return value >= min && value <= max;
    }

    public static UBValue createNumber(Number value) {
        if (value instanceof Integer) {
            return UBValueFactory.createInt(value.longValue());
        }
        return UBValueFactory.createFloat64(value.doubleValue());
    }

    public static UBValue createInt(long value) {
        if (UBValueFactory.inRange(value, 0L, 255L)) {
            return new UBUInt8(value);
        }
        if (UBValueFactory.inRange(value, -128L, 127L)) {
            return new UBInt8(value);
        }
        if (UBValueFactory.inRange(value, -32768L, 32767L)) {
            return new UBInt16(value);
        }
        if (UBValueFactory.inRange(value, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
            return new UBInt32(value);
        }
        return new UBInt64(value);
    }

    public static UBFloat32 createFloat32(float value) {
        return new UBFloat32(value);
    }

    public static UBFloat64 createFloat64(double value) {
        return new UBFloat64(value);
    }

    public static UBString createString(byte[] string) {
        return new UBString(string);
    }

    public static UBString createString(String string) {
        return UBValueFactory.createString(string.getBytes(UBString.UTF_8));
    }

    public static UBValue createStringOrNull(String string) {
        if (string == null) {
            return UBValueFactory.createNull();
        }
        return UBValueFactory.createString(string);
    }

    public static UBInt8Array createArray(boolean[] value) {
        byte[] data = new byte[value.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(value[i] ? 1 : 0);
        }
        return UBValueFactory.createArray(data);
    }

    public static UBValue createArrayOrNull(boolean[] value) {
        if (value == null) {
            return UBValueFactory.createNull();
        }
        return UBValueFactory.createArray(value);
    }

    public static UBInt8Array createArray(byte[] value) {
        return new UBInt8Array(value);
    }

    public static UBValue createArrayOrNull(byte[] value) {
        if (value == null) {
            return UBValueFactory.createNull();
        }
        return UBValueFactory.createArray(value);
    }

    public static UBInt16Array createArray(short[] value) {
        return new UBInt16Array(value);
    }

    public static UBValue createArrayOrNull(short[] value) {
        if (value == null) {
            return UBValueFactory.createNull();
        }
        return UBValueFactory.createArray(value);
    }

    public static UBInt32Array createArray(int[] value) {
        return new UBInt32Array(value);
    }

    public static UBValue createArrayOrNull(int[] value) {
        if (value == null) {
            return UBValueFactory.createNull();
        }
        return UBValueFactory.createArray(value);
    }

    public static UBInt64Array createArray(long[] value) {
        return new UBInt64Array(value);
    }

    public static UBValue createArrayOrNull(long[] value) {
        if (value == null) {
            return UBValueFactory.createNull();
        }
        return UBValueFactory.createArray(value);
    }

    public static UBFloat32Array createArray(float[] value) {
        return new UBFloat32Array(value);
    }

    public static UBValue createArrayOrNull(float[] value) {
        if (value == null) {
            return UBValueFactory.createNull();
        }
        return UBValueFactory.createArray(value);
    }

    public static UBFloat64Array createArray(double[] value) {
        return new UBFloat64Array(value);
    }

    public static UBValue createArrayOrNull(double[] value) {
        if (value == null) {
            return UBValueFactory.createNull();
        }
        return UBValueFactory.createArray(value);
    }

    public static UBStringArray createArray(String[] value) {
        return new UBStringArray(value);
    }

    public static UBValue createArrayOrNull(String[] value) {
        if (value == null) {
            return UBValueFactory.createNull();
        }
        return UBValueFactory.createArray(value);
    }

    public static UBArray createArray(UBValue ... args) {
        return new UBArray(args);
    }

    public static UBArray createArray(Iterable values) {
        ArrayList<UBValue> newArray = new ArrayList<UBValue>();
        for (Object obj : values) {
            newArray.add(UBValueFactory.createValue(obj));
        }
        return UBValueFactory.createArray(newArray.toArray(new UBValue[newArray.size()]));
    }

    public static UBObject createObject(Map map) {
        TreeMap<String, UBValue> newMap = new TreeMap<String, UBValue>();
        for (Map.Entry e : map.entrySet()) {
            if (!(e.getKey() instanceof String)) {
                throw new IllegalArgumentException("key is not a String");
            }
            newMap.put((String)e.getKey(), UBValueFactory.createValue(e.getValue()));
        }
        return new UBObject(newMap);
    }

    public static UBObject createObject() {
        return new UBObject();
    }

    public static UBValue createValueOrNull(UBValue value) {
        if (value == null) {
            return UBValueFactory.createNull();
        }
        return value;
    }

    public static UBValue createValue(Object obj) {
        if (obj == null) {
            return UBValueFactory.createNull();
        }
        if (obj instanceof UBValue) {
            return (UBValue)obj;
        }
        if (obj instanceof Boolean) {
            return UBValueFactory.createBool((Boolean)obj);
        }
        if (obj instanceof Integer) {
            return UBValueFactory.createInt(((Integer)obj).longValue());
        }
        if (obj instanceof Double) {
            return UBValueFactory.createFloat64((Double)obj);
        }
        if (obj instanceof Float) {
            return UBValueFactory.createFloat32(((Float)obj).floatValue());
        }
        if (obj instanceof String) {
            return UBValueFactory.createString((String)obj);
        }
        if (obj instanceof Map) {
            return UBValueFactory.createObject((Map)obj);
        }
        if (obj instanceof Iterable) {
            return UBValueFactory.createArray((Iterable)obj);
        }
        throw new IllegalArgumentException("unknown object type: " + obj.getClass().getSimpleName());
    }
}

