## ----echo = FALSE, warning=FALSE----------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
set.seed(142)
normal_sample <- rnorm(100)

## -----------------------------------------------------------------------------
sampled_dist <- sample_from_density(normal_sample, 100)

## ----echo = FALSE-------------------------------------------------------------
plot(ks::kde(normal_sample),
  xlab = "", main = "original vs sample_from_density()",
  col = "blue",
  ylim = c(0, 0.5)
)
kde_sample <- ks::kde(sampled_dist)
plot(kde_sample, col = "red", add = TRUE)
legend("topleft",
  c("sample_from_density", "original"),
  lty = c(1, 1), col = c("red", "blue")
)

