## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(SimplyAgree)

dat = data.frame(
  x = c(7, 8.3, 10.5, 9, 5.1, 8.2, 10.2, 10.3, 7.1, 5.9),
  y = c(7.9, 8.2, 9.6, 9, 6.5, 7.3, 10.2, 10.6, 6.3, 5.2)
)


## -----------------------------------------------------------------------------
dem1 = dem_reg(x = "x",
               y = "y",
               data = dat,
               error.ratio = 4,
               weighted = FALSE)
dem1

## -----------------------------------------------------------------------------
plot(dem1)

## -----------------------------------------------------------------------------
check(dem1)

## -----------------------------------------------------------------------------
library(deming)
data('ferritin')

head(ferritin)

## -----------------------------------------------------------------------------
dem2 = dem_reg(
  x = "new.lot",
  y = "old.lot",
  data = ferritin,
  weighted = FALSE
)
dem2

check(dem2)

## -----------------------------------------------------------------------------
dem2 = dem_reg(
  x = "new.lot",
  y = "old.lot",
  data = ferritin,
  weighted = TRUE
)
dem2

plot(dem2)

check(dem2)

