/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.selectors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.vikamine.kernel.Describer;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.selectors.AbstractSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.util.IdentityLongDescriber;

public class DefaultSGSelector
extends AbstractSGSelector {
    private Set<Value> values;

    public DefaultSGSelector(Ontology onto, String attributeID, String valueID) {
        super(onto.getAttribute(attributeID));
        if (onto.getAttribute(attributeID) == null) {
            throw new IllegalArgumentException("Attribute " + attributeID + " does not exist!");
        }
        if (!onto.getAttribute(attributeID).isNominal()) {
            throw new IllegalArgumentException("Attribute " + attributeID + " is not nominal!");
        }
        Value v = ((NominalAttribute)onto.getAttribute(attributeID)).getNominalValueFromID(valueID);
        this.values = Collections.singleton(v);
    }

    public DefaultSGSelector(Attribute a, Value value) {
        this(a, Collections.singleton(value));
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
    }

    public DefaultSGSelector(Attribute a, Set<Value> values) {
        super(a);
        if (values == null) {
            throw new IllegalArgumentException("Values is null");
        }
        this.values = new HashSet<Value>(values);
    }

    public DefaultSGSelector(DefaultSGSelector sel) {
        this(sel.getAttribute(), sel.getValues());
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public boolean isContainedInInstance(DataRecord instance) {
        for (Value value : this.values) {
            if (!value.isValueContainedInInstance(instance)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultSGSelector otherSGS = (DefaultSGSelector)object;
        return this.getAttribute().equals(otherSGS.getAttribute()) && this.values.equals(otherSGS.values);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.getAttribute().hashCode();
        hash = 37 * hash + this.values.hashCode();
        return hash;
    }

    @Override
    public String getId() {
        StringBuffer buffy = new StringBuffer();
        LinkedList<Value> sortedValues = new LinkedList<Value>(this.values);
        if (sortedValues.size() > 1) {
            buffy.append(String.valueOf(this.getAttribute().getId()) + "={");
        } else {
            buffy.append(String.valueOf(this.getAttribute().getId()) + "=");
        }
        Collections.sort(sortedValues, new Value.ValueComparator());
        Iterator iter = sortedValues.iterator();
        while (iter.hasNext()) {
            Value element = (Value)iter.next();
            buffy.append(element.getId());
            if (!iter.hasNext()) continue;
            buffy.append("; ");
        }
        if (sortedValues.size() > 1) {
            buffy.append("}");
        }
        return buffy.toString();
    }

    @Override
    public String getDescription(Describer d) {
        StringBuffer buffy = new StringBuffer();
        buffy.append(d.createDescription(this.getAttribute()));
        if (this.values.isEmpty() || this.values.size() > 1) {
            buffy.append("={");
            LinkedList<Value> sortedValues = new LinkedList<Value>(this.values);
            Collections.sort(sortedValues, new Value.ValueComparator());
            Iterator iter = sortedValues.iterator();
            while (iter.hasNext()) {
                Value element = (Value)iter.next();
                buffy.append(d.createDescription(element));
                if (!iter.hasNext()) continue;
                buffy.append("; ");
            }
            buffy.append("}");
        } else {
            buffy.append("=" + d.createDescription((Value)this.values.toArray()[0]));
        }
        return buffy.toString();
    }

    @Override
    public String getDescription() {
        return this.getDescription(new IdentityLongDescriber());
    }

    @Override
    public Set<Value> getValues() {
        return this.values;
    }

    @Override
    public boolean isMaybeRedundant() {
        if (!this.getAttribute().isNominal()) {
            return false;
        }
        LinkedList<Value> containedValues = new LinkedList<Value>();
        for (Value val : this.values) {
            containedValues.add(val);
        }
        if (containedValues.isEmpty()) {
            return true;
        }
        NominalAttribute att = (NominalAttribute)this.getAttribute();
        Iterator<Value> iter = att.allValuesIterator();
        while (iter.hasNext()) {
            Value val = iter.next();
            if (containedValues.contains(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() {
        DefaultSGSelector sel = (DefaultSGSelector)super.clone();
        sel.values = new HashSet<Value>(sel.values);
        return sel;
    }

    @Override
    public boolean addValue(Value val) {
        return this.values.add(val);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.values.addAll(c);
    }

    @Override
    public boolean removeValue(Value val) {
        return this.values.remove(val);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.values.removeAll(c);
    }

    @Override
    public boolean includes(SGSelector otherSel) {
        if (!(otherSel instanceof DefaultSGSelector)) {
            return false;
        }
        if (this.getAttribute() != otherSel.getAttribute()) {
            return false;
        }
        return this.values.containsAll(((DefaultSGSelector)otherSel).values);
    }
}

