/*
 * Decompiled with CFR 0.152.
 */
package dsa;

import dsa.Partition;
import dsa.Split;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class Node {
    static final int MAYBE = -1;
    static final int NO = 0;
    static final int YES = 1;
    static final int DONTCARE = 2;
    int level;
    Split split;
    Node right;
    Node left;
    List<Partition> partlist;

    Node(int level, List<Partition> partlist) {
        assert (partlist.size() > 0);
        this.level = level;
        this.split = null;
        this.right = null;
        this.left = null;
        this.partlist = partlist;
    }

    String pnames() {
        StringBuffer sb = new StringBuffer();
        for (Partition p : this.partlist) {
            sb.append(", ");
            sb.append(p.name);
        }
        sb.delete(0, 2);
        return sb.toString();
    }

    Set<Split> getsplits() {
        HashSet<Split> s = new HashSet<Split>();
        for (Partition p : this.partlist) {
            s.addAll(p.getsplits());
        }
        return s;
    }

    void splitup(Set<Split> splits) {
        if (this.partlist.size() == 1) {
            return;
        }
        assert (splits.size() > 0);
        Split best = this.bestsplit(splits);
        HashSet<Split> subsplits = new HashSet<Split>();
        subsplits.addAll(splits);
        subsplits.remove(best);
        ArrayList<Partition> maybe = new ArrayList<Partition>();
        ArrayList<Partition> no = new ArrayList<Partition>();
        ArrayList<Partition> yes = new ArrayList<Partition>();
        ArrayList<Partition> dont = new ArrayList<Partition>();
        block6: for (Partition p : this.partlist) {
            switch (p.satisfied(best)) {
                case -1: {
                    maybe.add(p);
                    continue block6;
                }
                case 0: {
                    no.add(p);
                    continue block6;
                }
                case 1: {
                    yes.add(p);
                    continue block6;
                }
                case 2: {
                    dont.add(p);
                    continue block6;
                }
            }
            throw new RuntimeException("satisfied method returned unexpected value");
        }
        if (maybe.size() > 0) {
            System.err.printf("warning: tree resulted in %d maybe's", maybe.size());
        }
        if (dont.size() > 0) {
            System.err.printf("warning: tree resulted in %d don't cares", dont.size());
        }
        ArrayList<Partition> leftPartitions = new ArrayList<Partition>();
        leftPartitions.addAll(yes);
        leftPartitions.addAll(dont);
        leftPartitions.addAll(maybe);
        ArrayList<Partition> rightPartitions = new ArrayList<Partition>();
        rightPartitions.addAll(no);
        rightPartitions.addAll(maybe);
        this.left = new Node(this.level + 1, leftPartitions);
        this.left.splitup(subsplits);
        this.right = new Node(this.level + 1, rightPartitions);
        this.right.splitup(subsplits);
        this.split = best;
    }

    Split bestsplit(Set<Split> splits) {
        int best = Integer.MIN_VALUE;
        Split split = null;
        for (Split i : splits) {
            int s = this.score(i);
            if (s <= best) continue;
            best = s;
            split = i;
        }
        assert (split != null);
        if (best < 0) {
            throw new RuntimeException("no workable split");
        }
        return split;
    }

    int score(Split split) {
        ArrayList<Partition> maybe = new ArrayList<Partition>();
        ArrayList<Partition> no = new ArrayList<Partition>();
        ArrayList<Partition> yes = new ArrayList<Partition>();
        ArrayList<Partition> dont = new ArrayList<Partition>();
        block6: for (Partition p : this.partlist) {
            switch (p.satisfied(split)) {
                case -1: {
                    maybe.add(p);
                    continue block6;
                }
                case 0: {
                    no.add(p);
                    continue block6;
                }
                case 1: {
                    yes.add(p);
                    continue block6;
                }
                case 2: {
                    dont.add(p);
                    continue block6;
                }
            }
            throw new RuntimeException("satisfied method returned unexpected value");
        }
        int npart = this.partlist.size();
        if (maybe.size() > 0 || no.size() == 0 || yes.size() == 0) {
            return -1;
        }
        return (npart - dont.size()) * npart - Math.abs(yes.size() - no.size());
    }

    static String[] getLabels() {
        return new String[]{"Partition name", "Predicted value", "Observations", "Nodes in partition", "Cut off growth"};
    }

    Map<String, String> description() {
        HashMap<String, String> m = new HashMap<String, String>();
        Partition p = this.partlist.get(0);
        m.put("Partition name", p.name);
        m.put("Predicted value", p.predictedValue);
        m.put("Observations", p.numobs);
        m.put("Nodes in partition", p.numsections);
        m.put("Cut off growth", p.maxpartitions);
        return m;
    }

    String pname() {
        if (this.partlist.size() == 1) {
            return this.partlist.get((int)0).name;
        }
        return null;
    }

    Icon getImage() {
        if (this.partlist.size() == 1) {
            return this.partlist.get((int)0).image;
        }
        return null;
    }

    public String toString() {
        String s;
        if (this.split != null) {
            s = this.split.toString();
        } else if (this.partlist.size() > 0) {
            String partname = this.partlist.get((int)0).name;
            String value = this.partlist.get(0).getPredictedValue();
            try {
                float val = Float.parseFloat(value);
                value = String.format("%.2f", Float.valueOf(val));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            s = String.format("%s: %s", partname, value);
        } else {
            s = "Error: node with no partitions";
        }
        return s;
    }
}

