/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import weka.core.Instances;

public final class Values {
    int numInstances;
    int missingInstances;
    int first;
    int last;
    int attr;
    double sum;
    double sqrSum;
    double va;
    double sd;

    public Values(int n, int n2, int n3, Instances instances) {
        int n4 = 0;
        this.numInstances = n2 - n + 1;
        this.missingInstances = 0;
        this.first = n;
        this.last = n2;
        this.attr = n3;
        this.sum = 0.0;
        this.sqrSum = 0.0;
        for (int i = this.first; i <= this.last; ++i) {
            if (!instances.instance(i).isMissing(this.attr)) {
                ++n4;
                double d = instances.instance(i).value(this.attr);
                this.sum += d;
                this.sqrSum += d * d;
            }
            if (n4 > 1) {
                this.va = (this.sqrSum - this.sum * this.sum / (double)n4) / (double)n4;
                this.va = Math.abs(this.va);
                this.sd = Math.sqrt(this.va);
                continue;
            }
            this.va = 0.0;
            this.sd = 0.0;
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Print statistic values of instances (" + this.first + "-" + this.last + "\n");
        stringBuffer.append("    Number of instances:\t" + this.numInstances + "\n");
        stringBuffer.append("    NUmber of instances with unknowns:\t" + this.missingInstances + "\n");
        stringBuffer.append("    Attribute:\t\t\t:" + this.attr + "\n");
        stringBuffer.append("    Sum:\t\t\t" + this.sum + "\n");
        stringBuffer.append("    Squared sum:\t\t" + this.sqrSum + "\n");
        stringBuffer.append("    Stanard Deviation:\t\t" + this.sd + "\n");
        return stringBuffer.toString();
    }
}

