/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableClassifier;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;

public class SimpleCart
extends RandomizableClassifier
implements AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = 4154189200352566053L;
    protected Instances m_train;
    protected SimpleCart[] m_Successors;
    protected Attribute m_Attribute;
    protected double m_SplitValue;
    protected String m_SplitString;
    protected double m_ClassValue;
    protected Attribute m_ClassAttribute;
    protected double m_minNumObj = 2.0;
    protected int m_numFoldsPruning = 5;
    protected double m_Alpha;
    protected double m_numIncorrectModel;
    protected double m_numIncorrectTree;
    protected boolean m_isLeaf;
    protected boolean m_Prune = true;
    protected int m_totalTrainInstances;
    protected double[] m_Props;
    protected double[] m_ClassProbs = null;
    protected double[] m_Distribution;
    protected boolean m_Heuristic = true;
    protected boolean m_UseOneSE = false;
    protected double m_SizePer = 1.0;

    public String globalInfo() {
        return "Class implementing minimal cost-complexity pruning.\nNote when dealing with missing values, use \"fractional instances\" method instead of surrogate split method.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman and Jerome H. Friedman and Richard A. Olshen and Charles J. Stone");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1984");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Classification and Regression Trees");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Wadsworth International Group");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Belmont, California");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        double d;
        int n2;
        Object object;
        Object object2;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (!this.m_Prune) {
            int[][] nArray = new int[instances.numAttributes()][0];
            double[][] dArray = new double[instances.numAttributes()][0];
            double[] dArray2 = new double[instances.numClasses()];
            double d2 = this.computeSortedInfo(instances, nArray, dArray, dArray2);
            this.makeTree(instances, instances.numInstances(), nArray, dArray, dArray2, d2, this.m_minNumObj, this.m_Heuristic);
            return;
        }
        Random random = new Random(this.m_Seed);
        Instances instances2 = new Instances(instances);
        instances2.randomize(random);
        instances2 = new Instances(instances2, 0, (int)((double)instances2.numInstances() * this.m_SizePer) - 1);
        instances2.stratify(this.m_numFoldsPruning);
        double[][] dArrayArray = new double[this.m_numFoldsPruning][];
        double[][] dArrayArray2 = new double[this.m_numFoldsPruning][];
        for (int i = 0; i < this.m_numFoldsPruning; ++i) {
            object2 = instances2.trainCV(this.m_numFoldsPruning, i);
            object = instances2.testCV(this.m_numFoldsPruning, i);
            int[][] nArray = new int[((Instances)object2).numAttributes()][0];
            double[][] dArray = new double[((Instances)object2).numAttributes()][0];
            double[] dArray3 = new double[((Instances)object2).numClasses()];
            double d3 = this.computeSortedInfo((Instances)object2, nArray, dArray, dArray3);
            this.makeTree((Instances)object2, ((Instances)object2).numInstances(), nArray, dArray, dArray3, d3, this.m_minNumObj, this.m_Heuristic);
            int n3 = this.numInnerNodes();
            dArrayArray[i] = new double[n3 + 2];
            dArrayArray2[i] = new double[n3 + 2];
            this.prune(dArrayArray[i], dArrayArray2[i], (Instances)object);
        }
        int[][] nArray = new int[instances.numAttributes()][0];
        object2 = new double[instances.numAttributes()][0];
        object = new double[instances.numClasses()];
        double d4 = this.computeSortedInfo(instances, nArray, (double[][])object2, (double[])object);
        this.makeTree(instances, instances.numInstances(), nArray, (double[][])object2, (double[])object, d4, this.m_minNumObj, this.m_Heuristic);
        int n4 = this.numInnerNodes();
        double[] dArray = new double[n4 + 2];
        int n5 = this.prune(dArray, null, null);
        double[] dArray4 = new double[n4 + 2];
        for (n2 = 0; n2 <= n5; ++n2) {
            d = Math.sqrt(dArray[n2] * dArray[n2 + 1]);
            double d5 = 0.0;
            for (n = 0; n < this.m_numFoldsPruning; ++n) {
                int n6 = 0;
                while (dArrayArray[n][n6] <= d) {
                    ++n6;
                }
                d5 += dArrayArray2[n][n6 - 1];
            }
            dArray4[n2] = d5 / (double)this.m_numFoldsPruning;
        }
        n2 = -1;
        d = Double.MAX_VALUE;
        for (int i = n5; i >= 0; --i) {
            if (!(dArray4[i] < d)) continue;
            d = dArray4[i];
            n2 = i;
        }
        if (this.m_UseOneSE) {
            double d6 = Math.sqrt(d * (1.0 - d) / (double)instances.numInstances());
            for (n = n5; n >= 0; --n) {
                if (!(dArray4[n] <= d + d6)) continue;
                n2 = n;
                break;
            }
        }
        double d7 = Math.sqrt(dArray[n2] * dArray[n2 + 1]);
        this.unprune();
        this.prune(d7);
    }

    protected void makeTree(Instances instances, int n, int[][] nArray, double[][] dArray, double[] dArray2, double d, double d2, boolean bl) throws Exception {
        Object object;
        int n2;
        if (d == 0.0) {
            this.m_Attribute = null;
            this.m_ClassValue = Instance.missingValue();
            this.m_Distribution = new double[instances.numClasses()];
            return;
        }
        this.m_totalTrainInstances = n;
        this.m_isLeaf = true;
        this.m_ClassProbs = new double[dArray2.length];
        this.m_Distribution = new double[dArray2.length];
        System.arraycopy(dArray2, 0, this.m_ClassProbs, 0, dArray2.length);
        System.arraycopy(dArray2, 0, this.m_Distribution, 0, dArray2.length);
        if (Utils.sum(this.m_ClassProbs) != 0.0) {
            Utils.normalize(this.m_ClassProbs);
        }
        double[][][] dArray3 = new double[instances.numAttributes()][0][0];
        double[][] dArray4 = new double[instances.numAttributes()][0];
        double[][] dArray5 = new double[instances.numAttributes()][2];
        double[] dArray6 = new double[instances.numAttributes()];
        String[] stringArray = new String[instances.numAttributes()];
        double[] dArray7 = new double[instances.numAttributes()];
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            Attribute attribute = instances.attribute(n2);
            if (n2 == instances.classIndex()) continue;
            if (attribute.isNumeric()) {
                dArray6[n2] = this.numericDistribution(dArray4, dArray3, attribute, nArray[n2], dArray[n2], dArray5, dArray7, instances);
                continue;
            }
            stringArray[n2] = this.nominalDistribution(dArray4, dArray3, attribute, nArray[n2], dArray[n2], dArray5, dArray7, instances, bl);
        }
        n2 = Utils.maxIndex(dArray7);
        this.m_Attribute = instances.attribute(n2);
        this.m_train = new Instances(instances, nArray[n2].length);
        for (int i = 0; i < nArray[n2].length; ++i) {
            object = instances.instance(nArray[n2][i]);
            Instance instance = (Instance)((Instance)object).copy();
            instance.setWeight(dArray[n2][i]);
            this.m_train.add(instance);
        }
        if (d < 2.0 * d2 || dArray7[n2] == 0.0 || dArray4[n2][0] == 0.0 || dArray4[n2][1] == 0.0) {
            this.makeLeaf(instances);
        } else {
            this.m_Props = dArray4[n2];
            int[][][] nArray2 = new int[2][instances.numAttributes()][0];
            object = new double[2][instances.numAttributes()][0];
            if (this.m_Attribute.isNumeric()) {
                this.m_SplitValue = dArray6[n2];
            } else {
                this.m_SplitString = stringArray[n2];
            }
            this.splitData(nArray2, (double[][][])object, this.m_Attribute, this.m_SplitValue, this.m_SplitString, nArray, dArray, instances);
            if ((double)nArray2[0][n2].length < d2 || (double)nArray2[1][n2].length < d2) {
                this.makeLeaf(instances);
                return;
            }
            this.m_isLeaf = false;
            this.m_Successors = new SimpleCart[2];
            for (int i = 0; i < 2; ++i) {
                this.m_Successors[i] = new SimpleCart();
                this.m_Successors[i].makeTree(instances, this.m_totalTrainInstances, nArray2[i], (double[][])object[i], dArray3[n2][i], dArray5[n2][i], d2, bl);
            }
        }
    }

    public void prune(double d) throws Exception {
        this.modelErrors();
        this.treeErrors();
        this.calculateAlphas();
        Vector vector = this.getInnerNodes();
        boolean bl = vector.size() > 0;
        double d2 = Double.MAX_VALUE;
        while (bl) {
            SimpleCart simpleCart = this.nodeToPrune(vector);
            if (simpleCart.m_Alpha > d) break;
            simpleCart.makeLeaf(simpleCart.m_train);
            if (simpleCart.m_Alpha == d2) {
                simpleCart.makeLeaf(simpleCart.m_train);
                this.treeErrors();
                this.calculateAlphas();
                vector = this.getInnerNodes();
                bl = vector.size() > 0;
                continue;
            }
            d2 = simpleCart.m_Alpha;
            this.treeErrors();
            this.calculateAlphas();
            vector = this.getInnerNodes();
            bl = vector.size() > 0;
        }
    }

    public int prune(double[] dArray, double[] dArray2, Instances instances) throws Exception {
        Evaluation evaluation;
        this.modelErrors();
        this.treeErrors();
        this.calculateAlphas();
        Vector vector = this.getInnerNodes();
        boolean bl = vector.size() > 0;
        dArray[0] = 0.0;
        if (dArray2 != null) {
            evaluation = new Evaluation(instances);
            evaluation.evaluateModel(this, instances);
            dArray2[0] = evaluation.errorRate();
        }
        int n = 0;
        double d = Double.MAX_VALUE;
        while (bl) {
            ++n;
            SimpleCart simpleCart = this.nodeToPrune(vector);
            simpleCart.m_isLeaf = true;
            if (simpleCart.m_Alpha == d) {
                --n;
                this.treeErrors();
                this.calculateAlphas();
                vector = this.getInnerNodes();
                bl = vector.size() > 0;
                continue;
            }
            dArray[n] = simpleCart.m_Alpha;
            if (dArray2 != null) {
                evaluation = new Evaluation(instances);
                evaluation.evaluateModel(this, instances);
                dArray2[n] = evaluation.errorRate();
            }
            d = simpleCart.m_Alpha;
            this.treeErrors();
            this.calculateAlphas();
            vector = this.getInnerNodes();
            bl = vector.size() > 0;
        }
        dArray[n + 1] = 1.0;
        return n;
    }

    protected void unprune() {
        if (this.m_Successors != null) {
            this.m_isLeaf = false;
            for (int i = 0; i < this.m_Successors.length; ++i) {
                this.m_Successors[i].unprune();
            }
        }
    }

    protected double numericDistribution(double[][] dArray, double[][][] dArray2, Attribute attribute, int[] nArray, double[] dArray3, double[][] dArray4, double[] dArray5, Instances instances) throws Exception {
        int n;
        Instance instance;
        double d = Double.NaN;
        double[][] dArray6 = null;
        int n2 = instances.numClasses();
        double[][] dArray7 = new double[2][n2];
        dArray6 = new double[2][n2];
        double[] dArray8 = new double[n2];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            Instance instance2 = instances.instance(nArray[i]);
            if (!instance2.isMissing(attribute)) {
                ++n3;
                double[] dArray9 = dArray7[1];
                int n4 = (int)instance2.classValue();
                dArray9[n4] = dArray9[n4] + dArray3[i];
            }
            int n5 = (int)instance2.classValue();
            dArray8[n5] = dArray8[n5] + dArray3[i];
        }
        System.arraycopy(dArray7[1], 0, dArray6[1], 0, dArray6[1].length);
        double d2 = instances.instance(nArray[0]).value(attribute);
        double d3 = -1.7976931348623157E308;
        for (int i = 0; i < nArray.length && !(instance = instances.instance(nArray[i])).isMissing(attribute); ++i) {
            if (instance.value(attribute) > d2) {
                int n6;
                double[][] dArray10 = new double[2][n2];
                for (int j = 0; j < 2; ++j) {
                    System.arraycopy(dArray7[j], 0, dArray10[j], 0, dArray10[j].length);
                }
                double[] dArray11 = new double[2];
                for (n6 = 0; n6 < 2; ++n6) {
                    dArray11[n6] = Utils.sum(dArray10[n6]);
                }
                if (Utils.sum(dArray11) != 0.0) {
                    Utils.normalize(dArray11);
                }
                for (n6 = n3; n6 < nArray.length; ++n6) {
                    Instance instance3 = instances.instance(nArray[n6]);
                    for (int j = 0; j < 2; ++j) {
                        double[] dArray12 = dArray10[j];
                        int n7 = (int)instance3.classValue();
                        dArray12[n7] = dArray12[n7] + dArray11[j] * dArray3[n6];
                    }
                }
                double d4 = this.computeGiniGain(dArray8, dArray10);
                if (d4 > d3) {
                    d3 = d4;
                    d = Math.rint((instance.value(attribute) + d2) / 2.0 * 100000.0) / 100000.0;
                    for (int j = 0; j < dArray7.length; ++j) {
                        System.arraycopy(dArray10[j], 0, dArray6[j], 0, dArray6[j].length);
                    }
                }
            }
            d2 = instance.value(attribute);
            double[] dArray13 = dArray7[0];
            int n8 = (int)instance.classValue();
            dArray13[n8] = dArray13[n8] + dArray3[i];
            double[] dArray14 = dArray7[1];
            int n9 = (int)instance.classValue();
            dArray14[n9] = dArray14[n9] - dArray3[i];
        }
        int n10 = attribute.index();
        dArray[n10] = new double[2];
        for (n = 0; n < 2; ++n) {
            dArray[n10][n] = Utils.sum(dArray6[n]);
        }
        if (Utils.sum(dArray[n10]) != 0.0) {
            Utils.normalize(dArray[n10]);
        }
        dArray4[n10] = new double[2];
        for (n = 0; n < 2; ++n) {
            double[] dArray15 = dArray4[n10];
            int n11 = n;
            dArray15[n11] = dArray15[n11] + Utils.sum(dArray6[n]);
        }
        dArray5[n10] = Math.rint(d3 * 1.0E7) / 1.0E7;
        dArray2[n10] = dArray6;
        return d;
    }

    protected String nominalDistribution(double[][] dArray, double[][][] dArray2, Attribute attribute, int[] nArray, double[] dArray3, double[][] dArray4, double[] dArray5, Instances instances, boolean bl) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String[] stringArray = new String[attribute.numValues()];
        int n6 = stringArray.length;
        int n7 = instances.numClasses();
        String string = "";
        double d = -1.7976931348623157E308;
        int[] nArray2 = new int[n6];
        for (int i = 0; i < n6; ++i) {
            nArray2[i] = 0;
        }
        double[] dArray6 = new double[n7];
        double[][] dArray7 = new double[2][n7];
        double[][] dArray8 = new double[2][n7];
        int n8 = 0;
        for (n5 = 0; n5 < nArray.length; ++n5) {
            Instance instance = instances.instance(nArray[n5]);
            if (!instance.isMissing(attribute)) {
                ++n8;
                int n9 = (int)instance.value(attribute);
                nArray2[n9] = nArray2[n9] + 1;
            }
            int n10 = (int)instance.classValue();
            dArray6[n10] = dArray6[n10] + dArray3[n5];
        }
        n5 = 0;
        for (int i = 0; i < n6; ++i) {
            if (nArray2[i] == 0) continue;
            ++n5;
        }
        String[] stringArray2 = new String[n5];
        int n11 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            if (nArray2[n4] == 0) continue;
            stringArray2[n11] = attribute.value(n4);
            ++n11;
        }
        n4 = n6 - n5;
        String[] stringArray3 = new String[n4];
        int n12 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            if (nArray2[n3] != 0) continue;
            stringArray3[n12] = attribute.value(n3);
            ++n12;
        }
        if (n5 <= 1) {
            dArray5[attribute.index()] = 0.0;
            return "";
        }
        if (instances.numClasses() == 2) {
            int n13;
            Instance instance;
            int n14;
            double[] dArray9 = new double[n5];
            double[][] dArray10 = new double[n5][2];
            for (n14 = 0; n14 < n5; ++n14) {
                for (int i = 0; i < 2; ++i) {
                    dArray10[n14][i] = 0.0;
                }
            }
            block7: for (n14 = 0; n14 < nArray.length && !(instance = instances.instance(nArray[n14])).isMissing(attribute); ++n14) {
                for (n13 = 0; n13 < n5; ++n13) {
                    if (attribute.value((int)instance.value(attribute)).compareTo(stringArray2[n13]) != 0) continue;
                    double[] dArray11 = dArray10[n13];
                    int n15 = (int)instance.classValue();
                    dArray11[n15] = dArray11[n15] + instance.weight();
                    continue block7;
                }
            }
            for (n14 = 0; n14 < n5; ++n14) {
                double d2 = Utils.sum(dArray10[n14]);
                dArray9[n14] = d2 == 0.0 ? 0.0 : dArray10[n14][0] / d2;
            }
            String[] stringArray4 = new String[n5];
            for (int i = 0; i < n5; ++i) {
                stringArray4[i] = stringArray2[Utils.minIndex(dArray9)];
                dArray9[Utils.minIndex((double[])dArray9)] = Double.MAX_VALUE;
            }
            String string2 = "";
            for (n13 = 0; n13 < n5 - 1; ++n13) {
                int n16;
                Object object;
                dArray7 = new double[2][n7];
                string2 = string2 == "" ? "(" + stringArray4[n13] + ")" : string2 + "|(" + stringArray4[n13] + ")";
                for (int i = 0; i < nArray.length && !((Instance)(object = instances.instance(nArray[i]))).isMissing(attribute); ++i) {
                    if (string2.indexOf("(" + attribute.value((int)((Instance)object).value(attribute)) + ")") != -1) {
                        double[] dArray12 = dArray7[0];
                        int n17 = (int)((Instance)object).classValue();
                        dArray12[n17] = dArray12[n17] + dArray3[i];
                        continue;
                    }
                    double[] dArray13 = dArray7[1];
                    int n18 = (int)((Instance)object).classValue();
                    dArray13[n18] = dArray13[n18] + dArray3[i];
                }
                double[][] dArray14 = new double[2][n7];
                for (int i = 0; i < 2; ++i) {
                    dArray14[i] = dArray7[i];
                }
                object = new double[2];
                for (n16 = 0; n16 < 2; ++n16) {
                    object[n16] = Utils.sum(dArray14[n16]);
                }
                if (Utils.sum((double[])object) != 0.0) {
                    Utils.normalize((double[])object);
                }
                for (n16 = n8; n16 < nArray.length; ++n16) {
                    Instance instance2 = instances.instance(nArray[n16]);
                    for (int i = 0; i < 2; ++i) {
                        double[] dArray15 = dArray14[i];
                        int n19 = (int)instance2.classValue();
                        dArray15[n19] = dArray15[n19] + object[i] * dArray3[n16];
                    }
                }
                double d3 = this.computeGiniGain(dArray6, dArray14);
                if (!(d3 > d)) continue;
                d = d3;
                string = string2;
                for (n2 = 0; n2 < 2; ++n2) {
                    System.arraycopy(dArray14[n2], 0, dArray8[n2], 0, dArray8[n2].length);
                }
            }
        } else if (!bl || n5 <= 4) {
            for (n3 = 0; n3 < (int)Math.pow(2.0, n5 - 1); ++n3) {
                int n20;
                Object object;
                int n21;
                String string3 = "";
                dArray7 = new double[2][n7];
                int n22 = n3;
                for (n21 = n5 - 1; n21 >= 0; --n21) {
                    int n23 = n22 % 2;
                    if (n23 == 1) {
                        string3 = string3 == "" ? "(" + stringArray2[n21] + ")" : string3 + "|(" + stringArray2[n21] + ")";
                    }
                    n22 /= 2;
                }
                for (n21 = 0; n21 < nArray.length && !((Instance)(object = instances.instance(nArray[n21]))).isMissing(attribute); ++n21) {
                    if (string3.indexOf("(" + attribute.value((int)((Instance)object).value(attribute)) + ")") != -1) {
                        double[] dArray16 = dArray7[0];
                        int n24 = (int)((Instance)object).classValue();
                        dArray16[n24] = dArray16[n24] + dArray3[n21];
                        continue;
                    }
                    double[] dArray17 = dArray7[1];
                    int n25 = (int)((Instance)object).classValue();
                    dArray17[n25] = dArray17[n25] + dArray3[n21];
                }
                double[][] dArray18 = new double[2][n7];
                for (int i = 0; i < 2; ++i) {
                    dArray18[i] = dArray7[i];
                }
                object = new double[2];
                for (n20 = 0; n20 < 2; ++n20) {
                    object[n20] = Utils.sum(dArray18[n20]);
                }
                if (Utils.sum((double[])object) != 0.0) {
                    Utils.normalize((double[])object);
                }
                for (n20 = n8; n20 < nArray.length; ++n20) {
                    Instance instance = instances.instance(nArray[n20]);
                    for (int i = 0; i < 2; ++i) {
                        double[] dArray19 = dArray18[i];
                        int n26 = (int)instance.classValue();
                        dArray19[n26] = dArray19[n26] + object[i] * dArray3[n20];
                    }
                }
                double d4 = this.computeGiniGain(dArray6, dArray18);
                if (!(d4 > d)) continue;
                d = d4;
                string = string3;
                for (int i = 0; i < 2; ++i) {
                    System.arraycopy(dArray18[i], 0, dArray8[i], 0, dArray8[i].length);
                }
            }
        } else {
            int n27;
            int n28;
            n3 = n5;
            int n29 = instances.numClasses();
            double[][] dArray20 = new double[n3][n29];
            int[] nArray3 = new int[n3];
            double[] dArray21 = new double[n29];
            int n30 = instances.numInstances();
            for (n28 = 0; n28 < dArray21.length; ++n28) {
                dArray21[n28] = 0.0;
            }
            for (n28 = 0; n28 < n30; ++n28) {
                Instance instance = instances.instance(n28);
                n27 = 0;
                for (int i = 0; i < n5; ++i) {
                    if (attribute.value((int)instance.value(attribute)).compareToIgnoreCase(stringArray2[i]) != 0) continue;
                    n27 = i;
                    break;
                }
                double[] dArray22 = dArray20[n27];
                int n31 = (int)instance.classValue();
                dArray22[n31] = dArray22[n31] + 1.0;
                int n32 = n27;
                nArray3[n32] = nArray3[n32] + 1;
                int n33 = (int)instance.classValue();
                dArray21[n33] = dArray21[n33] + 1.0;
            }
            for (n28 = 0; n28 < dArray20.length; ++n28) {
                for (int i = 0; i < dArray20[0].length; ++i) {
                    if (nArray3[n28] == 0) {
                        dArray20[n28][i] = 0.0;
                        continue;
                    }
                    double[] dArray23 = dArray20[n28];
                    int n34 = i;
                    dArray23[n34] = dArray23[n34] / (double)nArray3[n28];
                }
            }
            n28 = 0;
            while (n28 < dArray21.length) {
                int n35 = n28++;
                dArray21[n35] = dArray21[n35] / (double)n30;
            }
            double[][] dArray24 = new double[n29][n29];
            for (int i = 0; i < n29; ++i) {
                for (n27 = 0; n27 < n29; ++n27) {
                    double d5 = 0.0;
                    for (int j = 0; j < n3; ++j) {
                        d5 += (dArray20[j][n27] - dArray21[n27]) * (dArray20[j][i] - dArray21[i]) * (double)nArray3[j];
                    }
                    dArray24[i][n27] = d5;
                }
            }
            Matrix matrix = new Matrix(dArray24);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
            double[] dArray25 = eigenvalueDecomposition.getRealEigenvalues();
            n2 = 0;
            double d6 = dArray25[0];
            for (int i = 1; i < dArray25.length; ++i) {
                if (!(dArray25[i] > d6)) continue;
                n2 = i;
                d6 = dArray25[i];
            }
            double[] dArray26 = new double[n29];
            Matrix matrix2 = eigenvalueDecomposition.getV();
            double[][] dArray27 = matrix2.getArray();
            for (int i = 0; i < dArray26.length; ++i) {
                dArray26[i] = dArray27[i][n2];
            }
            double[] dArray28 = new double[n3];
            for (int i = 0; i < dArray28.length; ++i) {
                dArray28[i] = 0.0;
                for (int j = 0; j < n29; ++j) {
                    int n36 = i;
                    dArray28[n36] = dArray28[n36] + dArray26[j] * dArray20[i][j];
                }
            }
            double[] dArray29 = new double[n3];
            System.arraycopy(dArray28, 0, dArray29, 0, n3);
            String[] stringArray5 = new String[n3];
            Arrays.sort(dArray28);
            for (int i = 0; i < n3; ++i) {
                stringArray5[i] = stringArray2[Utils.minIndex(dArray29)];
                dArray29[Utils.minIndex((double[])dArray29)] = Double.MAX_VALUE;
            }
            String string4 = "";
            for (int i = 0; i < n5 - 1; ++i) {
                int n37;
                Object object;
                dArray7 = new double[2][n7];
                string4 = string4 == "" ? "(" + stringArray5[i] + ")" : string4 + "|(" + stringArray5[i] + ")";
                for (int j = 0; j < nArray.length && !((Instance)(object = instances.instance(nArray[j]))).isMissing(attribute); ++j) {
                    if (string4.indexOf("(" + attribute.value((int)((Instance)object).value(attribute)) + ")") != -1) {
                        double[] dArray30 = dArray7[0];
                        int n38 = (int)((Instance)object).classValue();
                        dArray30[n38] = dArray30[n38] + dArray3[j];
                        continue;
                    }
                    double[] dArray31 = dArray7[1];
                    int n39 = (int)((Instance)object).classValue();
                    dArray31[n39] = dArray31[n39] + dArray3[j];
                }
                double[][] dArray32 = new double[2][n7];
                for (int j = 0; j < 2; ++j) {
                    dArray32[j] = dArray7[j];
                }
                object = new double[2];
                for (n37 = 0; n37 < 2; ++n37) {
                    object[n37] = Utils.sum(dArray32[n37]);
                }
                if (Utils.sum((double[])object) != 0.0) {
                    Utils.normalize((double[])object);
                }
                for (n37 = n8; n37 < nArray.length; ++n37) {
                    Instance instance = instances.instance(nArray[n37]);
                    for (int j = 0; j < 2; ++j) {
                        double[] dArray33 = dArray32[j];
                        int n40 = (int)instance.classValue();
                        dArray33[n40] = dArray33[n40] + object[j] * dArray3[n37];
                    }
                }
                double d7 = this.computeGiniGain(dArray6, dArray32);
                if (!(d7 > d)) continue;
                d = d7;
                string = string4;
                for (int j = 0; j < 2; ++j) {
                    System.arraycopy(dArray32[j], 0, dArray8[j], 0, dArray8[j].length);
                }
            }
        }
        int n41 = attribute.index();
        dArray[n41] = new double[2];
        for (n = 0; n < 2; ++n) {
            dArray[n41][n] = Utils.sum(dArray8[n]);
        }
        if (!(Utils.sum(dArray[n41]) > 0.0)) {
            for (n = 0; n < dArray[n41].length; ++n) {
                dArray[n41][n] = 1.0 / (double)dArray[n41].length;
            }
        } else {
            Utils.normalize(dArray[n41]);
        }
        dArray4[n41] = new double[2];
        for (n = 0; n < 2; ++n) {
            double[] dArray34 = dArray4[n41];
            int n42 = n;
            dArray34[n42] = dArray34[n42] + Utils.sum(dArray8[n]);
        }
        for (n = 0; n < n4; ++n) {
            if (!(dArray[n41][0] >= dArray[n41][1])) continue;
            string = string == "" ? "(" + stringArray3[n] + ")" : string + "|(" + stringArray3[n] + ")";
        }
        dArray5[n41] = Math.rint(d * 1.0E7) / 1.0E7;
        dArray2[n41] = dArray8;
        return string;
    }

    protected void splitData(int[][][] nArray, double[][][] dArray, Attribute attribute, double d, String string, int[][] nArray2, double[][] dArray2, Instances instances) throws Exception {
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int n;
            if (i == instances.classIndex()) continue;
            int[] nArray3 = new int[2];
            for (n = 0; n < 2; ++n) {
                nArray[n][i] = new int[nArray2[i].length];
                dArray[n][i] = new double[dArray2[i].length];
            }
            for (int j = 0; j < nArray2[i].length; ++j) {
                int n2;
                Instance instance = instances.instance(nArray2[i][j]);
                if (instance.isMissing(attribute)) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        if (!(this.m_Props[n2] > 0.0)) continue;
                        nArray[n2][i][nArray3[n2]] = nArray2[i][j];
                        dArray[n2][i][nArray3[n2]] = this.m_Props[n2] * dArray2[i][j];
                        int n3 = n2;
                        nArray3[n3] = nArray3[n3] + 1;
                    }
                    continue;
                }
                n2 = attribute.isNumeric() ? (instance.value(attribute) < d ? 0 : 1) : (string.indexOf("(" + attribute.value((int)instance.value(attribute.index())) + ")") != -1 ? 0 : 1);
                nArray[n2][i][nArray3[n2]] = nArray2[i][j];
                dArray[n2][i][nArray3[n2]] = dArray2[i][j];
                int n4 = n2;
                nArray3[n4] = nArray3[n4] + 1;
            }
            for (n = 0; n < 2; ++n) {
                int[] nArray4 = new int[nArray3[n]];
                System.arraycopy(nArray[n][i], 0, nArray4, 0, nArray3[n]);
                nArray[n][i] = nArray4;
                double[] dArray3 = new double[nArray3[n]];
                System.arraycopy(dArray[n][i], 0, dArray3, 0, nArray3[n]);
                dArray[n][i] = dArray3;
            }
        }
    }

    public void modelErrors() throws Exception {
        Evaluation evaluation = new Evaluation(this.m_train);
        if (!this.m_isLeaf) {
            this.m_isLeaf = true;
            evaluation.evaluateModel(this, this.m_train);
            this.m_numIncorrectModel = evaluation.incorrect();
            this.m_isLeaf = false;
            for (int i = 0; i < this.m_Successors.length; ++i) {
                this.m_Successors[i].modelErrors();
            }
        } else {
            evaluation.evaluateModel(this, this.m_train);
            this.m_numIncorrectModel = evaluation.incorrect();
        }
    }

    public void treeErrors() throws Exception {
        if (this.m_isLeaf) {
            this.m_numIncorrectTree = this.m_numIncorrectModel;
        } else {
            this.m_numIncorrectTree = 0.0;
            for (int i = 0; i < this.m_Successors.length; ++i) {
                this.m_Successors[i].treeErrors();
                this.m_numIncorrectTree += this.m_Successors[i].m_numIncorrectTree;
            }
        }
    }

    public void calculateAlphas() throws Exception {
        if (!this.m_isLeaf) {
            double d = this.m_numIncorrectModel - this.m_numIncorrectTree;
            if (d <= 0.0) {
                this.makeLeaf(this.m_train);
                this.m_Alpha = Double.MAX_VALUE;
            } else {
                this.m_Alpha = (d /= (double)this.m_totalTrainInstances) / (double)(this.numLeaves() - 1);
                long l = Math.round(this.m_Alpha * Math.pow(10.0, 10.0));
                this.m_Alpha = (double)l / Math.pow(10.0, 10.0);
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    this.m_Successors[i].calculateAlphas();
                }
            }
        } else {
            this.m_Alpha = Double.MAX_VALUE;
        }
    }

    protected SimpleCart nodeToPrune(Vector vector) {
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (SimpleCart)vector.elementAt(0);
        }
        SimpleCart simpleCart = (SimpleCart)vector.elementAt(0);
        double d = simpleCart.m_Alpha;
        for (int i = 1; i < vector.size(); ++i) {
            SimpleCart simpleCart2 = (SimpleCart)vector.elementAt(i);
            if (simpleCart2.m_Alpha < d) {
                d = simpleCart2.m_Alpha;
                simpleCart = simpleCart2;
                continue;
            }
            if (simpleCart2.m_Alpha != d || simpleCart2.numLeaves() <= simpleCart.numLeaves()) continue;
            simpleCart = simpleCart2;
        }
        return simpleCart;
    }

    protected double computeSortedInfo(Instances instances, int[][] nArray, double[][] dArray, double[] dArray2) throws Exception {
        Instance instance;
        int n;
        double[] dArray3 = new double[instances.numInstances()];
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int n2;
            if (i == instances.classIndex()) continue;
            dArray[i] = new double[instances.numInstances()];
            if (instances.attribute(i).isNominal()) {
                nArray[i] = new int[instances.numInstances()];
                n2 = 0;
                for (n = 0; n < instances.numInstances(); ++n) {
                    instance = instances.instance(n);
                    if (instance.isMissing(i)) continue;
                    nArray[i][n2] = n;
                    dArray[i][n2] = instance.weight();
                    ++n2;
                }
                for (n = 0; n < instances.numInstances(); ++n) {
                    instance = instances.instance(n);
                    if (!instance.isMissing(i)) continue;
                    nArray[i][n2] = n;
                    dArray[i][n2] = instance.weight();
                    ++n2;
                }
                continue;
            }
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                Instance instance2 = instances.instance(n2);
                dArray3[n2] = instance2.value(i);
            }
            nArray[i] = Utils.sort(dArray3);
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                dArray[i][n2] = instances.instance(nArray[i][n2]).weight();
            }
        }
        double d = 0.0;
        for (n = 0; n < instances.numInstances(); ++n) {
            instance = instances.instance(n);
            int n3 = (int)instance.classValue();
            dArray2[n3] = dArray2[n3] + instance.weight();
            d += instance.weight();
        }
        return d;
    }

    protected double computeGiniGain(double[] dArray, double[][] dArray2) {
        double d = Utils.sum(dArray);
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = Utils.sum(dArray2[0]);
        double d3 = Utils.sum(dArray2[1]);
        double d4 = this.computeGini(dArray, d);
        double d5 = this.computeGini(dArray2[0], d2);
        double d6 = this.computeGini(dArray2[1], d3);
        return d4 - d2 / d * d5 - d3 / d * d6;
    }

    protected double computeGini(double[] dArray, double d) {
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i] / d * (dArray[i] / d);
        }
        return 1.0 - d2;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.m_isLeaf) {
            if (instance.isMissing(this.m_Attribute)) {
                double[] dArray = new double[this.m_ClassProbs.length];
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    double[] dArray2 = this.m_Successors[i].distributionForInstance(instance);
                    if (dArray2 == null) continue;
                    for (int j = 0; j < dArray2.length; ++j) {
                        int n = j;
                        dArray[n] = dArray[n] + this.m_Props[i] * dArray2[j];
                    }
                }
                return dArray;
            }
            if (this.m_Attribute.isNominal()) {
                if (this.m_SplitString.indexOf("(" + this.m_Attribute.value((int)instance.value(this.m_Attribute)) + ")") != -1) {
                    return this.m_Successors[0].distributionForInstance(instance);
                }
                return this.m_Successors[1].distributionForInstance(instance);
            }
            if (instance.value(this.m_Attribute) < this.m_SplitValue) {
                return this.m_Successors[0].distributionForInstance(instance);
            }
            return this.m_Successors[1].distributionForInstance(instance);
        }
        return this.m_ClassProbs;
    }

    protected void makeLeaf(Instances instances) {
        this.m_Attribute = null;
        this.m_isLeaf = true;
        this.m_ClassValue = Utils.maxIndex(this.m_ClassProbs);
        this.m_ClassAttribute = instances.classAttribute();
    }

    public String toString() {
        if (this.m_ClassProbs == null && this.m_Successors == null) {
            return "CART Tree: No model built yet.";
        }
        return "CART Decision Tree\n" + this.toString(0) + "\n\n" + "Number of Leaf Nodes: " + this.numLeaves() + "\n\n" + "Size of the Tree: " + this.numNodes();
    }

    protected String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Attribute == null) {
            if (Instance.isMissingValue(this.m_ClassValue)) {
                stringBuffer.append(": null");
            } else {
                double d = (double)((int)(this.m_Distribution[Utils.maxIndex(this.m_Distribution)] * 100.0)) / 100.0;
                double d2 = (double)((int)((Utils.sum(this.m_Distribution) - this.m_Distribution[Utils.maxIndex(this.m_Distribution)]) * 100.0)) / 100.0;
                String string = "(" + d + "/" + d2 + ")";
                stringBuffer.append(": " + this.m_ClassAttribute.value((int)this.m_ClassValue) + string);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                stringBuffer.append("\n");
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append("|  ");
                }
                if (i == 0) {
                    if (this.m_Attribute.isNumeric()) {
                        stringBuffer.append(this.m_Attribute.name() + " < " + this.m_SplitValue);
                    } else {
                        stringBuffer.append(this.m_Attribute.name() + "=" + this.m_SplitString);
                    }
                } else if (this.m_Attribute.isNumeric()) {
                    stringBuffer.append(this.m_Attribute.name() + " >= " + this.m_SplitValue);
                } else {
                    stringBuffer.append(this.m_Attribute.name() + "!=" + this.m_SplitString);
                }
                stringBuffer.append(this.m_Successors[i].toString(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public int numNodes() {
        if (this.m_isLeaf) {
            return 1;
        }
        int n = 1;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            n += this.m_Successors[i].numNodes();
        }
        return n;
    }

    public int numInnerNodes() {
        if (this.m_Attribute == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            n += this.m_Successors[i].numInnerNodes();
        }
        return n;
    }

    protected Vector getInnerNodes() {
        Vector vector = new Vector();
        this.fillInnerNodes(vector);
        return vector;
    }

    protected void fillInnerNodes(Vector vector) {
        if (!this.m_isLeaf) {
            vector.add(this);
            for (int i = 0; i < this.m_Successors.length; ++i) {
                this.m_Successors[i].fillInnerNodes(vector);
            }
        }
    }

    public int numLeaves() {
        if (this.m_isLeaf) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            n += this.m_Successors[i].numLeaves();
        }
        return n;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe minimal number of instances at the terminal nodes.\n\t(default 2)", "M", 1, "-M <min no>"));
        vector.addElement(new Option("\tThe number of folds used in the minimal cost-complexity pruning.\n\t(default 5)", "N", 1, "-N <num folds>"));
        vector.addElement(new Option("\tDon't use the minimal cost-complexity pruning.\n\t(default yes).", "U", 0, "-U"));
        vector.addElement(new Option("\tDon't use the heuristic method for binary split.\n\t(default true).", "H", 0, "-H"));
        vector.addElement(new Option("\tUse 1 SE rule to make pruning decision.\n\t(default no).", "A", 0, "-A"));
        vector.addElement(new Option("\tPercentage of training data size (0-1].\n\t(default 1).", "C", 1, "-C"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMinNumObj(Double.parseDouble(string));
        } else {
            this.setMinNumObj(2.0);
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumFoldsPruning(Integer.parseInt(string));
        } else {
            this.setNumFoldsPruning(5);
        }
        this.setUsePrune(!Utils.getFlag('U', stringArray));
        this.setHeuristic(!Utils.getFlag('H', stringArray));
        this.setUseOneSE(Utils.getFlag('A', stringArray));
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setSizePer(Double.parseDouble(string));
        } else {
            this.setSizePer(1.0);
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-M");
        vector.add("" + this.getMinNumObj());
        vector.add("-N");
        vector.add("" + this.getNumFoldsPruning());
        if (!this.getUsePrune()) {
            vector.add("-U");
        }
        if (!this.getHeuristic()) {
            vector.add("-H");
        }
        if (this.getUseOneSE()) {
            vector.add("-A");
        }
        vector.add("-C");
        vector.add("" + this.getSizePer());
        return vector.toArray(new String[vector.size()]);
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("measureTreeSize");
        return vector.elements();
    }

    public double measureTreeSize() {
        return this.numNodes();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        throw new IllegalArgumentException(string + " not supported (Cart pruning)");
    }

    public String minNumObjTipText() {
        return "The minimal number of observations at the terminal nodes (default 2).";
    }

    public void setMinNumObj(double d) {
        this.m_minNumObj = d;
    }

    public double getMinNumObj() {
        return this.m_minNumObj;
    }

    public String numFoldsPruningTipText() {
        return "The number of folds in the internal cross-validation (default 5).";
    }

    public void setNumFoldsPruning(int n) {
        this.m_numFoldsPruning = n;
    }

    public int getNumFoldsPruning() {
        return this.m_numFoldsPruning;
    }

    public String usePruneTipText() {
        return "Use minimal cost-complexity pruning (default yes).";
    }

    public void setUsePrune(boolean bl) {
        this.m_Prune = bl;
    }

    public boolean getUsePrune() {
        return this.m_Prune;
    }

    public String heuristicTipText() {
        return "If heuristic search is used for binary split for nominal attributes in multi-class problems (default yes).";
    }

    public void setHeuristic(boolean bl) {
        this.m_Heuristic = bl;
    }

    public boolean getHeuristic() {
        return this.m_Heuristic;
    }

    public String useOneSETipText() {
        return "Use the 1SE rule to make pruning decisoin.";
    }

    public void setUseOneSE(boolean bl) {
        this.m_UseOneSE = bl;
    }

    public boolean getUseOneSE() {
        return this.m_UseOneSE;
    }

    public String sizePerTipText() {
        return "The percentage of the training set size (0-1, 0 not included).";
    }

    public void setSizePer(double d) {
        if (d <= 0.0 || d > 1.0) {
            System.err.println("The percentage of the training set size must be in range 0 to 1 (0 not included) - ignored!");
        } else {
            this.m_SizePer = d;
        }
    }

    public double getSizePer() {
        return this.m_SizePer;
    }

    public static void main(String[] stringArray) {
        SimpleCart.runClassifier(new SimpleCart(), stringArray);
    }
}

