/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.BartlettApproximation;
import ec.tstoolkit.arima.LinearModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimators;

public final class WienerKolmogorovDiagnostics {
    private Matrix m_tac;
    private Matrix m_eac;
    private Matrix m_sdvar;
    private ArimaModel[] m_stcmp;
    private LinearModel[] m_stest;
    private double[][] m_stdata;

    public static WienerKolmogorovDiagnostics make(UcarimaModel model, double err, double[][] data, int[] cmps) {
        int n = cmps.length;
        if (data.length != n) {
            return null;
        }
        WienerKolmogorovDiagnostics diags = new WienerKolmogorovDiagnostics();
        WienerKolmogorovEstimators wk = new WienerKolmogorovEstimators(model);
        double[][] stdata = new double[n][];
        ArimaModel[] stmodels = new ArimaModel[n];
        LinearModel[] emodels = new LinearModel[n];
        int ndata = data[0].length;
        for (int i = 0; i < n; ++i) {
            if (data[i] == null) continue;
            ArimaModel cur = null;
            boolean signal = cmps[i] > 0;
            int icmp = signal ? cmps[i] - 1 : -cmps[i] - 1;
            cur = model.getComponent(icmp);
            if (cur.isNull()) continue;
            if (!signal) {
                cur = model.getComplement(icmp);
            }
            StationaryTransformation stmodel = cur.stationaryTransformation();
            double[] curst = new double[ndata - stmodel.unitRoots.getDegree()];
            DataBlock out = new DataBlock(curst);
            stmodel.unitRoots.filter(new DataBlock(data[i]), out);
            out.sub(out.sum() / (double)out.getLength());
            stdata[i] = curst;
            emodels[i] = (LinearModel)wk.finalStationaryEstimator((int)icmp, (boolean)signal).stationaryModel;
            stmodels[i] = (ArimaModel)stmodel.stationaryModel;
        }
        if (diags.test(emodels, err, stdata)) {
            diags.m_stcmp = stmodels;
            diags.m_stest = emodels;
            diags.m_stdata = stdata;
            return diags;
        }
        return null;
    }

    private WienerKolmogorovDiagnostics() {
    }

    private boolean test(LinearModel[] stmodels, double err, double[][] stdata) {
        try {
            int n = stmodels.length;
            if (n != stdata.length) {
                return false;
            }
            this.m_eac = new Matrix(n, n);
            this.m_tac = new Matrix(n, n);
            this.m_sdvar = new Matrix(n, n);
            for (int i = 0; i < n; ++i) {
                if (stmodels[i] == null) continue;
                double[] itmp = stdata[i];
                BartlettApproximation bartlett = new BartlettApproximation();
                bartlett.setX(stmodels[i]);
                double sdvar = bartlett.SDVar(itmp.length);
                double evar = DescriptiveStatistics.var(itmp, 0, itmp.length) / (err * err);
                double var = bartlett.autoCovariance(0);
                this.m_tac.set(i, i, var);
                this.m_eac.set(i, i, evar);
                this.m_sdvar.set(i, i, sdvar);
                for (int j = i + 1; j < n; ++j) {
                    double[] jtmp = stdata[j];
                    if (jtmp == null) continue;
                    int ni = itmp.length;
                    int nj = jtmp.length;
                    int si = 0;
                    int sj = 0;
                    int nc = 0;
                    if (ni < nj) {
                        nc = ni;
                        sj = nj - ni;
                    } else {
                        nc = nj;
                        si = ni - nj;
                    }
                    bartlett.setY(stmodels[j]);
                    double cov = bartlett.crossCorrelation(0);
                    double sdcov = bartlett.SDCrossCorrelation(nc, 0);
                    double vi = DescriptiveStatistics.var(itmp, si, nc);
                    double vj = DescriptiveStatistics.var(jtmp, sj, nc);
                    double cvij = DescriptiveStatistics.cov(itmp, si, jtmp, sj, nc);
                    double ecov = cvij / Math.sqrt(vi * vj);
                    this.m_tac.set(i, j, cov);
                    this.m_tac.set(j, i, cov);
                    this.m_sdvar.set(i, j, sdcov);
                    this.m_sdvar.set(j, i, sdcov);
                    this.m_eac.set(i, j, ecov);
                    this.m_eac.set(j, i, ecov);
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public double getPValue(int i) {
        if (this.m_stcmp[i] == null) {
            return Double.NaN;
        }
        Normal dist = new Normal();
        double z = Math.abs(this.m_tac.get(i, i) - this.m_eac.get(i, i)) / this.m_sdvar.get(i, i);
        return 1.0 - dist.getProbabilityForInterval(-z, z);
    }

    public double getPValue(int i, int j) {
        if (this.m_stcmp[i] == null || this.m_stcmp[j] == null) {
            return Double.NaN;
        }
        Normal dist = new Normal();
        double z = Math.abs(this.m_tac.get(i, j) - this.m_eac.get(i, j)) / this.m_sdvar.get(i, j);
        return 1.0 - dist.getProbabilityForInterval(-z, z);
    }

    public double getEstimatorVariance(int i) {
        if (this.m_stcmp[i] == null) {
            return Double.NaN;
        }
        return this.m_tac.get(i, i);
    }

    public double getEstimateVariance(int i) {
        if (this.m_stcmp[i] == null) {
            return Double.NaN;
        }
        return this.m_eac.get(i, i);
    }

    public double getEstimatorSDVariance(int i) {
        if (this.m_stcmp[i] == null) {
            return Double.NaN;
        }
        return this.m_sdvar.get(i, i);
    }

    public double getEstimatorCrossCorrelation(int i, int j) {
        if (this.m_stcmp[i] == null || this.m_stcmp[j] == null) {
            return Double.NaN;
        }
        return this.m_tac.get(i, j);
    }

    public double getEstimateCrossCorrelation(int i, int j) {
        if (this.m_stcmp[i] == null || this.m_stcmp[j] == null) {
            return Double.NaN;
        }
        return this.m_eac.get(i, j);
    }

    public double getEstimatorSDCrossCorrelation(int i, int j) {
        if (this.m_stcmp[i] == null || this.m_stcmp[j] == null) {
            return Double.NaN;
        }
        return this.m_sdvar.get(i, j);
    }

    public ArimaModel getStationaryComponentModel(int i) {
        return this.m_stcmp[i];
    }

    public LinearModel getStationaryEstimatorModel(int i) {
        return this.m_stest[i];
    }

    public IReadDataBlock getStationaryEstimate(int i) {
        return new ReadDataBlock(this.m_stdata[i]);
    }
}

