/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;

public class ADFTest {
    private static final double[] tnc_01 = new double[]{-2.56574, -2.2358, -3.627};
    private static final double[] tnc_05 = new double[]{-1.941, -0.2686, -3.365, 31.223};
    private static final double[] tnc_10 = new double[]{-1.61682, 0.2656, -2.714, 25.364};
    private static final double[] tc_01 = new double[]{-3.43035, -6.5393, -16.786, -79.433};
    private static final double[] tc_05 = new double[]{-2.86154, -2.8903, -4.234, -40.04};
    private static final double[] tc_10 = new double[]{-2.56677, -1.5384, -2.809};
    private static final double[] lt_01 = new double[]{-3.95877, -9.0531, -28.428, -134.155};
    private static final double[] lt_05 = new double[]{-3.41049, -4.3904, -9.036, -45.374};
    private static final double[] lt_10 = new double[]{-3.12705, -2.5856, -3.925, -22.38};
    private int k = 1;
    private boolean cnt;
    private boolean trend;
    private Matrix x;
    private DataBlock y;
    private DataBlock b;
    private DataBlock e;
    private double t;

    public void test(IReadDataBlock data) {
        this.createVariables(data);
        Householder qr = new Householder(true);
        qr.decompose(this.x);
        qr.leastSquares(this.y, this.b, this.e);
        int nlast = this.b.getLength() - 1;
        double ssq = this.e.ssq();
        double val = this.b.get(nlast);
        double std = Math.abs(Math.sqrt(ssq / (double)this.e.getLength()) / qr.getRDiagonal().get(nlast));
        this.t = val / std;
    }

    public boolean isSignificant(double eps) {
        if (!this.cnt && !this.trend) {
            return this.sign00(eps);
        }
        if (!this.trend) {
            return this.sign10(eps);
        }
        return this.sign11(eps);
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        if (k < 1) {
            throw new IllegalArgumentException("k should be greater or equal to 1");
        }
        this.k = k;
    }

    private void createVariables(IReadDataBlock data) {
        int ndata = data.getLength();
        int ncols = this.k;
        if (this.cnt) {
            ++ncols;
        }
        if (this.trend) {
            ++ncols;
        }
        this.x = new Matrix(ndata - this.k, ncols);
        DataBlock all = new DataBlock(data);
        DataBlockIterator columns = this.x.columns();
        columns.end();
        DataBlock col = columns.getData();
        col.copy(all.extract(this.k - 1, ndata - this.k));
        columns.previous();
        all.difference();
        this.y = all.drop(this.k, 0);
        for (int i = 1; i < this.k; ++i) {
            col.copy(all.extract(this.k - i, ndata - this.k));
            columns.previous();
        }
        if (this.cnt) {
            col.set(1.0);
            columns.previous();
        }
        if (this.trend) {
            col.set(t -> t);
        }
        this.b = new DataBlock(ncols);
        this.e = new DataBlock(ndata - this.k - ncols);
    }

    public Matrix getX() {
        return this.x;
    }

    public DataBlock getY() {
        return this.y;
    }

    public DataBlock getB() {
        return this.b;
    }

    public DataBlock getE() {
        return this.e;
    }

    public double getT() {
        return this.t;
    }

    public boolean isConstant() {
        return this.cnt;
    }

    public void setConstant(boolean cnt) {
        this.cnt = cnt;
    }

    public boolean isTrend() {
        return this.trend;
    }

    public void setTrend(boolean trend) {
        this.trend = trend;
    }

    public static double thresholdnc(double eps, int n) {
        double[] w = null;
        if (eps == 0.01) {
            w = tnc_01;
        } else if (eps == 0.05) {
            w = tnc_05;
        } else if (eps == 0.1) {
            w = tnc_10;
        }
        if (w == null) {
            return Double.NaN;
        }
        double q = n;
        double s = w[0] + w[1] / q;
        for (int i = 2; i < w.length; ++i) {
            s += w[i] / (q *= (double)n);
        }
        return s;
    }

    public static double thresholdc(double eps, int n) {
        double[] w = null;
        if (eps == 0.01) {
            w = tc_01;
        } else if (eps == 0.05) {
            w = tc_05;
        } else if (eps == 0.1) {
            w = tc_10;
        }
        if (w == null) {
            return Double.NaN;
        }
        double q = n;
        double s = w[0] + w[1] / q;
        for (int i = 2; i < w.length; ++i) {
            s += w[i] / (q *= (double)n);
        }
        return s;
    }

    public static double thresholdt(double eps, int n) {
        double[] w = null;
        if (eps == 0.01) {
            w = lt_01;
        } else if (eps == 0.05) {
            w = lt_05;
        } else if (eps == 0.1) {
            w = lt_10;
        }
        if (w == null) {
            return Double.NaN;
        }
        double q = n;
        double s = w[0] + w[1] / q;
        for (int i = 2; i < w.length; ++i) {
            s += w[i] / (q *= (double)n);
        }
        return s;
    }

    private boolean sign10(double eps) {
        double th = ADFTest.thresholdc(eps, this.e.getLength());
        return this.t <= th;
    }

    private boolean sign00(double eps) {
        double th = ADFTest.thresholdnc(eps, this.e.getLength());
        return this.t <= th;
    }

    private boolean sign11(double eps) {
        double th = ADFTest.thresholdt(eps, this.e.getLength());
        return this.t <= th;
    }
}

