/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class ParamComboBoxWidget
extends ParamWidget {
    protected JComboBox comboBox;

    public ParamComboBoxWidget() {
    }

    public ParamComboBoxWidget(Param param) {
        this.setModel(param);
    }

    public void setModel(Param param) {
        this.model = param;
        this.initAsComboBox(param.getViewType().equals("org.rosuda.deducer.widgets.param.ParamEditableComboBoxWidget"));
        this.label.setText(param.getTitle());
        if (param.getValue() != null && (param.getLabels() == null || param.getViewType().equals("org.rosuda.deducer.widgets.param.ParamEditableComboBoxWidget"))) {
            this.comboBox.setSelectedItem(param.getValue().toString());
        } else if (param.getValue() != null && param.getLabels() != null) {
            for (int i = 0; i < param.getOptions().length; ++i) {
                if (!param.getValue().toString().equals(param.getOptions()[i])) continue;
                this.comboBox.setSelectedIndex(i + 1);
            }
        }
    }

    public void updateModel() {
        String string = (String)this.comboBox.getSelectedItem();
        int n = this.comboBox.getSelectedIndex();
        if (n > 0) {
            string = this.model.getOptions()[n - 1];
        }
        if (string != null && string.length() > 0) {
            this.model.setValue(string);
        } else {
            this.model.setValue(null);
        }
    }

    public Param getModel() {
        this.updateModel();
        return this.model;
    }

    protected void initAsComboBox(boolean bl) {
        this.removeAll();
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.setPreferredSize(new Dimension(241, 37));
        int n = 58;
        this.label = new JLabel();
        this.add((Component)this.label, new AnchorConstraint(202, 234, 689, 12, 1, 0, 0, 2));
        if (this.model != null) {
            this.label.setText(this.model.getTitle());
            n = SwingUtilities.computeStringWidth(this.label.getFontMetrics(this.label.getFont()), this.model.getTitle());
        }
        int n2 = Math.max(n + 22, 80);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(null);
        if (this.model != null) {
            int n3;
            if (this.model.getOptions() != null && this.model.getLabels() != null) {
                for (n3 = 0; n3 < this.model.getOptions().length; ++n3) {
                    defaultComboBoxModel.addElement(this.model.getOptions()[n3] + "  :  " + this.model.getLabels()[n3]);
                }
            }
            if (this.model.getOptions() != null && this.model.getLabels() == null) {
                for (n3 = 0; n3 < this.model.getOptions().length; ++n3) {
                    defaultComboBoxModel.addElement(this.model.getOptions()[n3]);
                }
            }
        }
        this.comboBox = new JComboBox();
        this.add((Component)this.comboBox, new AnchorConstraint(148, 12, 743, n2, 1, 2, 0, 2));
        this.comboBox.setEditable(bl);
        this.comboBox.setModel(defaultComboBoxModel);
        this.comboBox.setPreferredSize(new Dimension(122, 22));
        this.setPreferredSize(new Dimension(200, 30));
        this.setMaximumSize(new Dimension(2000, 30));
    }
}

