/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.models.GLMDialog;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.models.LogisticBuilder;
import org.rosuda.deducer.models.LogisticDialogSplit;
import org.rosuda.deducer.models.LogisticDialogSplitModel;
import org.rosuda.deducer.models.LogisticModel;
import org.rosuda.deducer.toolkit.HelpButton;

public class LogisticDialog
extends GLMDialog {
    JButton split;
    JLabel splitDef;
    LogisticDialog theDialog = this;
    public static LogisticModel lastLogisticModel;

    public LogisticDialog(JDialog jDialog, GLMModel gLMModel) {
        super(jDialog, gLMModel);
        this.help.setUrl(HelpButton.baseUrl + "pmwiki.php?n=Main.LogisticModel");
        this.startRefresher();
    }

    public LogisticDialog(JFrame jFrame, GLMModel gLMModel) {
        super(jFrame, gLMModel);
        this.help.setUrl(HelpButton.baseUrl + "pmwiki.php?n=Main.LogisticModel");
        this.startRefresher();
    }

    public LogisticDialog(GLMModel gLMModel) {
        super(gLMModel);
        this.help.setUrl(HelpButton.baseUrl + "pmwiki.php?n=Main.LogisticModel");
        this.startRefresher();
    }

    public LogisticDialog(JFrame jFrame) {
        this(jFrame, (GLMModel)(lastLogisticModel == null ? new LogisticModel() : lastLogisticModel));
    }

    protected void initGUI() {
        super.initGUI();
        this.getContentPane().remove(this.contPanel);
        this.getContentPane().add((Component)this.contPanel, new AnchorConstraint(160, 978, 352, 568, 1, 1, 1, 1));
        this.split = new JButton();
        this.split.setText("Split");
        this.split.setSize(100, 32);
        this.split.addActionListener(new SplitListener());
        this.getContentPane().add((Component)this.split, new AnchorConstraint(108, 978, 352, 575, 1, 0, 0, 1));
        this.splitDef = new JLabel();
        this.splitDef.setText("");
        this.splitDef.setSize(100, 32);
        this.splitDef.setVerticalTextPosition(0);
        this.getContentPane().add((Component)this.splitDef, new AnchorConstraint(115, 995, 352, 710, 1, 1, 0, 1));
        this.type.setSelectedItem("binomial()");
        this.type.setVisible(false);
        this.typeLabel.setVisible(false);
        this.setTitle("Logistic Regression Model");
    }

    public void startRefresher() {
        String string = this.outcome.getModel().getSize() != 0 ? (String)this.outcome.getModel().getElementAt(0) : "";
        new Thread(new Refresher(string)).start();
        if (((LogisticModel)this.model).split != null) {
            this.splitDef.setText(((LogisticModel)this.model).split.getLHS());
        }
    }

    public void resetModel() {
        this.setModel(new LogisticModel());
    }

    public void setModel(GLMModel gLMModel) {
        if (!(gLMModel instanceof LogisticModel)) {
            this.setModel(new LogisticModel());
        } else {
            super.setModel(gLMModel);
        }
    }

    public void updateModel() {
        super.updateModel();
        this.model.outcomes = new DefaultListModel();
        this.model.outcomes.addElement(this.splitDef.getText());
    }

    public void continueClicked() {
        if (!this.valid()) {
            return;
        }
        this.updateModel();
        LogisticBuilder logisticBuilder = new LogisticBuilder(this.model);
        logisticBuilder.setLocationRelativeTo(this);
        logisticBuilder.setVisible(true);
        WindowTracker.addWindow(logisticBuilder);
        this.dispose();
    }

    public static void setLastModel(GLMModel gLMModel) {
        if (gLMModel instanceof LogisticModel) {
            lastLogisticModel = (LogisticModel)gLMModel;
        } else {
            new ErrorMsg("Invalid cast in LogisticDialog.setLastModel");
        }
    }

    class Refresher
    implements Runnable {
        String variableName = "";

        public Refresher(String string) {
            this.variableName = string;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        Runnable runnable = new Runnable(){

                            public void run() {
                                if (((Refresher)Refresher.this).LogisticDialog.this.outcome.getModel().getSize() == 0) {
                                    if (Refresher.this.variableName != "") {
                                        ((Refresher)Refresher.this).LogisticDialog.this.splitDef.setText("");
                                        ((LogisticModel)((Refresher)Refresher.this).LogisticDialog.this.model).split = null;
                                        Refresher.this.variableName = "";
                                    }
                                } else if (!Refresher.this.variableName.equals(((Refresher)Refresher.this).LogisticDialog.this.outcome.getModel().getElementAt(0))) {
                                    ((LogisticModel)((Refresher)Refresher.this).LogisticDialog.this.model).split = new LogisticDialogSplitModel(((Refresher)Refresher.this).LogisticDialog.this.variableSelector.getSelectedData() + "$" + (String)((Refresher)Refresher.this).LogisticDialog.this.outcome.getModel().getElementAt(0));
                                    ((Refresher)Refresher.this).LogisticDialog.this.splitDef.setText(((LogisticModel)((Refresher)Refresher.this).LogisticDialog.this.model).split.getLHS());
                                    Refresher.this.variableName = (String)((Refresher)Refresher.this).LogisticDialog.this.outcome.getModel().getElementAt(0);
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                    continue;
                }
                break;
            }
        }
    }

    class SplitListener
    implements ActionListener {
        SplitListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (LogisticDialog.this.outcome.getModel().getSize() == 0) {
                    return;
                }
                if (((LogisticModel)LogisticDialog.this.model).split == null || !((LogisticModel)LogisticDialog.this.model).split.variable.equals(LogisticDialog.this.variableSelector.getSelectedData() + "$" + (String)LogisticDialog.this.outcome.getModel().getElementAt(0))) {
                    ((LogisticModel)LogisticDialog.this.model).split = new LogisticDialogSplitModel(LogisticDialog.this.variableSelector.getSelectedData() + "$" + (String)LogisticDialog.this.outcome.getModel().getElementAt(0));
                }
                LogisticDialogSplit logisticDialogSplit = new LogisticDialogSplit(LogisticDialog.this.theDialog, ((LogisticModel)LogisticDialog.this.model).split);
                logisticDialogSplit.setLocationRelativeTo(LogisticDialog.this.split);
                logisticDialogSplit.setVisible(true);
                LogisticDialog.this.splitDef.setText(((LogisticModel)LogisticDialog.this.model).split.getLHS());
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }
    }
}

