/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

import dr.inference.hmc.ReversibleHMCProvider;
import dr.inference.model.Likelihood;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.GeneralOperator;
import dr.math.matrixAlgebra.WrappedVector;

public class SplitHamiltonianMonteCarloOperator
extends AbstractAdaptableOperator
implements GeneralOperator {
    private double stepSize;
    private double relativeScale;
    private ReversibleHMCProvider reversibleHMCProviderA;
    private ReversibleHMCProvider reversibleHMCProviderB;
    private int nSteps;
    private int innerSteps;

    public SplitHamiltonianMonteCarloOperator(double d, ReversibleHMCProvider reversibleHMCProvider, ReversibleHMCProvider reversibleHMCProvider2, double d2, double d3, int n, int n2) {
        this.setWeight(d);
        this.reversibleHMCProviderA = reversibleHMCProvider;
        this.reversibleHMCProviderB = reversibleHMCProvider2;
        this.stepSize = d2;
        this.relativeScale = d3;
        this.nSteps = n;
        this.innerSteps = n2;
    }

    @Override
    public double doOperation(Likelihood likelihood) {
        return this.mergedUpdate();
    }

    private double mergedUpdate() {
        double[] dArray = this.reversibleHMCProviderA.getInitialPosition();
        double[] dArray2 = this.reversibleHMCProviderB.getInitialPosition();
        WrappedVector.Raw raw = new WrappedVector.Raw(dArray);
        WrappedVector.Raw raw2 = new WrappedVector.Raw(dArray2);
        WrappedVector wrappedVector = this.reversibleHMCProviderA.drawMomentum();
        WrappedVector wrappedVector2 = this.reversibleHMCProviderB.drawMomentum();
        double d = this.reversibleHMCProviderA.getKineticEnergy(wrappedVector) + this.reversibleHMCProviderB.getKineticEnergy(wrappedVector2) + this.reversibleHMCProviderA.getParameterLogJacobian() + this.reversibleHMCProviderB.getParameterLogJacobian();
        for (int i = 0; i < this.nSteps; ++i) {
            int n;
            for (n = 0; n < this.innerSteps; ++n) {
                this.reversibleHMCProviderB.reversiblePositionMomentumUpdate(raw2, wrappedVector2, 1, this.stepSize);
            }
            this.reversibleHMCProviderA.reversiblePositionMomentumUpdate(raw, wrappedVector, 1, this.relativeScale * this.stepSize);
            for (n = 0; n < this.innerSteps; ++n) {
                this.reversibleHMCProviderB.reversiblePositionMomentumUpdate(raw2, wrappedVector2, 1, this.stepSize);
            }
        }
        double d2 = this.reversibleHMCProviderA.getKineticEnergy(wrappedVector) + this.reversibleHMCProviderB.getKineticEnergy(wrappedVector2) + this.reversibleHMCProviderA.getParameterLogJacobian() + this.reversibleHMCProviderB.getParameterLogJacobian();
        return d - d2;
    }

    @Override
    public double doOperation() {
        throw new RuntimeException("Should not be executed");
    }

    @Override
    public String getOperatorName() {
        return "Split HMC operator";
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
    }

    @Override
    protected double getAdaptableParameterValue() {
        return 1.0;
    }

    @Override
    public double getRawParameter() {
        return 1.0;
    }

    @Override
    public String getAdaptableParameterName() {
        return null;
    }
}

