/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.distributions.RandomGenerator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class GenericIndependentSampler
extends SimpleMCMCOperator {
    public static final String OPERATOR_NAME = "genericIndependentSampler";
    private final Variable<Double> variable;
    private final RandomGenerator randomGenerator;
    private final boolean univariate;
    private final int generatorLength;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(RandomGenerator.class), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return GenericIndependentSampler.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            RandomGenerator randomGenerator = (RandomGenerator)xMLObject.getChild(RandomGenerator.class);
            return new GenericIndependentSampler(parameter, randomGenerator, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an independence sampler from a provided generic distribution generator.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }
    };

    public GenericIndependentSampler(Variable variable, RandomGenerator randomGenerator, double d) {
        this.variable = variable;
        this.randomGenerator = randomGenerator;
        Object object = randomGenerator.nextRandom();
        if (object instanceof Double) {
            this.generatorLength = 1;
            this.univariate = true;
        } else if (object instanceof double[]) {
            this.generatorLength = ((double[])object).length;
            this.univariate = false;
        } else {
            throw new IllegalArgumentException("Unknown random generator in " + this.getOperatorName());
        }
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "genericIndependentSampler(" + this.variable.getVariableName() + ")";
    }

    @Override
    public double doOperation() {
        double d = 0.0;
        Bounds<Double> bounds = this.variable.getBounds();
        int n = this.variable.getSize();
        for (int i = 0; i < n; i += this.generatorLength) {
            int n2;
            int n3;
            Object object = this.randomGenerator.nextRandom();
            if (this.univariate) {
                double d2 = this.variable.getValue(i);
                double d3 = (Double)object;
                d += this.randomGenerator.logPdf(d2) - this.randomGenerator.logPdf(d3);
                if (!(d3 < bounds.getLowerLimit(i)) && !(d3 > bounds.getUpperLimit(i))) continue;
                return Double.NEGATIVE_INFINITY;
            }
            double[] dArray = new double[this.generatorLength];
            double[] dArray2 = (double[])object;
            for (n3 = 0; n3 < this.generatorLength; ++n3) {
                n2 = i * this.generatorLength + n3;
                dArray[n3] = this.variable.getValue(n2);
            }
            d += this.randomGenerator.logPdf(dArray) - this.randomGenerator.logPdf(dArray2);
            for (n3 = 0; n3 < this.generatorLength; ++n3) {
                n2 = i * this.generatorLength + n3;
                if (dArray2[n3] < bounds.getLowerLimit(n2) || dArray2[n3] > bounds.getUpperLimit(n2)) {
                    return Double.NEGATIVE_INFINITY;
                }
                this.variable.setValue(n2, dArray2[n3]);
            }
        }
        return d;
    }
}

