/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Statistic;
import dr.xml.Reportable;

public interface CrossValidationProvider {
    public double[] getTrueValues();

    public double[] getInferredValues();

    public int[] getRelevantDimensions();

    public String getName(int var1);

    public String getNameSum(int var1);

    public static enum ValidationType {
        SQUARED_ERROR("squaredError"){

            @Override
            void updateValues(CrossValidator crossValidator) {
                BIAS.updateValues(crossValidator);
                for (int i = 0; i < crossValidator.dimStat; ++i) {
                    double d = crossValidator.statValues[i];
                    ((CrossValidator)crossValidator).statValues[i] = d * d;
                }
            }
        }
        ,
        BIAS("bias"){

            @Override
            void updateValues(CrossValidator crossValidator) {
                CrossValidator.access$302(crossValidator, crossValidator.provider.getTrueValues());
                CrossValidator.access$402(crossValidator, crossValidator.provider.getInferredValues());
                for (int i = 0; i < crossValidator.dimStat; ++i) {
                    double d;
                    double d2 = crossValidator.truthValues[crossValidator.relevantDims[i]];
                    double d3 = crossValidator.inferredValues[crossValidator.relevantDims[i]];
                    ((CrossValidator)crossValidator).statValues[i] = d = d2 - d3;
                }
            }
        }
        ,
        VALUE("value"){

            @Override
            void updateValues(CrossValidator crossValidator) {
                CrossValidator.access$402(crossValidator, crossValidator.provider.getInferredValues());
                for (int i = 0; i < crossValidator.dimStat; ++i) {
                    double d;
                    ((CrossValidator)crossValidator).statValues[i] = d = crossValidator.inferredValues[crossValidator.relevantDims[i]];
                }
            }
        };

        private final String name;

        private ValidationType(String string2) {
            this.name = string2;
        }

        abstract void updateValues(CrossValidator var1);

        public String getName() {
            return this.name;
        }
    }

    public static class CrossValidatorSum
    extends CrossValidator {
        public CrossValidatorSum(CrossValidationProvider crossValidationProvider, ValidationType validationType) {
            super(crossValidationProvider, validationType);
        }

        @Override
        public String getDimensionName(int n) {
            return this.provider.getNameSum(n);
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            double d = 0.0;
            for (int i = 0; i < super.getDimension(); ++i) {
                d += super.getStatisticValue(i);
            }
            return d;
        }
    }

    public static class CrossValidator
    extends Statistic.Abstract
    implements Reportable {
        protected final CrossValidationProvider provider;
        private final double[] statValues;
        private final int[] relevantDims;
        private double[] truthValues;
        private double[] inferredValues;
        private final int dimStat;
        private final ValidationType validationType;

        public CrossValidator(CrossValidationProvider crossValidationProvider, ValidationType validationType) {
            this.provider = crossValidationProvider;
            this.relevantDims = crossValidationProvider.getRelevantDimensions();
            this.dimStat = this.relevantDims.length;
            this.statValues = new double[this.dimStat];
            this.validationType = validationType;
        }

        @Override
        public String getDimensionName(int n) {
            return this.provider.getName(n);
        }

        @Override
        public int getDimension() {
            return this.dimStat;
        }

        @Override
        public double getStatisticValue(int n) {
            if (n == 0) {
                this.validationType.updateValues(this);
            }
            return this.statValues[n];
        }

        @Override
        public String getReport() {
            int n;
            int n2 = 100000;
            double[] dArray = new double[this.dimStat];
            for (int i = 0; i < n2; ++i) {
                for (n = 0; n < this.dimStat; ++n) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.getStatisticValue(n);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cross Validation Report:\n\n");
            for (n = 0; n < this.dimStat; ++n) {
                stringBuilder.append("\t" + this.getDimensionName(n) + ": " + dArray[n] / (double)n2 + "\n");
            }
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }

        static /* synthetic */ double[] access$302(CrossValidator crossValidator, double[] dArray) {
            crossValidator.truthValues = dArray;
            return dArray;
        }

        static /* synthetic */ double[] access$402(CrossValidator crossValidator, double[] dArray) {
            crossValidator.inferredValues = dArray;
            return dArray;
        }
    }
}

